/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;

public abstract class AbstractSocket
extends Socket {
    private boolean closed;
    private String host;
    private int port;
    private boolean shutIn;
    private boolean shutOut;

    public AbstractSocket() {
    }

    public AbstractSocket(String host, int port) throws UnknownHostException, IOException {
        super(host, port);
        this.host = host;
        this.port = port;
    }

    public AbstractSocket(InetAddress host, int port) throws UnknownHostException, IOException {
        super(host, port);
        this.host = host.getHostName();
        this.port = port;
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        throw new UnsupportedOperationException();
    }

    public final void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IOException("Not an InetSocketAddress");
        }
        if (this.isConnected()) {
            throw new SocketException("Socket is already connected");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.onConnect((InetSocketAddress)endpoint, timeout);
    }

    protected abstract void onConnect(InetSocketAddress var1, int var2) throws IOException;

    public final synchronized void close() throws IOException {
        try {
            this.doClose();
        }
        finally {
            this.closed = true;
        }
    }

    protected abstract void doClose() throws IOException;

    public boolean isBound() {
        return false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isInputShutdown() {
        return this.shutIn;
    }

    public boolean isOutputShutdown() {
        return this.shutOut;
    }

    public void sendUrgentData(int data) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        throw new UnsupportedOperationException();
    }

    public void setOOBInline(boolean on) throws SocketException {
        throw new UnsupportedOperationException();
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        throw new UnsupportedOperationException();
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        throw new UnsupportedOperationException();
    }

    public void setReuseAddress(boolean on) throws SocketException {
        throw new UnsupportedOperationException();
    }

    public synchronized void setSendBufferSize(int size) throws SocketException {
        throw new UnsupportedOperationException();
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        throw new UnsupportedOperationException();
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        throw new UnsupportedOperationException();
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        throw new UnsupportedOperationException();
    }

    public void setTrafficClass(int tc) throws SocketException {
        throw new UnsupportedOperationException();
    }

    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is already shutdown");
        }
        this.getInputStream().close();
        this.shutIn = true;
    }

    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is already shutdown");
        }
        this.getOutputStream().close();
        this.shutOut = true;
    }

    public SocketChannel getChannel() {
        return null;
    }

    public InetAddress getInetAddress() {
        return null;
    }

    public boolean getKeepAlive() throws SocketException {
        return false;
    }

    public boolean getOOBInline() throws SocketException {
        return false;
    }

    public int getPort() {
        return this.port;
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return 0;
    }

    public boolean getReuseAddress() throws SocketException {
        return false;
    }

    public synchronized int getSendBufferSize() throws SocketException {
        return 0;
    }

    public int getSoLinger() throws SocketException {
        return 0;
    }

    public synchronized int getSoTimeout() throws SocketException {
        return 0;
    }

    public boolean getTcpNoDelay() throws SocketException {
        return false;
    }

    public int getTrafficClass() throws SocketException {
        return 0;
    }

    public String toString() {
        return "SSH Socket to " + this.host + ":" + this.port;
    }
}

