/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi;

import java.util.List;
import net.sf.sshapi.Capability;
import net.sf.sshapi.SshClient;
import net.sf.sshapi.SshConfiguration;
import net.sf.sshapi.SshException;
import net.sf.sshapi.SshProvider;
import net.sf.sshapi.SshProxyServerDetails;
import net.sf.sshapi.agent.SshAgent;
import net.sf.sshapi.hostkeys.SshHostKeyManager;
import net.sf.sshapi.identity.SshIdentityManager;

public abstract class AbstractProvider
implements SshProvider {
    private boolean supportsDefaultConfiguration = true;
    private final String name;

    protected AbstractProvider(String name) {
        this.name = name;
    }

    protected void setSupportsDefaultConfiguration(boolean supportsDefaultConfiguration) {
        this.supportsDefaultConfiguration = supportsDefaultConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public final boolean supportsConfiguration(SshConfiguration configuration) {
        try {
            this.doSupportsConfiguration(configuration);
            this.checkDefaultConfiguration(configuration);
            return true;
        }
        catch (UnsupportedOperationException ueo) {
            return false;
        }
    }

    public final SshClient createClient(SshConfiguration configuration) {
        this.doSupportsConfiguration(configuration);
        this.checkDefaultConfiguration(configuration);
        SshClient client = this.doCreateClient(configuration);
        client.init(this);
        return client;
    }

    protected abstract void doSupportsConfiguration(SshConfiguration var1);

    protected abstract SshClient doCreateClient(SshConfiguration var1);

    private void checkDefaultConfiguration(SshConfiguration configuration) {
        if (configuration == null) {
            if (this.supportsDefaultConfiguration) {
                return;
            }
            throw new UnsupportedOperationException("Default configuration is not supported. You must supply a configuration.");
        }
        configuration.providerHasCapabilities(this);
        AbstractProvider.check(configuration.getPreferredClientToServerCipher(), this.getSupportedCiphers(configuration.getProtocolVersion()));
        AbstractProvider.check(configuration.getPreferredServerToClientCipher(), this.getSupportedCiphers(configuration.getProtocolVersion()));
        AbstractProvider.check(configuration.getPreferredClientToServerMAC(), this.getSupportedMAC());
        AbstractProvider.check(configuration.getPreferredServerToClientMAC(), this.getSupportedMAC());
        AbstractProvider.check(configuration.getPreferredClientToServerCompression(), this.getSupportedCompression());
        AbstractProvider.check(configuration.getPreferredServerToClientCompression(), this.getSupportedCompression());
        if (configuration.getProxyServer() != null) {
            SshProxyServerDetails proxy = configuration.getProxyServer();
            if (proxy.getType().equals(SshProxyServerDetails.Type.HTTP) && !this.getCapabilities().contains(Capability.HTTP_PROXY)) {
                throw new UnsupportedOperationException("HTTP proxy is not supported.");
            }
            if (proxy.getType().equals(SshProxyServerDetails.Type.SOCKS4) && !this.getCapabilities().contains(Capability.SOCKS4_PROXY)) {
                throw new UnsupportedOperationException("SOCKS4 proxy is not supported.");
            }
            if (proxy.getType().equals(SshProxyServerDetails.Type.SOCKS5) && !this.getCapabilities().contains(Capability.SOCKS5_PROXY)) {
                throw new UnsupportedOperationException("SOCKS5 proxy is not supported.");
            }
        }
    }

    public SshIdentityManager createIdentityManager(SshConfiguration configuration) {
        throw new UnsupportedOperationException();
    }

    public SshHostKeyManager createHostKeyManager(SshConfiguration configuration) throws SshException {
        throw new UnsupportedOperationException();
    }

    public SshAgent connectToLocalAgent(String application, String location, int socketType, int protocol) throws SshException {
        throw new UnsupportedOperationException();
    }

    public SshAgent connectToLocalAgent(String application, int protocol) throws SshException {
        throw new UnsupportedOperationException();
    }

    public SshAgent connectToLocalAgent(String application) throws SshException {
        return this.connectToLocalAgent(application, 2);
    }

    static boolean check(String name, List list) {
        boolean ok;
        boolean bl = ok = name == null || list.contains(name) || name.equals("none");
        if (!ok) {
            throw new UnsupportedOperationException("Capability " + name + " is not one of " + list);
        }
        return ok;
    }
}

