/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.sshapi.SshChannelHandler;
import net.sf.sshapi.SshClient;
import net.sf.sshapi.SshConfiguration;
import net.sf.sshapi.SshException;
import net.sf.sshapi.SshProvider;
import net.sf.sshapi.auth.SshAuthenticator;
import net.sf.sshapi.forwarding.SshPortForwardListener;
import net.sf.sshapi.forwarding.SshPortForwardTunnel;
import net.sf.sshapi.identity.SshPublicKeySubsystem;

public abstract class AbstractClient
implements SshClient {
    private SshProvider provider;
    private SshConfiguration configuration;
    private List portForwardlisteners = new ArrayList();

    public AbstractClient(SshConfiguration configuration) {
        this.configuration = configuration;
    }

    public synchronized void addPortForwardListener(SshPortForwardListener listener) {
        this.portForwardlisteners.add(listener);
    }

    public synchronized void removePortForwardListener(SshPortForwardListener listener) {
        this.portForwardlisteners.remove(listener);
    }

    public SshConfiguration getConfiguration() {
        return this.configuration;
    }

    public final void init(SshProvider provider) {
        this.provider = provider;
    }

    public final SshProvider getProvider() {
        return this.provider;
    }

    public final boolean authenticate(SshAuthenticator authenticator) throws SshException {
        return this.authenticate(new SshAuthenticator[]{authenticator});
    }

    public void addChannelHandler(SshChannelHandler channelFactory) throws SshException {
        throw new UnsupportedOperationException("Channel factories are not supported in this implementation.");
    }

    public void removeChannelHandler(SshChannelHandler channelFactory) throws SshException {
        throw new UnsupportedOperationException("Channel factories are not supported in this implementation.");
    }

    protected Map createAuthenticatorMap(SshAuthenticator[] authenticators) {
        HashMap<String, SshAuthenticator> authenticatorMap = new HashMap<String, SshAuthenticator>();
        for (int i = 0; i < authenticators.length; ++i) {
            if (authenticatorMap.containsKey(authenticators[i].getTypeName())) {
                throw new IllegalArgumentException("Two authenticators using the name '" + authenticators[i].getTypeName() + "' have been provided.");
            }
            authenticatorMap.put(authenticators[i].getTypeName(), authenticators[i]);
        }
        return authenticatorMap;
    }

    protected void firePortForwardChannelOpened(int type, SshPortForwardTunnel channel) {
        Iterator i = new ArrayList(this.portForwardlisteners).iterator();
        while (i.hasNext()) {
            ((SshPortForwardListener)i.next()).channelOpened(type, channel);
        }
    }

    protected void firePortForwardChannelClosed(int type, SshPortForwardTunnel channel) {
        Iterator i = new ArrayList(this.portForwardlisteners).iterator();
        while (i.hasNext()) {
            ((SshPortForwardListener)i.next()).channelClosed(type, channel);
        }
    }

    public SshPublicKeySubsystem createPublicKeySubsystem() throws SshException {
        throw new UnsupportedOperationException();
    }

    public void setTimeout(int timeout) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int getTimeout() throws IOException {
        throw new UnsupportedOperationException();
    }
}

