/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.x509;

import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.SshPublicKeyFactory;
import com.sshtools.common.ssh.components.SshX509PublicKey;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPublicKey;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPublicKey;

public class SshX509RsaSha1PublicKey
extends Ssh2RsaPublicKey
implements SshX509PublicKey {
    public static final String X509V3_SIGN_RSA_SHA1 = "x509v3-sign-rsa-sha1";
    Certificate cert;

    public SshX509RsaSha1PublicKey() {
    }

    public SshX509RsaSha1PublicKey(Certificate cert) {
        super((RSAPublicKey)cert.getPublicKey());
        this.cert = cert;
    }

    public String getAlgorithm() {
        return X509V3_SIGN_RSA_SHA1;
    }

    public byte[] getEncoded() throws SshException {
        ByteArrayWriter baw = new ByteArrayWriter();
        try {
            baw.writeString(this.getAlgorithm());
            baw.writeBinaryString(this.cert.getEncoded());
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
        catch (Throwable ex) {
            throw new SshException("Failed to encoded key data", 5, ex);
        }
        finally {
            try {
                baw.close();
            }
            catch (IOException iOException) {}
        }
    }

    public SshPublicKey init(byte[] blob, int start, int len) throws SshException {
        try (ByteArrayReader bar = new ByteArrayReader(blob, start, len);){
            String header = bar.readString();
            if (!header.equals(X509V3_SIGN_RSA_SHA1)) {
                throw new SshException("The encoded key is not X509 RSA", 5);
            }
            byte[] encoded = bar.readBinaryString();
            ByteArrayInputStream is = new ByteArrayInputStream(encoded);
            CertificateFactory cf = JCEProvider.getProviderForAlgorithm((String)"X.509") == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", JCEProvider.getProviderForAlgorithm((String)"X.509"));
            this.cert = cf.generateCertificate(is);
            if (!(this.cert.getPublicKey() instanceof RSAPublicKey)) {
                throw new SshException("Certificate public key is not an RSA public key!", 4);
            }
            this.pubKey = (RSAPublicKey)this.cert.getPublicKey();
        }
        return this;
    }

    public Certificate getCertificate() {
        return this.cert;
    }

    public Certificate[] getCertificateChain() {
        return new Certificate[]{this.cert};
    }

    public static class SshX509RsaSha1PublicKeyFactory
    implements SshPublicKeyFactory<SshX509RsaSha1PublicKey> {
        public SshX509RsaSha1PublicKey create() throws NoSuchAlgorithmException, IOException {
            return new SshX509RsaSha1PublicKey();
        }

        public String[] getKeys() {
            return new String[]{SshX509RsaSha1PublicKey.X509V3_SIGN_RSA_SHA1};
        }
    }
}

