/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.x509;

import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.SshPublicKeyFactory;
import com.sshtools.common.ssh.components.SshX509PublicKey;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPublicKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPublicKey;

public class SshX509RsaPublicKey
extends Ssh2RsaPublicKey
implements SshX509PublicKey {
    public static final String X509V3_SIGN_RSA = "x509v3-sign-rsa";
    Certificate cert;

    public SshX509RsaPublicKey() {
    }

    public SshX509RsaPublicKey(Certificate cert) {
        super((RSAPublicKey)cert.getPublicKey());
        this.cert = cert;
    }

    public String getAlgorithm() {
        return X509V3_SIGN_RSA;
    }

    public String getSigningAlgorithm() {
        return this.getAlgorithm();
    }

    public byte[] getEncoded() throws SshException {
        try {
            return this.cert.getEncoded();
        }
        catch (Throwable ex) {
            throw new SshException("Failed to encoded key data", 5, ex);
        }
    }

    public SshPublicKey init(byte[] blob, int start, int len) throws SshException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(blob, start, len);
            CertificateFactory cf = JCEProvider.getProviderForAlgorithm((String)"X.509") == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", JCEProvider.getProviderForAlgorithm((String)"X.509"));
            this.cert = cf.generateCertificate(is);
            if (!(this.cert.getPublicKey() instanceof RSAPublicKey)) {
                throw new SshException("Certificate public key is not an RSA public key!", 4);
            }
            this.pubKey = (RSAPublicKey)this.cert.getPublicKey();
        }
        catch (Throwable ex) {
            throw new SshException(ex.getMessage(), 16, ex);
        }
        return this;
    }

    public Certificate getCertificate() {
        return this.cert;
    }

    public Certificate[] getCertificateChain() {
        return new Certificate[]{this.cert};
    }

    public static class SshX509RsaPublicKeyFactory
    implements SshPublicKeyFactory<SshX509RsaPublicKey> {
        public SshX509RsaPublicKey create() throws NoSuchAlgorithmException, IOException {
            return new SshX509RsaPublicKey();
        }

        public String[] getKeys() {
            return new String[]{SshX509RsaPublicKey.X509V3_SIGN_RSA};
        }
    }
}

