/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands.sftp;

import com.sshtools.client.sftp.SftpFile;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.SshException;
import com.sshtools.server.vsession.CliHelper;
import com.sshtools.server.vsession.UsageException;
import com.sshtools.server.vsession.UsageHelper;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.server.vsession.commands.sftp.SftpCommand;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;

public class Ls
extends SftpCommand {
    private static final String LISTING_LONG_EXTENDED = "extended";
    private static final String LISTING_LONG_ALL = "all";
    private static final String LISTING_LONG_DIRECTORY = "directory";
    private static final String LISTING_LONG_LONG = "long";
    private static final String LISTING_SHORT_EXTENDED = "x";
    private static final String LISTING_SHORT_ALL = "a";
    private static final String LISTING_SHORT_DIRECTORY = "d";
    private static final String LISTING_SHORT_LONG = "l";

    public Ls() {
        super("ls", "SFTP", UsageHelper.build("ls [options] path...", "-l, --long\t\t\t\t\t\t        Show details for each individual file/folder", "-a, --all                              Show all files", "-d, --directory                        List directories themeselves, not their contents", "-x, --extended                         Show extended attributes"), "List the contents of a directory.");
    }

    @Override
    public void run(String[] args, VirtualConsole console) throws IOException, PermissionDeniedException, UsageException {
        try {
            if (args.length == 1) {
                SftpFile[] sftpFiles = this.sftp.ls();
                this.processSftpFilesForPrinting(args, console, sftpFiles);
            } else {
                ArrayList<String> paths = new ArrayList<String>();
                for (int i = 1; i < args.length; ++i) {
                    if (Ls.isLsOption(args[i])) continue;
                    paths.add(args[i]);
                }
                if (paths.isEmpty()) {
                    SftpFile[] sftpFiles = this.sftp.ls();
                    this.processSftpFilesForPrinting(args, console, sftpFiles);
                } else {
                    for (String path : paths) {
                        SftpFile[] sftpFiles = this.sftp.ls(path);
                        this.processSftpFilesForPrinting(args, console, sftpFiles);
                    }
                }
            }
        }
        catch (PermissionDeniedException | SftpStatusException | SshException | IOException e) {
            throw new IllegalStateException(String.format("Problem in processing ls command with args %s", Arrays.toString(args)), e);
        }
    }

    private void processSftpFilesForPrinting(String[] args, VirtualConsole console, SftpFile[] sftpFiles) throws SftpStatusException, SshException, IOException, PermissionDeniedException {
        for (SftpFile sftpFile : sftpFiles) {
            if (sftpFile.attributes().isFile() && (Ls.isOption(args, LISTING_SHORT_DIRECTORY) || Ls.isOption(args, LISTING_LONG_DIRECTORY))) continue;
            this.printFile(args, console, sftpFile);
        }
    }

    protected void printFile(String[] args, VirtualConsole console, SftpFile file) throws IOException, PermissionDeniedException, SftpStatusException, SshException {
        SftpFileAttributes fileAttributes = file.attributes();
        if (!this.isHidden(file) || Ls.isOption(args, LISTING_SHORT_ALL) || Ls.isOption(args, LISTING_LONG_ALL)) {
            if (Ls.isOption(args, LISTING_SHORT_ALL) || Ls.isOption(args, LISTING_LONG_ALL)) {
                String lastModifiedTime = "";
                long size = 0L;
                if (file.attributes().isFile()) {
                    size = fileAttributes.size().longValue();
                } else if (fileAttributes.isDirectory()) {
                    size = 0L;
                }
                long mt = fileAttributes.lastModifiedTime().toMillis() * 1000L;
                long now = System.currentTimeMillis();
                SimpleDateFormat df = now - mt > 15552000000L ? new SimpleDateFormat("MMM dd  yyyy", console.getConnection().getLocale()) : new SimpleDateFormat("MMM dd HH:mm", console.getConnection().getLocale());
                lastModifiedTime = df.format(new Date(mt));
                int linkCount = 0;
                console.println(String.format("%s %-3d %-8s %-8s %10d %-14s %-30s", fileAttributes.toPermissionsString(), linkCount, fileAttributes.bestUsername(), fileAttributes.bestGroup(), size, lastModifiedTime, file.getFilename()));
            } else {
                console.println(file.getFilename());
            }
            if (Ls.isOption(args, LISTING_SHORT_EXTENDED) || Ls.isOption(args, LISTING_LONG_EXTENDED)) {
                for (String name : fileAttributes.extendedAttributes().keySet()) {
                    byte[] val = (byte[])fileAttributes.extendedAttributes().get(name);
                    console.println(String.format("%" + (CliHelper.hasShortOption(args, 'l') ? 64 : 4) + "s%s", "", name.toString() + "=" + (val == null ? "" : val.toString())));
                }
            }
        }
    }

    private boolean isHidden(SftpFile sftpFile) throws SftpStatusException, SshException {
        SftpFileAttributes fileAttributes = sftpFile.attributes();
        if (fileAttributes.hasAttributeBits() && fileAttributes.isHidden()) {
            return true;
        }
        return sftpFile.getFilename().startsWith(".");
    }

    private static boolean isOption(String[] args, String option) {
        for (String arg : args) {
            if (arg.startsWith("--")) {
                String value = arg.substring(2);
                return Ls.isMatchinLongOptionValue(option, value);
            }
            if (!arg.startsWith("-")) continue;
            String value = arg.substring(1);
            return Ls.isMatchinShortOption(option, value);
        }
        return false;
    }

    private static boolean isMatchinShortOption(String option, String value) {
        String[] parts = value.split("");
        boolean result = false;
        for (String part : parts) {
            switch (option) {
                case "l": {
                    result = Ls.isShortL(part);
                    break;
                }
                case "d": {
                    result = Ls.isShortD(part);
                    break;
                }
                case "a": {
                    result = Ls.isShortA(part);
                    break;
                }
                case "x": {
                    result = Ls.isShortX(part);
                    break;
                }
                default: {
                    result = false;
                }
            }
            if (!result) continue;
            return true;
        }
        return result;
    }

    private static boolean isMatchinLongOptionValue(String option, String value) {
        switch (option) {
            case "long": {
                return Ls.isLongL(value);
            }
            case "directory": {
                return Ls.isLongD(value);
            }
            case "all": {
                return Ls.isLongA(value);
            }
            case "extended": {
                return Ls.isLongX(value);
            }
        }
        return false;
    }

    private static boolean isLsOption(String arg) {
        if (arg.startsWith("--")) {
            return Ls.isLsLongOption(arg.substring(2));
        }
        if (arg.startsWith("-")) {
            return Ls.isLsShortOption(arg.substring(1));
        }
        return false;
    }

    private static boolean isLsLongOption(String arg) {
        return Ls.isLongL(arg) || Ls.isLongD(arg) || Ls.isLongA(arg) || Ls.isLongX(arg);
    }

    private static boolean isLsShortOption(String arg) {
        String[] parts;
        for (String part : parts = arg.split("")) {
            if (!Ls.isShortL(part) && !Ls.isShortD(part) && !Ls.isShortA(part) && !Ls.isShortX(part)) continue;
            return true;
        }
        return false;
    }

    private static boolean isShortL(String value) {
        return Objects.equals(LISTING_SHORT_LONG, value);
    }

    private static boolean isShortD(String value) {
        return Objects.equals(LISTING_SHORT_DIRECTORY, value);
    }

    private static boolean isShortA(String value) {
        return Objects.equals(LISTING_SHORT_ALL, value);
    }

    private static boolean isShortX(String value) {
        return Objects.equals(LISTING_SHORT_EXTENDED, value);
    }

    private static boolean isLongL(String value) {
        return Objects.equals(LISTING_LONG_LONG, value);
    }

    private static boolean isLongD(String value) {
        return Objects.equals(LISTING_LONG_DIRECTORY, value);
    }

    private static boolean isLongA(String value) {
        return Objects.equals(LISTING_LONG_ALL, value);
    }

    private static boolean isLongX(String value) {
        return Objects.equals(LISTING_LONG_EXTENDED, value);
    }
}

