/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands.os;

import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import com.pty4j.WinSize;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ChannelEventListener;
import com.sshtools.common.util.IOUtils;
import com.sshtools.common.util.Utils;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.UsageException;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.server.vsession.VirtualShellNG;
import com.sshtools.server.vsession.commands.os.ShellUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AbstractOSCommand
extends ShellCommand {
    private PtyProcess pty;
    private Map<String, String> env;
    private File directory;
    private VirtualConsole console;

    public AbstractOSCommand(String name, String subsystem, String signature, String description) {
        super(name, subsystem, signature, description);
    }

    @Override
    public void run(String[] args, VirtualConsole console) throws IOException, PermissionDeniedException, UsageException {
        this.runCommand(null, Arrays.asList(Arrays.copyOfRange(args, 1, args.length)), console);
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    protected VirtualConsole getConsole() {
        return this.console;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCommand(String cmd, List<String> cmdArgs, VirtualConsole console) throws IOException {
        this.console = console;
        List<String> args = this.configureCommand(cmd, cmdArgs, console);
        if (cmd == null) {
            cmd = "";
        } else {
            while (cmd.startsWith("/")) {
                cmd = cmd.substring(1);
            }
        }
        this.pty = this.startPtyProcess(args);
        final InputStream in = this.pty.getInputStream();
        final OutputStream out = this.pty.getOutputStream();
        this.setScreenSize(console.getTerminal().getWidth(), console.getTerminal().getHeight());
        VirtualShellNG shell = (VirtualShellNG)console.getSessionChannel();
        VirtualShellNG.WindowSizeChangeListener listener = new VirtualShellNG.WindowSizeChangeListener(){

            @Override
            public void newSize(int rows, int cols) {
                AbstractOSCommand.this.setScreenSize(cols, rows);
            }
        };
        shell.addWindowSizeChangeListener(listener);
        console.getSessionChannel().pauseDataCaching();
        ChannelEventListener l = new ChannelEventListener(){

            public void onChannelDataIn(Channel channel, ByteBuffer buffer) {
                try {
                    AbstractOSCommand.this.writeToCommand(out, buffer);
                }
                catch (IOException e) {
                    Log.error((String)"Error writing data to pty", (Throwable)e, (Object[])new Object[0]);
                    IOUtils.closeStream((OutputStream)out);
                    IOUtils.closeStream((InputStream)in);
                }
            }
        };
        console.getSessionChannel().addEventListener(l);
        try {
            this.runInput(in, console.getSessionChannel().getOutputStream());
            int result = this.pty.waitFor();
            if (result > 0) {
                throw new IOException("System command exited with error " + result);
            }
        }
        catch (Exception e) {
            Log.error((String)"Captured error during shell input read", (Throwable)e, (Object[])new Object[0]);
        }
        finally {
            IOUtils.closeStream((OutputStream)out);
            try {
                console.getSessionChannel().resumeDataCaching();
            }
            finally {
                console.getSessionChannel().removeEventListener(l);
            }
        }
    }

    protected PtyProcess startPtyProcess(List<String> args) throws IOException {
        return this.createPtyProcess(args).start();
    }

    protected PtyProcessBuilder createPtyProcess(List<String> args) {
        if (Log.isInfoEnabled()) {
            Log.info((String)"Executing {}", (Object[])new Object[]{Utils.csv((String)" ", args)});
        }
        HashMap<String, String> penv = this.env == null ? new HashMap<String, String>(System.getenv()) : new HashMap<String, String>(this.env);
        penv.put("TERM", this.console.getTerminal().getType());
        this.configureEnvironment(penv);
        PtyProcessBuilder builder = new PtyProcessBuilder(args.toArray(new String[0]));
        if (this.directory != null) {
            builder.setDirectory(this.directory.getAbsolutePath());
        }
        builder.setConsole(false);
        builder.setEnvironment(penv);
        return builder;
    }

    protected void configureEnvironment(Map<String, String> penv) {
    }

    protected void runInput(InputStream in, OutputStream out) throws IOException {
        IOUtils.copy((InputStream)in, (OutputStream)this.console.getSessionChannel().getOutputStream());
    }

    protected void writeToCommand(OutputStream out, ByteBuffer buffer) throws IOException {
        byte[] tmp = new byte[buffer.remaining()];
        buffer.get(tmp);
        out.write(tmp);
        out.flush();
    }

    protected List<String> configureCommand(String cmd, List<String> cmdArgs, VirtualConsole console) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        String shellCommand = ShellUtils.findCommand(this.getName(), new String[0]);
        if (shellCommand == null) {
            throw new IOException("Cannot find command " + this.getName());
        }
        args.add(shellCommand);
        if (cmdArgs != null) {
            args.addAll(cmdArgs);
        }
        return args;
    }

    protected void setScreenSize(int width, int height) {
        try {
            this.pty.setWinSize(new WinSize(width, height));
        }
        catch (Exception e) {
            Log.warn((String)String.format("Could not set new terminal size of pty to %d x %d.", width, height), (Object[])new Object[0]);
        }
    }
}

