/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession;

import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.UsageException;
import com.sshtools.server.vsession.UsageHelper;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.synergy.ssh.TerminalModes;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class Term
extends ShellCommand {
    public Term() {
        super("term", "Shell", UsageHelper.build("term"), "Output information about the pseudo terminal");
    }

    @Override
    public void run(String[] args, VirtualConsole console) throws IOException, PermissionDeniedException, UsageException {
        TerminalModes modes = console.getPseudoTerminalModes();
        console.printfln("Type: %s", console.getTerminal().getType());
        console.println("Modes");
        console.println("----------------");
        for (TerminalModes.Mode mode : modes.modes().keySet()) {
            console.printfln("%s: 0x%s", StringUtils.rightPad((String)mode.name(), (int)13), Integer.toHexString(modes.get(mode)));
        }
        console.println("----------------");
    }
}

