/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession;

import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ChannelEventListener;
import com.sshtools.common.ssh.SessionChannelHelper;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.Utils;
import com.sshtools.server.vsession.CmdLine;
import com.sshtools.server.vsession.CommandFactory;
import com.sshtools.server.vsession.LineParser;
import com.sshtools.server.vsession.Msh;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.server.vsession.VirtualSessionPolicy;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;

public class RootShell
extends Msh {
    private List<CmdLine> commands;
    private VirtualConsole console;

    public RootShell(CommandFactory<ShellCommand> commandFactory, SshConnection con) throws PermissionDeniedException, IOException {
        super(commandFactory);
    }

    @Override
    public void run(String[] args, VirtualConsole console) throws IOException, PermissionDeniedException {
        this.console = console;
        VirtualConsole.setCurrentConsole(console);
        try {
            if (this.commands != null) {
                this.runAndExit(this.commands, args, console);
            } else {
                this.promptForCommands(args, console);
            }
        }
        finally {
            VirtualConsole.clearCurrentConsole();
        }
    }

    protected void promptForCommands(String[] args, VirtualConsole console) throws IOException, PermissionDeniedException {
        this.writeWelcome();
        super.run(args, console);
        console.getSessionChannel().close();
    }

    private void writeWelcome() {
        String welcomeText = ((VirtualSessionPolicy)this.console.getContext().getPolicy(VirtualSessionPolicy.class)).getWelcomeText();
        if (Utils.isNotBlank((String)welcomeText)) {
            try {
                welcomeText = welcomeText.replace("${hostname}", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                welcomeText = welcomeText.replace("${hostname}", "localhost");
            }
            welcomeText = welcomeText.replace("${productName}", "Virtual SSHD");
            welcomeText = welcomeText.replace("${username}", this.console.getConnection().getUsername());
            if (welcomeText.contains("${remote")) {
                welcomeText = welcomeText.replace("${remoteAddress}", this.console.getConnection().getRemoteIPAddress());
                welcomeText = welcomeText.replace("${remoteHost}", this.console.getConnection().getRemoteIPAddress());
                welcomeText = welcomeText.replace("${remotePort}", String.valueOf(this.console.getConnection().getRemotePort()));
            }
            if (welcomeText.contains("${local")) {
                welcomeText = welcomeText.replace("${localAddress}", this.console.getConnection().getLocalAddress().getHostAddress());
                welcomeText = welcomeText.replace("${localHost}", this.console.getConnection().getLocalAddress().getHostName());
                welcomeText = welcomeText.replace("${localPort}", String.valueOf(this.console.getConnection().getLocalPort()));
            }
            SimpleDateFormat df = new SimpleDateFormat("d MMM, yyyy");
            SimpleDateFormat tf = new SimpleDateFormat("HH:mm");
            Date date = new Date();
            welcomeText = welcomeText.replace("${version}", this.console.getConnection().getServerVersion());
            welcomeText = welcomeText.replace("${date}", df.format(date));
            welcomeText = welcomeText.replace("${time}", tf.format(date));
            if (Utils.isNotBlank((String)(welcomeText = welcomeText.replace("${year}", String.valueOf(Calendar.getInstance().get(1)))))) {
                this.console.println(welcomeText);
            }
        }
    }

    protected void runAndExit(List<CmdLine> commands, String[] args, VirtualConsole console) throws IOException {
        int exitCode = 0;
        CmdLine lastCommand = null;
        boolean exit = false;
        block3: for (CmdLine l : commands) {
            if (exit) break;
            exitCode = lastCommand == null ? 0 : lastCommand.getExitCode();
            switch (exitCode) {
                case -2147483648: 
                case 0: {
                    if (lastCommand == null || lastCommand.getCondition() != CmdLine.Condition.ExecNextCommandOnFailure) break;
                    exit = true;
                    continue block3;
                }
                default: {
                    if (lastCommand == null || lastCommand.getCondition() != CmdLine.Condition.ExecNextCommandOnSuccess) break;
                    exit = true;
                    continue block3;
                }
            }
            lastCommand = l;
            exitCode = this.spawn(console, l.getArgArray(), l.isBackground());
            l.setExitCode(exitCode);
        }
        if (exitCode == Integer.MIN_VALUE) {
            exitCode = 0;
        }
        SessionChannelHelper.sendExitStatus((Channel)console.getSessionChannel(), (int)lastCommand.getExitCode());
        console.getSessionChannel().close();
    }

    public boolean startShell(InputStream in, final VirtualConsole console) throws IOException, PermissionDeniedException {
        this.console = console;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        Enumeration<URL> en = cl.getResources("META-INF/default-profile");
        while (en.hasMoreElements()) {
            URL url = en.nextElement();
            this.source(console, url.openStream());
        }
        AbstractFile homeProfile = console.getCurrentDirectory().resolveFile(".profile");
        if (homeProfile.exists() && homeProfile.isReadable()) {
            this.source(console, homeProfile);
        }
        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777088, true).addAttribute("FILE_FACTORY", (Object)console.getCurrentDirectory().getFileFactory()).addAttribute("CONNECTION", (Object)console.getConnection()));
        console.getSessionChannel().addEventListener(new ChannelEventListener(){

            public void onChannelClose(Channel channel) {
                EventServiceImplementation.getInstance().fireEvent(new Event((Object)RootShell.this, -16777087, true).addAttribute("FILE_FACTORY", console.getFileFactory()).addAttribute("CONNECTION", (Object)console.getConnection()));
            }
        });
        return true;
    }

    @Override
    public void exit() {
        super.exit();
        this.console.getSessionChannel().close();
    }

    public void execCommand(InputStream in, VirtualConsole console, String cmd) throws IOException, PermissionDeniedException {
        this.startShell(in, console);
        LineParser lineParser = new LineParser(console.getEnvironment());
        this.commands = lineParser.parseCommands(cmd, 0);
    }

    public VirtualConsole getProcess() {
        return this.console;
    }

    public void start() {
        this.console.getConnection().executeTask(new Runnable(){

            @Override
            public void run() {
                try {
                    RootShell.this.run(new String[]{RootShell.this.getCommandName()}, RootShell.this.console);
                }
                catch (Exception e) {
                    Log.error((String)"Failed to start shell.", (Throwable)e, (Object[])new Object[0]);
                }
                finally {
                    RootShell.this.console.destroy();
                }
            }
        });
    }
}

