/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileAdapter;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.vfs.VirtualFile;
import com.sshtools.common.files.vfs.VirtualFileFactory;
import com.sshtools.common.files.vfs.VirtualMount;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.PosixPermissions;
import com.sshtools.common.sftp.SftpFileAttributes;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;

public abstract class VirtualFileObject
extends AbstractFileAdapter
implements VirtualFile {
    VirtualMount parentMount;
    Map<String, AbstractFile> mounts;
    protected VirtualFileFactory fileFactory;

    protected VirtualFileObject(VirtualFileFactory factory, VirtualMount parentMount) {
        this.fileFactory = factory;
        this.parentMount = parentMount;
    }

    public synchronized void refresh() {
        this.mounts = null;
        super.refresh();
    }

    @Override
    public VirtualMount getMount() {
        return this.parentMount;
    }

    public AbstractFileFactory<? extends AbstractFile> getFileFactory() {
        return this.fileFactory;
    }

    public SftpFileAttributes getAttributes() throws IOException, PermissionDeniedException {
        if (!this.exists()) {
            throw new FileNotFoundException();
        }
        SftpFileAttributes.SftpFileAttributesBuilder bldr = SftpFileAttributes.SftpFileAttributesBuilder.ofType((int)(this.isDirectory() ? 2 : 1), (String)"UTF-8");
        bldr.withSize(this.length());
        PosixPermissions.PosixPermissionsBuilder permBldr = PosixPermissions.PosixPermissionsBuilder.create();
        if (this.isReadable()) {
            permBldr.withAllRead();
        }
        if (this.isWritable()) {
            permBldr.withAllWrite();
        }
        if (this.isDirectory()) {
            permBldr.withAllExecute();
        }
        bldr.withPermissions(permBldr.build());
        bldr.withUid(0);
        bldr.withGid(0);
        bldr.withUsername(System.getProperty("maverick.unknownUsername", "unknown"));
        bldr.withGroup(System.getProperty("maverick.unknownUsername", "unknown"));
        bldr.withLastModifiedTime(this.lastModified());
        bldr.withLastAccessTime(this.lastModified());
        return bldr.build();
    }
}

