/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.AbstractFileRandomAccess;
import com.sshtools.common.files.vfs.PathFileFactory;
import com.sshtools.common.files.vfs.PathRandomAccessImpl;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.PosixPermissions;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@Deprecated(since="3.1.0", forRemoval=true)
public class PathFile
implements AbstractFile {
    private Path path;
    private PathFileFactory factory;

    public PathFile(Path path, PathFileFactory factory) {
        this.path = path;
        this.factory = factory;
    }

    public void copyFrom(AbstractFile src) throws IOException, PermissionDeniedException {
        Files.copy(src.getInputStream(), this.path, new CopyOption[0]);
    }

    public boolean createFolder() throws PermissionDeniedException, IOException {
        Files.createDirectory(this.path, new FileAttribute[0]);
        return this.isDirectory();
    }

    public boolean createNewFile() throws PermissionDeniedException, IOException {
        Files.createFile(this.path, new FileAttribute[0]);
        return this.isFile();
    }

    public boolean delete(boolean recursive) throws IOException, PermissionDeniedException {
        return Files.deleteIfExists(this.path);
    }

    public boolean exists() throws IOException {
        return Files.exists(this.path, LinkOption.NOFOLLOW_LINKS);
    }

    public String getAbsolutePath() throws IOException, PermissionDeniedException {
        return this.path.toString();
    }

    public SftpFileAttributes getAttributes() throws IOException {
        long mod;
        long len;
        SftpFileAttributes.SftpFileAttributesBuilder attrs;
        int type;
        block30: {
            type = this.getFileType();
            attrs = SftpFileAttributes.SftpFileAttributesBuilder.ofType((int)type, (String)"UTF-8");
            len = 0L;
            mod = 0L;
            if (type != 5) {
                mod = this.lastModified();
                len = this.length();
            }
            try {
                attrs.withGidOrGroup(String.valueOf(Files.getAttribute(this.path, "unix:gid", LinkOption.NOFOLLOW_LINKS)));
            }
            catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                // empty catch block
            }
            try {
                attrs.withGroup(String.valueOf(Files.getAttribute(this.path, "unix:group", LinkOption.NOFOLLOW_LINKS)));
            }
            catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                // empty catch block
            }
            try {
                attrs.withUidOrUsername(String.valueOf(Files.getAttribute(this.path, "unix:uid", LinkOption.NOFOLLOW_LINKS)));
            }
            catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                // empty catch block
            }
            try {
                attrs.withUsername(String.valueOf(Files.getAttribute(this.path, "unix:owner", LinkOption.NOFOLLOW_LINKS)));
            }
            catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                // empty catch block
            }
            long perm = 0L;
            try {
                Set<PosixFilePermission> perms = Files.getPosixFilePermissions(this.path, LinkOption.NOFOLLOW_LINKS);
                for (PosixFilePermission pfp : perms) {
                    switch (pfp) {
                        case OWNER_READ: {
                            perm |= 0x100L;
                            break;
                        }
                        case OWNER_WRITE: {
                            perm |= 0x80L;
                            break;
                        }
                        case OWNER_EXECUTE: {
                            perm |= 0x40L;
                            break;
                        }
                        case GROUP_READ: {
                            perm |= 0x20L;
                            break;
                        }
                        case GROUP_WRITE: {
                            perm |= 0x10L;
                            break;
                        }
                        case GROUP_EXECUTE: {
                            perm |= 8L;
                            break;
                        }
                        case OTHERS_READ: {
                            perm |= 4L;
                            break;
                        }
                        case OTHERS_WRITE: {
                            perm |= 2L;
                            break;
                        }
                        case OTHERS_EXECUTE: {
                            perm |= 1L;
                        }
                    }
                }
            }
            catch (UnsupportedOperationException uoe) {
                if (this.isReadable()) {
                    perm = perm | 0x100L | 0x20L | 4L;
                }
                if (this.isWritable()) {
                    perm = perm | 0x80L | 0x10L | 2L;
                }
                if (!Files.isExecutable(this.path)) break block30;
                perm = perm | 0x40L | 8L | 2L;
            }
        }
        switch (type) {
            case 2: {
                perm |= 0x4000L;
                break;
            }
            case 3: {
                perm |= 0xA000L;
                break;
            }
            case 1: {
                perm |= 0x8000L;
            }
        }
        attrs.withPermissions(PosixPermissions.PosixPermissionsBuilder.create().fromBitmask(mod).build());
        attrs.withSize(new UnsignedInteger64(len));
        attrs.withLastModifiedTime(mod / 1000L);
        return attrs.build();
    }

    public String getCanonicalPath() throws IOException, PermissionDeniedException {
        if (Files.exists(this.path, new LinkOption[0])) {
            return this.path.toRealPath(new LinkOption[0]).toString();
        }
        return this.path.toString();
    }

    public List<AbstractFile> getChildren() throws IOException, PermissionDeniedException {
        ArrayList<AbstractFile> l = new ArrayList<AbstractFile>();
        for (Path p : Files.newDirectoryStream(this.path)) {
            l.add(new PathFile(p, this.factory));
        }
        return l;
    }

    public AbstractFileFactory<? extends AbstractFile> getFileFactory() {
        return this.factory;
    }

    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    public String getName() {
        return this.path.getFileName().toString();
    }

    public OutputStream getOutputStream() throws IOException {
        return Files.newOutputStream(this.path, new OpenOption[0]);
    }

    public OutputStream getOutputStream(boolean append) throws IOException {
        if (append) {
            return Files.newOutputStream(this.path, StandardOpenOption.APPEND);
        }
        return Files.newOutputStream(this.path, new OpenOption[0]);
    }

    public boolean isDirectory() throws IOException {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    public boolean isFile() throws IOException {
        return Files.isRegularFile(this.path, new LinkOption[0]);
    }

    public boolean isHidden() throws IOException {
        return Files.isHidden(this.path);
    }

    public boolean isReadable() throws IOException {
        return Files.isReadable(this.path);
    }

    public boolean isWritable() throws IOException {
        return !Files.exists(this.path, new LinkOption[0]) && (this.path.getParent() == null || Files.isWritable(this.path.getParent())) || Files.isWritable(this.path);
    }

    public long lastModified() throws IOException {
        return Files.getLastModifiedTime(this.path, LinkOption.NOFOLLOW_LINKS).to(TimeUnit.MILLISECONDS);
    }

    public long length() throws IOException {
        return Files.exists(this.path, new LinkOption[0]) ? Files.size(this.path) : 0L;
    }

    public void moveTo(AbstractFile target) throws IOException, PermissionDeniedException {
        if (!(target instanceof PathFile)) {
            throw new UnsupportedOperationException();
        }
        Files.move(this.path, ((PathFile)target).path, new CopyOption[0]);
    }

    public AbstractFileRandomAccess openFile(boolean writeAccess) throws IOException {
        return new PathRandomAccessImpl(this.path, writeAccess);
    }

    public void refresh() {
    }

    public AbstractFile resolveFile(String child) throws IOException, PermissionDeniedException {
        return new PathFile(this.path.resolve(child), this.factory);
    }

    public void setAttributes(SftpFileAttributes attrs) throws IOException {
        if (attrs.hasLastModifiedTime()) {
            Files.setLastModifiedTime(this.path, FileTime.from(attrs.lastModifiedTime().toMillis(), TimeUnit.SECONDS));
        }
        if (attrs.hasGid()) {
            try {
                Files.setAttribute(this.path, "unix:gid", attrs.gid(), LinkOption.NOFOLLOW_LINKS);
            }
            catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                // empty catch block
            }
        }
        if (attrs.hasUid()) {
            try {
                Files.setAttribute(this.path, "unix:uid", attrs.uid(), LinkOption.NOFOLLOW_LINKS);
            }
            catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                // empty catch block
            }
        }
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    public void truncate() throws PermissionDeniedException, IOException {
        this.delete(false);
        this.createNewFile();
    }

    private int getFileType() throws IOException {
        if (this.isDirectory()) {
            return 2;
        }
        if (Files.isSymbolicLink(this.path)) {
            return 3;
        }
        if (Files.exists(this.path, LinkOption.NOFOLLOW_LINKS)) {
            return 1;
        }
        return 5;
    }

    public void symlinkTo(String target) throws IOException, PermissionDeniedException {
        Files.createSymbolicLink(this.path, this.factory.getFile((String)target).path, new FileAttribute[0]);
    }

    public String readSymbolicLink() throws IOException, PermissionDeniedException {
        return Files.readSymbolicLink(this.path).toString();
    }

    public AbstractFile getParentFile() throws IOException, PermissionDeniedException {
        return new PathFile(this.path.getParent(), this.factory);
    }
}

