/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.events.Event;
import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.vfs.VirtualFile;
import com.sshtools.common.files.vfs.VirtualMappedFile;
import com.sshtools.common.files.vfs.VirtualMount;
import com.sshtools.common.files.vfs.VirtualMountFile;
import com.sshtools.common.files.vfs.VirtualMountManager;
import com.sshtools.common.files.vfs.VirtualMountTemplate;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.util.FileUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.StringTokenizer;

public class VirtualFileFactory
implements AbstractFileFactory<VirtualFile> {
    protected boolean cached = true;
    protected VirtualMountManager mgr;
    Map<String, VirtualFile> cache = null;
    Map<String, VirtualMountFile> mountCache = new HashMap<String, VirtualMountFile>();

    public VirtualFileFactory(VirtualMountTemplate defaultMount, VirtualMountTemplate ... additionalMounts) throws IOException, PermissionDeniedException {
        this.mgr = new VirtualMountManager(this, defaultMount, additionalMounts);
        for (VirtualMount mount : this.mgr.getMounts()) {
            String mountPath = FileUtils.addTrailingSlash((String)mount.getMount());
            this.mountCache.put(mountPath, new VirtualMountFile(mountPath, mount, this, false));
            for (String parentPath : FileUtils.getParentPaths((String)mountPath)) {
                if (this.mountCache.containsKey(parentPath)) continue;
                this.mountCache.put(parentPath, new VirtualMountFile(FileUtils.checkEndsWithNoSlash((String)parentPath), this.mgr.getMount(parentPath), this, true));
            }
        }
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    private String canonicalisePath(String path) {
        StringTokenizer t = new StringTokenizer(path, "/", true);
        Stack<String> pathStack = new Stack<String>();
        while (t.hasMoreTokens()) {
            String e = t.nextToken();
            if (e.equals("..")) {
                if (pathStack.size() <= 1) continue;
                pathStack.pop();
                pathStack.pop();
                continue;
            }
            if (pathStack.size() > 0 && pathStack.peek() == "/" && e.equals("/")) continue;
            pathStack.push(e);
        }
        String ret = "";
        for (String e : pathStack) {
            ret = ret + e;
        }
        if (!ret.startsWith("/")) {
            ret = FileUtils.addTrailingSlash((String)this.mgr.getDefaultMount().getMount()) + ret;
        }
        return ret;
    }

    public Map<String, VirtualFile> resolveChildren(VirtualFile parent) throws PermissionDeniedException, IOException {
        HashMap<String, VirtualFile> files = new HashMap<String, VirtualFile>();
        AbstractFile file = parent.resolveFile();
        if (file.exists()) {
            for (AbstractFile child : file.getChildren()) {
                files.put(child.getName(), new VirtualMappedFile(child, parent.getMount(), this));
            }
        }
        String currentPath = FileUtils.checkEndsWithSlash((String)parent.getAbsolutePath());
        for (VirtualMount m : this.mgr.getMounts(currentPath)) {
            String mountPath = FileUtils.checkEndsWithSlash((String)m.getMount());
            if (!mountPath.startsWith(currentPath) || mountPath.equals(currentPath)) continue;
            String childPath = FileUtils.checkEndsWithNoSlash((String)mountPath.substring(currentPath.length()));
            List childPaths = FileUtils.getParentPaths((String)childPath);
            boolean intermediate = false;
            intermediate = !childPaths.isEmpty();
            if (intermediate) {
                childPath = FileUtils.checkEndsWithNoSlash((String)((String)childPaths.get(0)));
            }
            files.put(childPath, new VirtualMountFile(currentPath + childPath, parent.getMount(), this, intermediate));
        }
        return files;
    }

    public VirtualFile getFile(String path) throws PermissionDeniedException, IOException {
        String mountPath;
        VirtualFile mountFile;
        String virtualPath = path.equals("") ? this.mgr.getDefaultMount().getMount() : this.canonicalisePath(path);
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Resolved the following mounts for the path {}", (Object[])new Object[]{path});
            for (VirtualMountFile m : this.mountCache.values()) {
                Log.debug((String)"Mount {}", (Object[])new Object[]{m.getAbsolutePath()});
            }
        }
        if (!virtualPath.equals("") && this.mountCache.size() > 0 && Objects.nonNull(mountFile = (VirtualFile)this.mountCache.get(mountPath = FileUtils.addTrailingSlash((String)virtualPath)))) {
            return mountFile;
        }
        if (!virtualPath.equals("/")) {
            virtualPath = FileUtils.removeTrailingSlash((String)virtualPath);
        }
        VirtualMount m = this.mgr.getMount(virtualPath);
        VirtualFile cached = this.getCachedObject(virtualPath);
        if (Objects.nonNull(cached)) {
            return cached;
        }
        VirtualMappedFile f = new VirtualMappedFile(virtualPath, m, this);
        if (m.isCached()) {
            this.cacheObject(f);
        }
        return f;
    }

    private void cacheObject(VirtualFile f) throws IOException, PermissionDeniedException {
        if (Objects.isNull(this.cache)) {
            this.cache = new HashMap<String, VirtualFile>();
        }
        this.cache.put(f.getAbsolutePath(), f);
    }

    protected VirtualFile getCachedObject(String virtualPath) {
        if (Objects.nonNull(this.cache)) {
            this.cache.get(virtualPath);
        }
        return null;
    }

    public VirtualMountManager getMountManager() throws IOException, PermissionDeniedException {
        return this.mgr;
    }

    public Event populateEvent(Event evt) {
        try {
            return evt.addAttribute("MOUNT_MANAGER", (Object)this.getMountManager());
        }
        catch (Exception e) {
            return evt;
        }
    }

    public VirtualFile getDefaultPath() throws PermissionDeniedException, IOException {
        return this.getFile("");
    }
}

