/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileAdapter;
import com.sshtools.common.files.vfs.VirtualFile;
import com.sshtools.common.files.vfs.VirtualFileFactory;
import com.sshtools.common.files.vfs.VirtualMount;
import com.sshtools.common.files.vfs.VirtualMountFile;
import com.sshtools.common.files.vfs.VirtualMountManager;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.util.FileUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class VirtualFileObject
extends AbstractFileAdapter
implements VirtualFile {
    VirtualMount parentMount;
    Map<String, AbstractFile> mounts;
    protected VirtualFileFactory fileFactory;

    protected VirtualFileObject(VirtualFileFactory factory, VirtualMount parentMount) {
        this.fileFactory = factory;
        this.parentMount = parentMount;
    }

    public synchronized void refresh() {
        this.mounts = null;
        super.refresh();
    }

    public VirtualMount getParentMount() {
        return this.parentMount;
    }

    protected synchronized Map<String, AbstractFile> getVirtualMounts() throws IOException, PermissionDeniedException {
        if (Objects.isNull(this.mounts)) {
            HashMap<String, AbstractFile> files = new HashMap<String, AbstractFile>();
            String currentPath = FileUtils.checkEndsWithSlash((String)this.getAbsolutePath());
            VirtualMountManager mgr = this.fileFactory.getMountManager();
            for (VirtualMount m : mgr.getMounts()) {
                String mpath = FileUtils.checkEndsWithSlash((String)m.getMount());
                if (!mpath.startsWith(currentPath) || mpath.equals(currentPath)) continue;
                String child = m.getMount().substring(currentPath.length());
                if (child.indexOf(47) > -1) {
                    child = child.substring(0, child.indexOf(47));
                }
                files.put(currentPath + child, new VirtualMountFile(currentPath + child, m, this.fileFactory));
            }
            this.mounts = files;
        }
        return this.mounts;
    }
}

