/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.AbstractFileRandomAccess;
import com.sshtools.common.files.vfs.VirtualFile;
import com.sshtools.common.files.vfs.VirtualFileFactory;
import com.sshtools.common.files.vfs.VirtualFileObject;
import com.sshtools.common.files.vfs.VirtualMount;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.util.FileUtils;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VirtualMountFile
extends VirtualFileObject {
    private String name;
    private String path;
    private AbstractFile file;
    private boolean intermediate;
    Map<String, VirtualFile> cachedChildren;

    public VirtualMountFile(String path, VirtualMount mount, VirtualFileFactory fileFactory, boolean intermediate) throws PermissionDeniedException, IOException {
        super(fileFactory, mount);
        int idx;
        this.name = FileUtils.isRoot((String)path) ? "" : ((idx = (path = FileUtils.checkEndsWithNoSlash((String)path)).lastIndexOf(47)) > -1 ? path.substring(idx + 1) : path);
        this.path = path;
        this.intermediate = intermediate;
    }

    @Override
    public boolean isMount() {
        return true;
    }

    @Override
    public AbstractFile resolveFile() throws PermissionDeniedException, IOException {
        if (Objects.nonNull(this.file)) {
            return this.file;
        }
        this.file = this.parentMount.getActualFileFactory().getFile(this.parentMount.getResolvePath(this.path));
        return this.file;
    }

    public boolean exists() throws IOException, PermissionDeniedException {
        return true;
    }

    public boolean createFolder() throws PermissionDeniedException, IOException {
        return false;
    }

    public long lastModified() throws IOException, PermissionDeniedException {
        return this.parentMount.lastModified();
    }

    public String getName() {
        return this.name;
    }

    public long length() throws IOException, PermissionDeniedException {
        return 0L;
    }

    public SftpFileAttributes getAttributes() throws FileNotFoundException, IOException, PermissionDeniedException {
        SftpFileAttributes attrs = new SftpFileAttributes(2, "UTF-8");
        attrs.setPermissions(this.parentMount.defaultPermissions());
        try {
            attrs.setReadOnly(this.parentMount.isReadOnly());
        }
        catch (SftpStatusException sftpStatusException) {
            // empty catch block
        }
        attrs.setTimes(new UnsignedInteger64(this.parentMount.lastModified()), new UnsignedInteger64(this.parentMount.lastModified()), new UnsignedInteger64(this.parentMount.lastModified()));
        return attrs;
    }

    public boolean isHidden() throws IOException, PermissionDeniedException {
        return false;
    }

    public boolean isDirectory() throws IOException, PermissionDeniedException {
        return this.isMount();
    }

    public synchronized List<AbstractFile> getChildren() throws IOException, PermissionDeniedException {
        if (Objects.isNull(this.cachedChildren)) {
            this.cachedChildren = this.fileFactory.resolveChildren(this);
        }
        return new ArrayList<AbstractFile>(this.cachedChildren.values());
    }

    public boolean isFile() throws IOException, PermissionDeniedException {
        return false;
    }

    public String getAbsolutePath() throws IOException, PermissionDeniedException {
        return this.path;
    }

    public InputStream getInputStream() throws IOException, PermissionDeniedException {
        throw new IOException("No I/O stream supported on non-file");
    }

    public OutputStream getOutputStream() throws IOException, PermissionDeniedException {
        throw new IOException("No I/O stream supported on non-file");
    }

    public boolean isReadable() throws IOException, PermissionDeniedException {
        return this.isMount();
    }

    public void copyFrom(AbstractFile src) throws IOException, PermissionDeniedException {
        this.resolveFile().copyFrom(src);
    }

    public void moveTo(AbstractFile target) throws IOException, PermissionDeniedException {
        this.resolveFile().moveTo(target);
    }

    public boolean delete(boolean recursive) throws IOException, PermissionDeniedException {
        throw new PermissionDeniedException("You cannot delete a mounted folder object");
    }

    @Override
    public synchronized void refresh() {
        try {
            this.cachedChildren = null;
            super.refresh();
            this.resolveFile().refresh();
        }
        catch (PermissionDeniedException | IOException throwable) {
            // empty catch block
        }
    }

    public boolean isWritable() throws IOException, PermissionDeniedException {
        return !this.intermediate && !this.parentMount.isReadOnly() && this.resolveFile().isWritable();
    }

    public boolean createNewFile() throws PermissionDeniedException, IOException {
        throw new PermissionDeniedException("You cannot create a mounted folder object");
    }

    public void truncate() throws PermissionDeniedException, IOException {
        throw new PermissionDeniedException("You cannot truncate a mounted folder object");
    }

    public void setAttributes(SftpFileAttributes attrs) throws IOException {
        try {
            if (!this.isWritable()) {
                throw new IOException("Mount is not writable");
            }
        }
        catch (PermissionDeniedException e) {
            throw new IOException(e.getMessage(), e);
        }
        this.file.setAttributes(attrs);
    }

    public String getCanonicalPath() throws IOException, PermissionDeniedException {
        return this.path;
    }

    public boolean supportsRandomAccess() {
        return false;
    }

    public AbstractFileRandomAccess openFile(boolean writeAccess) throws IOException, PermissionDeniedException {
        throw new PermissionDeniedException("You cannot open a mounted folder object");
    }

    public OutputStream getOutputStream(boolean append) throws IOException, PermissionDeniedException {
        throw new PermissionDeniedException("You cannot open a stream on a mounted folder object");
    }

    public AbstractFile resolveFile(String child) throws IOException, PermissionDeniedException {
        if (child.startsWith("/")) {
            return this.fileFactory.getFile(child);
        }
        return this.fileFactory.getFile(this.path + (this.path.equals("/") || this.path.endsWith("/") ? "" : "/") + child);
    }

    public AbstractFileFactory<VirtualFile> getFileFactory() {
        return this.parentMount.getVirtualFileFactory();
    }

    public int hashCode() {
        return Objects.hash(this.parentMount, this.path);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (Objects.isNull(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualMountFile other = (VirtualMountFile)this.getClass().cast(obj);
        return Objects.equals(other.path, this.path) && Objects.equals(other.parentMount, this.parentMount);
    }

    public void symlinkTo(String target) throws IOException, PermissionDeniedException {
        throw new PermissionDeniedException("Cannot symlink a mount");
    }

    public String readSymbolicLink() throws IOException, PermissionDeniedException {
        return this.getAbsolutePath();
    }
}

