/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.vfs.AbstractMount;
import com.sshtools.common.files.vfs.VirtualFile;
import com.sshtools.common.files.vfs.VirtualFileFactory;
import com.sshtools.common.files.vfs.VirtualMountTemplate;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.util.FileUtils;
import com.sshtools.common.util.UnsignedInteger32;
import java.io.IOException;

public class VirtualMount
extends AbstractMount {
    AbstractFileFactory<? extends AbstractFile> actualFileFactory;
    VirtualFileFactory virtualFileFactory;
    boolean cached;
    boolean createMountFolder;
    boolean readOnly;
    long lastModified = 0L;
    VirtualMountTemplate mountTemplate;

    VirtualMount(VirtualMountTemplate mountTemplate, VirtualFileFactory virtualFileFactory, AbstractFileFactory<?> actualFileFactory, boolean isDefault, boolean isImaginary, boolean createMountFolder, long lastModified) throws IOException, PermissionDeniedException {
        super(mountTemplate.getMount(), mountTemplate.getRoot(), isDefault, isImaginary);
        this.mountTemplate = mountTemplate;
        this.actualFileFactory = actualFileFactory;
        this.virtualFileFactory = virtualFileFactory;
        this.createMountFolder = createMountFolder;
        this.lastModified = lastModified;
        if (!this.isImaginary()) {
            AbstractFile f = actualFileFactory.getFile(this.path);
            this.path = f.getAbsolutePath();
        }
    }

    public VirtualMount(VirtualMountTemplate mountTemplate, VirtualFileFactory virtualFileFactory, AbstractFileFactory<?> actualFileFactory, boolean createMountFolder, long lastModified) throws IOException, PermissionDeniedException {
        this(mountTemplate, virtualFileFactory, actualFileFactory, false, false, createMountFolder, lastModified);
    }

    public VirtualMountTemplate getTemplate() {
        return this.mountTemplate;
    }

    public AbstractFileFactory<? extends AbstractFile> getActualFileFactory() {
        return this.actualFileFactory;
    }

    public String getResolvePath(String path) {
        String thisMount = FileUtils.addTrailingSlash((String)this.mount);
        String thisPath = FileUtils.addTrailingSlash((String)path);
        if (thisPath.length() >= thisMount.length()) {
            return FileUtils.addTrailingSlash((String)this.path) + thisPath.substring(thisMount.length());
        }
        return this.path;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public AbstractFileFactory<VirtualFile> getVirtualFileFactory() {
        return this.virtualFileFactory;
    }

    public boolean isCreateMountFolder() {
        return this.createMountFolder;
    }

    public boolean isParentOf(VirtualMount o2) {
        return o2.getMount().startsWith(this.getMount());
    }

    public boolean isChildOf(VirtualMount o2) {
        return this.getMount().startsWith(o2.getMount());
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public UnsignedInteger32 defaultPermissions() {
        return this.isReadOnly() ? new UnsignedInteger32(320L) : new UnsignedInteger32(448L);
    }
}

