/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.vfs.AbstractMount;
import com.sshtools.common.files.vfs.VirtualFile;
import com.sshtools.common.files.vfs.VirtualFileFactory;
import com.sshtools.common.files.vfs.VirtualMount;
import com.sshtools.common.files.vfs.VirtualMountTemplate;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.util.FileUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class VirtualMountManager {
    private VirtualMount defaultMount;
    private List<VirtualMount> mounts = new ArrayList<VirtualMount>();
    private VirtualFileFactory fileFactory;
    private ThreadLocal<VirtualMount> testingMount = new ThreadLocal();

    public VirtualMountManager(VirtualFileFactory fileFactory) throws IOException, PermissionDeniedException {
        this(fileFactory, null, new VirtualMountTemplate[0]);
    }

    public VirtualMountManager(VirtualFileFactory fileFactory, VirtualMountTemplate homeMount, VirtualMountTemplate ... additionalMounts) throws IOException, PermissionDeniedException {
        this.fileFactory = fileFactory;
        if (homeMount != null) {
            this.defaultMount = new VirtualMount(homeMount.getMount(), homeMount.getRoot(), fileFactory, homeMount.getActualFileFactory(), true, false, homeMount.isCreateMountFolder());
            if (this.defaultMount.isCreateMountFolder()) {
                this.defaultMount.getActualFileFactory().getFile(this.defaultMount.getRoot()).createFolder();
            }
            this.mounts.add(this.defaultMount);
        }
        for (VirtualMountTemplate m : additionalMounts) {
            VirtualMount vm = this.createMount(m.getMount(), m.getRoot(), m.getActualFileFactory(), m.isCreateMountFolder());
            if (vm.isCreateMountFolder()) {
                vm.getActualFileFactory().getFile(vm.getRoot()).createFolder();
            }
            this.mounts.add(vm);
        }
        this.sort();
    }

    public void mount(VirtualMountTemplate template) throws IOException, PermissionDeniedException {
        this.mount(template, false);
    }

    public void mount(VirtualMountTemplate template, boolean unmount) throws IOException, PermissionDeniedException {
        this.mount(this.createMount(template.getMount(), template.getRoot(), template.getActualFileFactory(), template.isCreateMountFolder()), unmount);
    }

    public void test(VirtualMountTemplate template) throws IOException, PermissionDeniedException {
        this.test(this.createMount(template.getMount(), template.getRoot(), template.getActualFileFactory(), template.isCreateMountFolder()));
    }

    private void test(VirtualMount mount) throws IOException, PermissionDeniedException {
        Log.info((String)("Testing " + mount.getMount() + " on " + mount.getRoot()), (Object[])new Object[0]);
        try {
            this.testingMount.set(mount);
            VirtualFile f = this.fileFactory.getFile(mount.getMount());
            if (mount.isCreateMountFolder()) {
                f.createFolder();
            }
        }
        catch (Exception ex) {
            Log.error((String)("Cannot mount " + mount.getMount() + " " + mount.getRoot()), (Throwable)ex, (Object[])new Object[0]);
        }
        finally {
            this.testingMount.remove();
        }
    }

    private void mount(VirtualMount mount, boolean unmount) throws IOException, PermissionDeniedException {
        if (unmount && this.isMounted(mount.getMount())) {
            this.unmount(mount);
        }
        if (this.isMounted(mount.getMount())) {
            throw new IOException(mount.getMount() + " already mounted on " + this.getMount(mount.getMount()).getRoot());
        }
        Log.info((String)("Mounting " + mount.getMount() + " on " + mount.getRoot()), (Object[])new Object[0]);
        this.test(mount);
        this.mounts.add(mount);
        this.sort();
        Log.info((String)("Mounted " + mount.getMount() + " on " + mount.getRoot()), (Object[])new Object[0]);
    }

    private void sort() {
        Collections.sort(this.mounts, new Comparator<AbstractMount>(){

            @Override
            public int compare(AbstractMount o1, AbstractMount o2) {
                return o1.getMount().compareTo(o2.getMount()) * -1;
            }
        });
    }

    public void unmount(VirtualMount mount) throws IOException {
        Log.info((String)("Unmounting " + mount.getMount() + " from " + mount.getRoot()), (Object[])new Object[0]);
        VirtualMount mounted = null;
        for (VirtualMount m : this.mounts) {
            if (!FileUtils.checkEndsWithSlash((String)m.getMount()).equals(FileUtils.checkEndsWithSlash((String)mount.getMount()))) continue;
            mounted = m;
        }
        if (Objects.isNull(mounted)) {
            throw new IOException(String.format("Could not find mount %s", mount.getMount()));
        }
        this.mounts.remove(mounted);
        this.sort();
        Log.info((String)("Unmounted " + mounted.getMount() + " from " + mounted.getRoot()), (Object[])new Object[0]);
    }

    public VirtualMount getDefaultMount() {
        return this.defaultMount;
    }

    public VirtualMount[] getMounts() {
        ArrayList<VirtualMount> tmp = new ArrayList<VirtualMount>();
        VirtualMount testMount = this.testingMount.get();
        if (testMount != null) {
            tmp.add(this.testingMount.get());
        }
        tmp.addAll(this.mounts);
        return tmp.toArray(new VirtualMount[0]);
    }

    public boolean isMounted(String path) {
        if (path.equals("")) {
            return true;
        }
        for (VirtualMount mount : this.mounts) {
            if (!FileUtils.addTrailingSlash((String)mount.getMount()).equals(FileUtils.addTrailingSlash((String)path))) continue;
            return true;
        }
        return false;
    }

    private VirtualMount createMount(String mount, String path, AbstractFileFactory<?> actualFileFactory, boolean createMoundFolder) throws IOException, PermissionDeniedException {
        return new VirtualMount(mount, path, this.fileFactory, actualFileFactory, createMoundFolder);
    }

    public VirtualMount getMount(String path) throws IOException {
        if ((path = path.replace('\\', '/').trim()).equals("") || path.equals(".") || path.startsWith("./")) {
            return this.defaultMount;
        }
        for (VirtualMount mount : this.getMounts()) {
            String mountPath = FileUtils.checkEndsWithSlash((String)mount.getMount());
            if (!(path = FileUtils.checkEndsWithSlash((String)path)).startsWith(mountPath)) continue;
            return mount;
        }
        throw new FileNotFoundException("No mount for " + path);
    }

    public VirtualMount[] getMounts(String path) {
        if (path.equals("")) {
            return new VirtualMount[]{this.defaultMount};
        }
        path = FileUtils.addTrailingSlash((String)path);
        ArrayList<VirtualMount> matched = new ArrayList<VirtualMount>();
        for (VirtualMount m : this.getMounts()) {
            String mountPath = FileUtils.addTrailingSlash((String)m.getMount());
            if (!path.startsWith(mountPath) && !mountPath.startsWith(path)) continue;
            matched.add(m);
        }
        return matched.toArray(new VirtualMount[0]);
    }

    public VirtualFileFactory getVirtualFileFactory() {
        return this.fileFactory;
    }
}

