/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.components.jce;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.server.SshServerContext;
import com.sshtools.server.components.SshKeyExchangeServer;
import com.sshtools.synergy.ssh.SshTransport;
import com.sshtools.synergy.ssh.components.jce.AbstractKeyExchange;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public abstract class DiffieHellmanGroup
extends SshKeyExchangeServer
implements AbstractKeyExchange {
    public static final String DIFFIE_HELLMAN_GROUP14_SHA1 = "diffie-hellman-group14-sha1";
    static final int SSH_MSG_KEXDH_INIT = 30;
    static final int SSH_MSG_KEXDH_REPLY = 31;
    static final BigInteger ONE = BigInteger.valueOf(1L);
    static final BigInteger TWO;
    static final BigInteger g;
    BigInteger p = null;
    BigInteger e = null;
    BigInteger f = null;
    KeyPairGenerator dhKeyPairGen;
    KeyAgreement dhKeyAgreement;
    KeyFactory dhKeyFactory;
    String kexAlgorithm;

    DiffieHellmanGroup(String kexAlgorithm, String hashAlgorithm, BigInteger p, SecurityLevel securityLevel, int priority) {
        super(hashAlgorithm, securityLevel, priority);
        this.kexAlgorithm = kexAlgorithm;
        this.p = p;
    }

    @Override
    public String getAlgorithm() {
        return this.kexAlgorithm;
    }

    public void init(SshTransport<SshServerContext> transport, String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit, SshPrivateKey prvkey, SshPublicKey pubkey, boolean firstPacketFollows, boolean useFirstPacket) throws IOException {
        this.clientId = clientId;
        this.serverId = serverId;
        this.clientKexInit = clientKexInit;
        this.serverKexInit = serverKexInit;
        this.prvkey = prvkey;
        this.pubkey = pubkey;
        this.firstPacketFollows = firstPacketFollows;
        this.useFirstPacket = useFirstPacket;
        this.transport = transport;
        try {
            this.initCrypto();
            DHParameterSpec dhSkipParamSpec = new DHParameterSpec(this.p, g);
            this.dhKeyPairGen.initialize(dhSkipParamSpec, JCEProvider.getSecureRandom());
            KeyPair dhKeyPair = this.dhKeyPairGen.generateKeyPair();
            this.dhKeyAgreement.init(dhKeyPair.getPrivate());
            this.f = ((DHPublicKey)dhKeyPair.getPublic()).getY();
        }
        catch (Exception ex) {
            throw new IOException("Failed to generate DH value: " + ex.getMessage());
        }
    }

    private void initCrypto() throws NoSuchAlgorithmException {
        this.dhKeyFactory = JCEProvider.getDHKeyFactory();
        this.dhKeyPairGen = JCEProvider.getDHKeyGenerator();
        this.dhKeyAgreement = JCEProvider.getDHKeyAgreement();
    }

    public void test() throws IOException {
        try {
            this.initCrypto();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public String getProvider() {
        if (this.dhKeyAgreement != null) {
            return this.dhKeyAgreement.getProvider().getName();
        }
        return "";
    }

    @Override
    public boolean processMessage(byte[] msg) throws SshException, IOException {
        switch (msg[0]) {
            case 30: {
                if (this.firstPacketFollows && !this.useFirstPacket) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Client attempted to guess the kex in use but we determined it was wrong so we're waiting for another SSH_MSG_KEXDH_INIT", (Object[])new Object[0]);
                    }
                    this.firstPacketFollows = false;
                    return true;
                }
                try (ByteArrayReader bar = new ByteArrayReader(msg);){
                    bar.skip(1L);
                    this.e = bar.readBigInteger();
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Received SSH_MSG_KEXDH_INIT e={}", (Object[])new Object[]{this.e.toString(16)});
                    }
                    DHPublicKeySpec spec = new DHPublicKeySpec(this.e, this.p, g);
                    try {
                        DHPublicKey key = (DHPublicKey)this.dhKeyFactory.generatePublic(spec);
                        this.dhKeyAgreement.doPhase(key, true);
                        byte[] tmp = this.dhKeyAgreement.generateSecret();
                        if ((tmp[0] & 0x80) == 128) {
                            byte[] tmp2 = new byte[tmp.length + 1];
                            System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
                            tmp = tmp2;
                        }
                        this.secret = new BigInteger(tmp);
                    }
                    catch (Exception e1) {
                        throw new SshException((Throwable)e1);
                    }
                    this.hostKey = this.pubkey.getEncoded();
                    this.calculateExchangeHash();
                    int count = 0;
                    while (true) {
                        this.signature = this.prvkey.sign(this.exchangeHash, this.pubkey.getSigningAlgorithm());
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Verifying signature output to mitigate passive SSH key compromise vulnerability", (Object[])new Object[0]);
                        }
                        if (this.pubkey.verifySignature(this.signature, this.exchangeHash)) break;
                        if (count++ >= 3) {
                            throw new SshException(61440, "Detected invalid signautre from private key!");
                        }
                        if (!Log.isDebugEnabled()) continue;
                        Log.debug((String)"Detected invalid signature output from {} implementation", (Object[])new Object[]{this.pubkey.getSigningAlgorithm()});
                    }
                    this.transport.postMessage(new SshMessage(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                            ByteArrayWriter baw = new ByteArrayWriter();
                            try {
                                buf.put((byte)31);
                                buf.putInt(DiffieHellmanGroup.this.hostKey.length);
                                buf.put(DiffieHellmanGroup.this.hostKey);
                                byte[] tmp = DiffieHellmanGroup.this.f.toByteArray();
                                buf.putInt(tmp.length);
                                buf.put(tmp);
                                baw.writeString(DiffieHellmanGroup.this.pubkey.getAlgorithm());
                                baw.writeBinaryString(DiffieHellmanGroup.this.signature);
                                tmp = baw.toByteArray();
                                buf.putInt(tmp.length);
                                buf.put(tmp);
                            }
                            catch (IOException ex) {
                                DiffieHellmanGroup.this.transport.disconnect(3, "Could not read host key");
                            }
                            finally {
                                try {
                                    baw.close();
                                }
                                catch (IOException iOException) {}
                            }
                            return true;
                        }

                        public void messageSent(Long sequenceNo) {
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)"Sent SSH_MSG_KEXDH_REPLY", (Object[])new Object[0]);
                            }
                        }
                    }, true);
                    this.transport.sendNewKeys();
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    protected void calculateExchangeHash() throws SshException {
        Digest hash = (Digest)ComponentManager.getDefaultInstance().supportedDigests().getInstance(this.getHashAlgorithm());
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        hash.putBigInteger(this.e);
        hash.putBigInteger(this.f);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }

    static {
        g = TWO = BigInteger.valueOf(2L);
    }
}

