/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server;

import com.sshtools.common.auth.AuthenticationMechanismFactory;
import com.sshtools.common.auth.Authenticator;
import com.sshtools.common.command.ExecutableCommand;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.direct.NioFileFactory;
import com.sshtools.common.forwarding.ForwardingPolicy;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.IPPolicy;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.policy.FileFactory;
import com.sshtools.common.policy.FileSystemPolicy;
import com.sshtools.common.publickey.InvalidPassphraseException;
import com.sshtools.common.publickey.SshKeyUtils;
import com.sshtools.common.scp.ScpCommand;
import com.sshtools.common.ssh.AbstractRequestFuture;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentInstanceFactory;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.server.NoOpPasswordAuthenticator;
import com.sshtools.server.NoOpPublicKeyAuthenticator;
import com.sshtools.server.SshServerContext;
import com.sshtools.synergy.nio.ProtocolContextFactory;
import com.sshtools.synergy.nio.SshEngine;
import com.sshtools.synergy.nio.SshEngineContext;
import com.sshtools.synergy.nio.SshEngineListener;
import com.sshtools.synergy.nio.SshEngineListenerAdapter;
import com.sshtools.synergy.ssh.ChannelFactory;
import com.sshtools.synergy.ssh.GlobalRequestHandler;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;

public abstract class AbstractSshServer
implements Closeable {
    SshEngine engine = new SshEngine();
    InetAddress addressToBind;
    int port;
    boolean enableScp;
    ServerShutdownFuture shutdownFuture = new ServerShutdownFuture();
    List<Object> defaultPolicies = new ArrayList<Object>();
    Collection<SshKeyPair> hostKeys = new ArrayList<SshKeyPair>();
    Collection<Authenticator> providers = new ArrayList<Authenticator>();
    Collection<Authenticator> defaultProviders = Collections.unmodifiableCollection(Arrays.asList(new Authenticator[]{new NoOpPasswordAuthenticator(), new NoOpPublicKeyAuthenticator()}));
    protected FileFactory fileFactory = new FileFactory(){

        public AbstractFileFactory<?> getFileFactory(SshConnection con) throws IOException, PermissionDeniedException {
            return NioFileFactory.NioFileFactoryBuilder.create().withHome(new File("HOME")).build();
        }
    };
    ForwardingPolicy forwardingPolicy = new ForwardingPolicy();
    ChannelFactory<SshServerContext> channelFactory;
    List<GlobalRequestHandler<SshServerContext>> globalRequestHandlers = new ArrayList<GlobalRequestHandler<SshServerContext>>();
    File confFolder = new File(".");
    IPPolicy ipPolicy = new IPPolicy();
    SecurityLevel securityLevel = SecurityLevel.STRONG;

    protected AbstractSshServer() {
    }

    public AbstractSshServer(int port) throws UnknownHostException {
        this("::", port);
    }

    public AbstractSshServer(String addressToBind, int port) throws UnknownHostException {
        this(InetAddress.getByName(addressToBind), port);
    }

    public AbstractSshServer(InetAddress addressToBind, int port) {
        this.addressToBind = addressToBind;
        this.port = port;
        JCEComponentManager.getDefaultInstance();
    }

    public abstract ProtocolContextFactory<?> getDefaultContextFactory();

    public void setConfigFolder(File confFolder) {
        this.confFolder = confFolder;
    }

    public void start() throws IOException {
        this.start(false);
    }

    public void setSecurityLevel(SecurityLevel securityLevel) {
        this.securityLevel = securityLevel;
    }

    public SecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public void addInterface(String addressToBind, int portToBind) throws IOException {
        this.engine.getContext().addListeningInterface(addressToBind, portToBind, this.getDefaultContextFactory(), true);
    }

    public void addInterface(String addressToBind, int portToBind, ProtocolContextFactory<?> contextFactory) throws IOException {
        this.engine.getContext().addListeningInterface(addressToBind, portToBind, contextFactory, true);
    }

    public void removeInterface(String addressToBind, int portToBind) throws UnknownHostException {
        this.engine.getContext().removeListeningInterface(addressToBind, portToBind);
    }

    public void addGlobalRequestHandler(GlobalRequestHandler<SshServerContext> handler) {
        this.globalRequestHandlers.add(handler);
    }

    public void start(boolean requireListeningInterface) throws IOException {
        this.beforeStart();
        this.engine.setStartupRequiresListeningInterfaces(requireListeningInterface);
        if (!this.engine.startup()) {
            throw new IOException("Server failed to start");
        }
        if (!Objects.isNull(this.addressToBind)) {
            this.port = this.engine.getContext().addListeningInterface(this.addressToBind, this.port, this.getDefaultContextFactory(), true).getActualPort();
        } else if (this.engine.getContext().getListeningInterfaces().length > 0) {
            this.port = this.engine.getContext().getListeningInterfaces()[0].getActualPort();
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)"Listening on port {}", (Object[])new Object[]{this.port});
        }
        this.engine.addListener((SshEngineListener)new SshEngineListenerAdapter(){

            public void shutdown(SshEngine engine) {
                AbstractSshServer.this.shutdownFuture.stop();
            }
        });
        this.afterStart();
    }

    public boolean isRunning() {
        return this.engine.isStarted();
    }

    public void stop() {
        this.engine.shutdownNow(false, 0L);
    }

    public void addHostKeys(Collection<SshKeyPair> hostKeys) {
        this.hostKeys.addAll(hostKeys);
    }

    public void addHostKeys(SshKeyPair ... hostKeys) {
        this.addHostKeys(Arrays.asList(hostKeys));
    }

    public void addHostKey(SshKeyPair key) {
        this.hostKeys.add(key);
    }

    public void addAuthenticator(Authenticator provider) {
        this.providers.add(provider);
    }

    public void setFileFactory(FileFactory fileFactory) {
        this.fileFactory = fileFactory;
    }

    public FileFactory getFileFactory() {
        return this.fileFactory;
    }

    public void setChannelFactory(ChannelFactory<SshServerContext> channelFactory) {
        this.channelFactory = channelFactory;
    }

    public IPPolicy getIPPolicy() {
        return this.ipPolicy;
    }

    public void setIPPolicy(IPPolicy ipPolicy) {
        this.ipPolicy = ipPolicy;
    }

    public void enableSCP() {
        this.enableScp = true;
    }

    public void disableSCP() {
        this.enableScp = false;
    }

    public int getPort() {
        return this.port;
    }

    protected void beforeStart() {
    }

    protected void afterStart() {
    }

    public AbstractRequestFuture getShutdownFuture() {
        return this.shutdownFuture;
    }

    protected void configureHostKeys(SshServerContext sshContext, SocketChannel sc) throws IOException, SshException {
        if (!this.hostKeys.isEmpty()) {
            sshContext.addHostKeys(this.hostKeys);
        } else {
            this.loadOrGenerateHostKey(sshContext, new File(this.confFolder, "ssh_host_rsa"), "ssh-rsa", 2048);
            try {
                this.loadOrGenerateHostKey(sshContext, SshKeyUtils.getRSAPrivateKeyWithSHA256Signature((File)new File(this.confFolder, "ssh_host_rsa"), null));
            }
            catch (InvalidPassphraseException invalidPassphraseException) {
                // empty catch block
            }
            try {
                this.loadOrGenerateHostKey(sshContext, SshKeyUtils.getRSAPrivateKeyWithSHA512Signature((File)new File(this.confFolder, "ssh_host_rsa"), null));
            }
            catch (InvalidPassphraseException invalidPassphraseException) {
                // empty catch block
            }
            this.loadOrGenerateHostKey(sshContext, new File(this.confFolder, "ssh_host_ecdsa_256"), "ecdsa", 256);
            this.loadOrGenerateHostKey(sshContext, new File(this.confFolder, "ssh_host_ecdsa_384"), "ecdsa", 384);
            this.loadOrGenerateHostKey(sshContext, new File(this.confFolder, "ssh_host_ecdsa_521"), "ecdsa", 521);
            this.loadOrGenerateHostKey(sshContext, new File(this.confFolder, "ssh_host_ed25519"), "ed25519", 0);
            if (this.hostKeys.isEmpty()) {
                throw new IOException("There are no host keys available");
            }
        }
    }

    public Collection<SshKeyPair> getHostKeys() {
        return this.hostKeys;
    }

    private void loadOrGenerateHostKey(SshServerContext context, File file, String type, int bitlength) {
        try {
            this.hostKeys.add(context.loadOrGenerateHostKey(file, type, bitlength));
        }
        catch (InvalidPassphraseException | SshException | IOException e) {
            Log.warn((String)"Could not generate or load host key for algorithm {}: {}", (Object[])new Object[]{type, e.getMessage()});
        }
    }

    private void loadOrGenerateHostKey(SshServerContext context, SshKeyPair pair) throws IOException {
        context.addHostKey(pair);
        this.hostKeys.add(pair);
    }

    protected void configureFilesystem(SshServerContext sshContext, SocketChannel sc) throws IOException, SshException {
        ((FileSystemPolicy)sshContext.getPolicy(FileSystemPolicy.class)).setFileFactory(this.getFileFactory());
        if (this.enableScp) {
            sshContext.getChannelFactory().supportedCommands().add((ComponentInstanceFactory)new ScpCommand.ScpCommandFactory());
        }
        for (ExecutableCommand.ExecutableCommandFactory cf : ServiceLoader.load(ExecutableCommand.ExecutableCommandFactory.class)) {
            sshContext.getChannelFactory().supportedCommands().add((ComponentInstanceFactory)cf);
        }
    }

    protected void configureAuthentication(SshServerContext sshContext, SocketChannel sc) throws IOException, SshException {
        if (this.providers.isEmpty()) {
            ((AuthenticationMechanismFactory)sshContext.getPolicy(AuthenticationMechanismFactory.class)).addProviders(this.defaultProviders);
        } else {
            ((AuthenticationMechanismFactory)sshContext.getPolicy(AuthenticationMechanismFactory.class)).addProviders(this.providers);
        }
    }

    protected ChannelFactory<SshServerContext> getChannelFactory() {
        return this.channelFactory;
    }

    protected void configureChannels(SshServerContext sshContext, SocketChannel sc) throws IOException, SshException {
        if (Objects.nonNull(this.getChannelFactory())) {
            sshContext.setChannelFactory(this.getChannelFactory());
        }
    }

    protected void configureForwarding(SshServerContext sshContext, SocketChannel sc) throws IOException, SshException {
        sshContext.setPolicy(ForwardingPolicy.class, this.forwardingPolicy);
    }

    public SshServerContext createServerContext(SshEngineContext daemonContext, SocketChannel sc) throws IOException, SshException {
        SshServerContext sshContext = new SshServerContext(daemonContext.getEngine(), this.securityLevel);
        this.configure(sshContext, sc);
        return sshContext;
    }

    public void configure(SshServerContext sshContext, SocketChannel sc) throws IOException, SshException {
        sshContext.setPolicy(IPPolicy.class, this.ipPolicy);
        for (Object object : this.defaultPolicies) {
            sshContext.setPolicy(object.getClass(), object);
        }
        for (GlobalRequestHandler globalRequestHandler : this.globalRequestHandlers) {
            sshContext.addGlobalRequestHandler((GlobalRequestHandler<SshServerContext>)globalRequestHandler);
        }
        this.configureHostKeys(sshContext, sc);
        this.configureAuthentication(sshContext, sc);
        this.configureChannels(sshContext, sc);
        this.configureFilesystem(sshContext, sc);
        this.configureForwarding(sshContext, sc);
    }

    public SshEngine getEngine() {
        return this.engine;
    }

    @Override
    public void close() {
        this.engine.shutdownNow(false, 0L);
    }

    public ForwardingPolicy getForwardingPolicy() {
        return this.forwardingPolicy;
    }

    public void setDefaultPolicies(Object ... policies) {
        this.defaultPolicies.addAll(Arrays.asList(policies));
    }

    class ServerShutdownFuture
    extends AbstractRequestFuture {
        ServerShutdownFuture() {
        }

        public void stop() {
            this.done(true);
        }
    }
}

