/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server;

import com.sshtools.common.auth.AuthenticationMechanismFactory;
import com.sshtools.common.auth.Authenticator;
import com.sshtools.common.auth.PublicKeyAuthenticationProvider;
import com.sshtools.common.logger.Log;
import com.sshtools.common.policy.AuthenticationPolicy;
import com.sshtools.common.publickey.SshPublicKeyFile;
import com.sshtools.common.publickey.SshPublicKeyFileFactory;
import com.sshtools.common.ssh.Packet;
import com.sshtools.common.ssh.Subsystem;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.util.ByteArrayReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;

public class PublicKeySubsystem
extends Subsystem {
    static final int SUCCESS = 0;
    static final int ACCESS_DENIED = 1;
    static final int STORAGE_EXCEEDED = 2;
    static final int REQUEST_NOT_SUPPPORTED = 3;
    static final int KEY_NOT_FOUND = 4;
    static final int KEY_NOT_SUPPORTED = 5;
    static final int GENERAL_FAILURE = 6;
    public static final String SUBSYSTEM_NAME = "publickey@vandyke.com";

    public PublicKeySubsystem() {
        super("publickey");
    }

    protected void onSubsystemFree() {
    }

    protected void onMessageReceived(byte[] msg) throws IOException {
        block16: {
            try (ByteArrayReader bar = new ByteArrayReader(msg);){
                String cmd = bar.readString();
                if (cmd.equals("version")) {
                    this.processVersion(bar);
                    break block16;
                }
                if (cmd.equals("add")) {
                    this.processAddKey(bar);
                    break block16;
                }
                if (cmd.equals("remove")) {
                    this.processRemoveKey(bar);
                    break block16;
                }
                if (cmd.equals("list")) {
                    this.processKeyList(bar);
                    break block16;
                }
                throw new IOException("The client sent an invalid request");
            }
        }
    }

    private void processKeyList(ByteArrayReader bar) throws IOException {
        try {
            for (Authenticator p : this.getProviders()) {
                PublicKeyAuthenticationProvider ap = (PublicKeyAuthenticationProvider)p;
                try {
                    Iterator i = ap.getKeys(this.getConnection());
                    while (i.hasNext()) {
                        SshPublicKeyFile keyFile = (SshPublicKeyFile)i.next();
                        Packet packet = new Packet();
                        packet.writeString(keyFile.getComment());
                        packet.writeString(keyFile.getOptions());
                        packet.writeBinaryString(keyFile.getFormattedKey());
                        this.sendMessage(packet);
                    }
                    return;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
            }
            throw new UnsupportedOperationException();
        }
        catch (SecurityException iae) {
            this.writeStatusResponse(1, "Access denied.");
        }
        catch (UnsupportedOperationException uoe) {
            this.writeStatusResponse(3, "list not supported.");
        }
        catch (Exception e) {
            this.writeStatusResponse(6, e.getMessage());
        }
        this.writeStatusResponse(0, "OK");
    }

    private void processRemoveKey(ByteArrayReader bar) throws IOException {
        String algorithm = bar.readString();
        byte[] encodedKey = bar.readBinaryString();
        try {
            SshPublicKey key = SshPublicKeyFileFactory.decodeSSH2PublicKey((String)algorithm, (byte[])encodedKey);
            for (Authenticator p : this.getProviders()) {
                PublicKeyAuthenticationProvider ap = (PublicKeyAuthenticationProvider)p;
                try {
                    ap.remove(key, this.getConnection());
                    this.writeStatusResponse(0, "Public key removed.");
                    return;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
            }
            throw new UnsupportedOperationException();
        }
        catch (FileNotFoundException fnfe) {
            this.writeStatusResponse(4, "Remove not supported.");
        }
        catch (SecurityException iae) {
            this.writeStatusResponse(1, "Access denied.");
        }
        catch (UnsupportedOperationException uoe) {
            this.writeStatusResponse(3, "Remove not supported.");
        }
        catch (Exception e) {
            this.writeStatusResponse(6, e.getMessage());
        }
    }

    private void processAddKey(ByteArrayReader bar) throws IOException {
        String comment = bar.readString();
        String algorithm = bar.readString();
        byte[] encodedKey = bar.readBinaryString();
        SshPublicKey key = SshPublicKeyFileFactory.decodeSSH2PublicKey((String)algorithm, (byte[])encodedKey);
        try {
            for (Authenticator p : this.getProviders()) {
                PublicKeyAuthenticationProvider ap = (PublicKeyAuthenticationProvider)p;
                try {
                    ap.add(key, comment, this.getConnection());
                    this.writeStatusResponse(0, "Public key created.");
                    return;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
            }
            throw new UnsupportedOperationException();
        }
        catch (UnsupportedOperationException uoe) {
            this.writeStatusResponse(3, "Add not supported.");
        }
        catch (IllegalArgumentException iae) {
            this.writeStatusResponse(5, "Key not supported.");
        }
        catch (SecurityException iae) {
            this.writeStatusResponse(1, "Access denied.");
        }
        catch (Exception e) {
            this.writeStatusResponse(6, e.getMessage());
        }
    }

    private void processVersion(ByteArrayReader bar) throws IOException {
        int clientVersion = (int)bar.readInt();
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Client publickey subsystem version " + clientVersion), (Object[])new Object[0]);
        }
        Packet packet = new Packet();
        packet.writeString(((AuthenticationPolicy)this.getContext().getPolicy(AuthenticationPolicy.class)).getBannerMessage());
        packet.writeInt(1);
        this.sendMessage(packet);
    }

    private Authenticator[] getProviders() {
        return ((AuthenticationMechanismFactory)this.getContext().getPolicy(AuthenticationMechanismFactory.class)).getProviders("publickey", this.getConnection());
    }

    void writeStatusResponse(int status, String desc) throws IOException {
        Packet packet = new Packet();
        packet.writeString("status");
        packet.writeInt(status);
        packet.writeString(desc);
        this.sendMessage(packet);
    }

    protected void cleanupSubsystem() {
    }
}

