/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server;

import com.sshtools.common.auth.AbstractPublicKeyAuthenticationProvider;
import com.sshtools.common.publickey.OpenSshCertificate;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class OpenSshCACertificateStoreImpl
extends AbstractPublicKeyAuthenticationProvider {
    Set<SshPublicKey> caKeys = new HashSet<SshPublicKey>();

    public OpenSshCACertificateStoreImpl(SshPublicKey caPublicKey) {
        this.caKeys.add(caPublicKey);
    }

    public OpenSshCACertificateStoreImpl(Collection<SshPublicKey> caPublicKeys) {
        this.caKeys.addAll(caPublicKeys);
    }

    public void addCAKey(SshPublicKey caKey) throws SshException {
        this.caKeys.add(caKey);
    }

    public void removeKey(SshPublicKey caKey) {
        this.caKeys.remove(caKey);
    }

    public boolean isAuthorizedKey(SshPublicKey key, SshConnection con) {
        if (!key.isCertificate()) {
            return false;
        }
        OpenSshCertificate cert = (OpenSshCertificate)key;
        if (cert.getType() != 1) {
            return false;
        }
        if (!new Date().after(cert.getValidAfter())) {
            return false;
        }
        if (!new Date().before(cert.getValidBefore())) {
            return false;
        }
        if (cert.getPrincipals().size() > 0 && !cert.getPrincipals().contains(con.getUsername())) {
            return false;
        }
        for (SshPublicKey k : this.caKeys) {
            if (!cert.getSignedBy().equals(k)) continue;
            return true;
        }
        return false;
    }

    public boolean checkKey(SshPublicKey key, SshConnection con) throws IOException {
        return this.isAuthorizedKey(key, con);
    }
}

