/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server;

import com.sshtools.common.auth.AuthenticationMechanismFactory;
import com.sshtools.common.auth.DefaultAuthenticationMechanismFactory;
import com.sshtools.common.command.ExecutableCommand;
import com.sshtools.common.logger.Log;
import com.sshtools.common.publickey.InvalidPassphraseException;
import com.sshtools.common.publickey.SshKeyPairGenerator;
import com.sshtools.common.publickey.SshKeyUtils;
import com.sshtools.common.publickey.SshPrivateKeyFile;
import com.sshtools.common.publickey.SshPrivateKeyFileFactory;
import com.sshtools.common.publickey.SshPublicKeyFile;
import com.sshtools.common.publickey.SshPublicKeyFileFactory;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentFactory;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.SshCertificate;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPublicKey;
import com.sshtools.server.DefaultServerChannelFactory;
import com.sshtools.server.ServerConnectionStateListener;
import com.sshtools.server.TransportProtocolServer;
import com.sshtools.server.components.jce.Curve25519SHA256LibSshServer;
import com.sshtools.server.components.jce.Curve25519SHA256Server;
import com.sshtools.server.components.jce.DiffieHellmanEcdhNistp256;
import com.sshtools.server.components.jce.DiffieHellmanEcdhNistp384;
import com.sshtools.server.components.jce.DiffieHellmanEcdhNistp521;
import com.sshtools.server.components.jce.DiffieHellmanGroup14Sha1JCE;
import com.sshtools.server.components.jce.DiffieHellmanGroup14Sha256JCE;
import com.sshtools.server.components.jce.DiffieHellmanGroup15Sha512JCE;
import com.sshtools.server.components.jce.DiffieHellmanGroup16Sha512JCE;
import com.sshtools.server.components.jce.DiffieHellmanGroup17Sha512JCE;
import com.sshtools.server.components.jce.DiffieHellmanGroup18Sha512JCE;
import com.sshtools.server.components.jce.DiffieHellmanGroupExchangeSha256JCE;
import com.sshtools.server.components.jce.Rsa2048SHA2KeyExchange;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.ProtocolEngine;
import com.sshtools.synergy.nio.SshEngine;
import com.sshtools.synergy.ssh.ChannelFactory;
import com.sshtools.synergy.ssh.ConnectionManager;
import com.sshtools.synergy.ssh.ForwardingManager;
import com.sshtools.synergy.ssh.GlobalRequestHandler;
import com.sshtools.synergy.ssh.SshContext;
import com.sshtools.synergy.ssh.components.SshKeyExchange;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class SshServerContext
extends SshContext {
    Map<String, SshKeyPair> hostkeys = new ConcurrentHashMap<String, SshKeyPair>(8, 0.9f, 1);
    Map<String, Class<? extends ExecutableCommand>> commands = new ConcurrentHashMap<String, Class<? extends ExecutableCommand>>(8, 0.9f, 1);
    boolean ensureGracefulDisconnect = false;
    ForwardingManager<SshServerContext> forwardingManager;
    ConnectionManager<SshServerContext> connectionManager;
    static ForwardingManager<SshServerContext> globalForwardingManager = new ForwardingManager();
    static ConnectionManager<SshServerContext> globalConnectionManager = new ConnectionManager("server");
    Collection<ServerConnectionStateListener> stateListeners = new ArrayList<ServerConnectionStateListener>();
    ChannelFactory<SshServerContext> channelFactory = new DefaultServerChannelFactory();
    Map<String, GlobalRequestHandler<SshServerContext>> globalRequestHandlers = Collections.synchronizedMap(new HashMap());
    int maxDHGroupSize = 2048;
    private boolean forceServerPreferences = false;
    private static ComponentFactory<SshKeyExchange<SshServerContext>> verifiedKeyExchanges;

    public SshServerContext(SshEngine engine) throws IOException, SshException {
        this(engine, SecurityLevel.STRONG);
    }

    public SshServerContext(SshEngine engine, ComponentManager componentManager) throws IOException, SshException {
        this(engine, componentManager, SecurityLevel.STRONG);
    }

    public SshServerContext(SshEngine engine, ComponentManager componentManager, SecurityLevel securityLevel) throws IOException, SshException {
        super(engine, componentManager, securityLevel);
        this.setAuthenicationMechanismFactory((AuthenticationMechanismFactory<SshServerContext>)new DefaultAuthenticationMechanismFactory());
    }

    public SshServerContext(SshEngine engine, SecurityLevel securityLevel) throws IOException, SshException {
        this(engine, ComponentManager.getDefaultInstance(), securityLevel);
    }

    public ConnectionManager<SshServerContext> getConnectionManager() {
        return Objects.isNull(this.connectionManager) ? globalConnectionManager : this.connectionManager;
    }

    public void setConnectionManager(ConnectionManager<SshServerContext> connectionManager) {
        this.connectionManager = connectionManager;
    }

    public ProtocolEngine createEngine(ConnectRequestFuture connectFuture) throws IOException {
        return new TransportProtocolServer(this, connectFuture);
    }

    public void addStateListener(ServerConnectionStateListener stateListener) {
        this.stateListeners.add(stateListener);
    }

    public Collection<ServerConnectionStateListener> getStateListeners() {
        return this.stateListeners;
    }

    public void addGlobalRequestHandler(GlobalRequestHandler<SshServerContext> handler) {
        for (int i = 0; i < handler.supportedRequests().length; ++i) {
            this.globalRequestHandlers.put(handler.supportedRequests()[i], handler);
        }
    }

    public GlobalRequestHandler<SshServerContext> getGlobalRequestHandler(String name) {
        return this.globalRequestHandlers.get(name);
    }

    public String getPreferredPublicKey() {
        if (this.hostkeys.containsKey(this.prefPublicKey)) {
            return this.prefPublicKey;
        }
        if (this.hostkeys.entrySet().isEmpty()) {
            throw new RuntimeException("No host keys loaded!!");
        }
        Map.Entry<String, SshKeyPair> e = this.hostkeys.entrySet().iterator().next();
        return e.getKey();
    }

    public String getSupportedPublicKeys() {
        String list = "";
        if (this.hostkeys.keySet().contains(this.prefPublicKey)) {
            list = list + this.prefPublicKey;
        }
        for (String type : this.hostkeys.keySet()) {
            if (type.equals(this.prefPublicKey)) continue;
            list = list + (list.length() == 0 ? "" : ",") + type;
        }
        return list;
    }

    public void setPreferredPublicKey(String name) throws IOException, SshException {
        if (!this.publicKeys.contains(name)) {
            throw new IOException(name + " is not supported");
        }
        this.prefPublicKey = name;
        this.setPublicKeyPreferredPosition(name, 0);
    }

    public SshKeyPair[] getHostKeys() {
        SshKeyPair[] keys = new SshKeyPair[this.hostkeys.size()];
        this.hostkeys.values().toArray(keys);
        return keys;
    }

    public SshKeyPair getHostKey(String algorithm) throws IOException {
        if (!this.hostkeys.containsKey(algorithm)) {
            throw new IOException("The server does not have a " + algorithm + " key configured");
        }
        return this.hostkeys.get(algorithm);
    }

    public void addHostKey(SshKeyPair keyPair) throws IOException {
        if (keyPair instanceof SshCertificate) {
            SshKeyPair converted = new SshKeyPair();
            converted.setPrivateKey(keyPair.getPrivateKey());
            converted.setPublicKey((SshPublicKey)((SshCertificate)keyPair).getCertificate());
            if (this.hostkeys.containsKey(converted.getPublicKey().getAlgorithm())) {
                Log.warn((String)("The server already has a " + keyPair.getPublicKey().getAlgorithm() + " certificate configured."), (Object[])new Object[0]);
            }
            this.hostkeys.put(converted.getPublicKey().getAlgorithm(), converted);
        } else {
            if (this.hostkeys.containsKey(keyPair.getPublicKey().getAlgorithm())) {
                Log.warn((String)("The server already has a " + keyPair.getPublicKey().getAlgorithm() + " key configured."), (Object[])new Object[0]);
            }
            this.hostkeys.put(keyPair.getPublicKey().getAlgorithm(), keyPair);
            if (keyPair.getPublicKey() instanceof Ssh2RsaPublicKey && keyPair.getPublicKey().getAlgorithm().equals("ssh-rsa") && this.supportedPublicKeys().contains("rsa-sha2-256") && !this.hostkeys.containsKey("rsa-sha2-256")) {
                this.hostkeys.put("rsa-sha2-256", SshKeyUtils.makeRSAWithSHA256Signature((SshKeyPair)keyPair));
            }
            if (keyPair.getPublicKey() instanceof Ssh2RsaPublicKey && keyPair.getPublicKey().getAlgorithm().equals("ssh-rsa") && this.supportedPublicKeys().contains("rsa-sha2-512") && !this.hostkeys.containsKey("rsa-sha2-512")) {
                this.hostkeys.put("rsa-sha2-512", SshKeyUtils.makeRSAWithSHA512Signature((SshKeyPair)keyPair));
            }
        }
    }

    public void addHostKeys(Collection<SshKeyPair> keys) throws IOException {
        for (SshKeyPair key : keys) {
            this.addHostKey(key);
        }
    }

    public void generateTemporaryHostKey(String algorithm, int bitlength) throws IOException, SshException {
        this.addHostKey(SshServerContext.generateKey(algorithm, bitlength));
    }

    public ChannelFactory<SshServerContext> getChannelFactory() {
        return this.channelFactory;
    }

    public void setChannelFactory(ChannelFactory<SshServerContext> channelFactory) {
        this.channelFactory = channelFactory;
    }

    public ForwardingManager<SshServerContext> getForwardingManager() {
        return this.forwardingManager == null ? globalForwardingManager : this.forwardingManager;
    }

    public void setForwardingManager(ForwardingManager<SshServerContext> forwardingManager) {
        this.forwardingManager = forwardingManager;
    }

    public void addCommand(String name, Class<? extends ExecutableCommand> cls) {
        this.commands.put(name.toLowerCase(), cls);
    }

    public boolean containsCommand(String name) {
        return this.commands.containsKey(name.toLowerCase());
    }

    public Class<? extends ExecutableCommand> getCommand(String name) {
        return this.commands.get(name.toLowerCase());
    }

    public boolean hasPublicKey(String algorithm) {
        return this.hostkeys.containsKey(algorithm);
    }

    public SshKeyPair loadOrGenerateHostKey(File key, String type, int bitlength) throws IOException, InvalidPassphraseException, SshException {
        return this.loadOrGenerateHostKey(key, type, bitlength, 1, "");
    }

    public SshKeyPair loadOrGenerateHostKey(File key, String type, int bitlength, String passPhrase) throws IOException, InvalidPassphraseException, SshException {
        return this.loadOrGenerateHostKey(key, type, bitlength, 1, passPhrase);
    }

    public void loadHostKey(InputStream in) throws IOException, InvalidPassphraseException, SshException {
        this.loadHostKey(in, "");
    }

    public SshKeyPair loadOrGenerateHostKey(File key, String type, int bitlength, int publicKeyFormat, String passPhrase) throws IOException, InvalidPassphraseException, SshException {
        SshKeyPair pair = !key.exists() ? SshServerContext.generateKeyFiles(key, type, bitlength, publicKeyFormat) : this.loadKey(key, passPhrase);
        this.addHostKey(pair);
        return pair;
    }

    public void loadHostKey(InputStream in, String passPhrase) throws IOException, InvalidPassphraseException, SshException {
        this.addHostKey(this.loadKey(in, passPhrase));
    }

    public SshKeyPair loadKey(File key, String passphrase) throws IOException, InvalidPassphraseException {
        return this.loadKey(new FileInputStream(key), passphrase);
    }

    public SshKeyPair loadKey(InputStream in, String passphrase) throws IOException, InvalidPassphraseException {
        SshKeyPair pair = SshPrivateKeyFileFactory.parse((InputStream)in).toKeyPair(passphrase);
        in.close();
        return pair;
    }

    public static SshKeyPair generateKeyFiles(File keyFilename, String type, int bitlength, int publicKeyFormat) throws IOException, SshException {
        SshKeyPair pair = SshServerContext.generateKey(type, bitlength);
        SshPrivateKeyFile prvfile = SshPrivateKeyFileFactory.create((SshKeyPair)pair, (String)"");
        FileOutputStream fout = new FileOutputStream(keyFilename);
        fout.write(prvfile.getFormattedKey());
        fout.close();
        SshPublicKeyFile pubfile = SshPublicKeyFileFactory.create((SshPublicKey)pair.getPublicKey(), (String)(type + " host key"), (int)publicKeyFormat);
        fout = new FileOutputStream(keyFilename.getAbsolutePath() + ".pub");
        fout.write(pubfile.getFormattedKey());
        fout.close();
        return pair;
    }

    public static SshKeyPair generateKey(String type, int bitLength) throws IOException, SshException {
        return SshKeyPairGenerator.generateKeyPair((String)type, (int)bitLength);
    }

    public void loadSshCertificate(File keyFile, String passphrase, File certFile) throws IOException, InvalidPassphraseException {
        SshKeyPair pair = this.loadKey(keyFile, passphrase);
        pair.setPublicKey(SshPublicKeyFileFactory.parse((InputStream)new FileInputStream(certFile)).toPublicKey());
        this.addHostKey(pair);
    }

    public void loadSshCertificate(SshCertificate cert) throws IOException, InvalidPassphraseException {
        this.addHostKey((SshKeyPair)cert);
    }

    public void setAuthenicationMechanismFactory(AuthenticationMechanismFactory<SshServerContext> authFactory) {
        this.setPolicy(AuthenticationMechanismFactory.class, authFactory);
    }

    public AuthenticationMechanismFactory<SshServerContext> getAuthenticationMechanismFactory() {
        return (AuthenticationMechanismFactory)this.getPolicy(AuthenticationMechanismFactory.class, new DefaultAuthenticationMechanismFactory());
    }

    public boolean isEnsureGracefulDisconnect() {
        return this.ensureGracefulDisconnect;
    }

    public void setEnsureGracefulDisconnect(boolean ensureGracefulDisconnect) {
        this.ensureGracefulDisconnect = ensureGracefulDisconnect;
    }

    protected synchronized void configureKeyExchanges() {
        if (Objects.nonNull(verifiedKeyExchanges)) {
            this.keyExchanges = (ComponentFactory)verifiedKeyExchanges.clone();
            return;
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing server key exchanges", (Object[])new Object[0]);
        }
        verifiedKeyExchanges = new ComponentFactory(this.componentManager);
        JCEComponentManager.getDefaultInstance().loadExternalComponents("/kex-server.properties", this.keyExchanges);
        if (this.testServerKeyExchangeAlgorithm("curve25519-sha256", Curve25519SHA256Server.class)) {
            verifiedKeyExchanges.add("curve25519-sha256", Curve25519SHA256Server.class);
        }
        if (this.testServerKeyExchangeAlgorithm("curve25519-sha256@libssh.org", Curve25519SHA256LibSshServer.class)) {
            verifiedKeyExchanges.add("curve25519-sha256@libssh.org", Curve25519SHA256LibSshServer.class);
        }
        if (this.testServerKeyExchangeAlgorithm("diffie-hellman-group-exchange-sha256", DiffieHellmanGroupExchangeSha256JCE.class)) {
            verifiedKeyExchanges.add("diffie-hellman-group-exchange-sha256", DiffieHellmanGroupExchangeSha256JCE.class);
        }
        if (this.testServerKeyExchangeAlgorithm("diffie-hellman-group14-sha256", DiffieHellmanGroup14Sha256JCE.class)) {
            verifiedKeyExchanges.add("diffie-hellman-group14-sha256", DiffieHellmanGroup14Sha256JCE.class);
        }
        if (this.testServerKeyExchangeAlgorithm("diffie-hellman-group15-sha512", DiffieHellmanGroup15Sha512JCE.class)) {
            verifiedKeyExchanges.add("diffie-hellman-group15-sha512", DiffieHellmanGroup15Sha512JCE.class);
        }
        if (this.testServerKeyExchangeAlgorithm("diffie-hellman-group16-sha512", DiffieHellmanGroup16Sha512JCE.class)) {
            verifiedKeyExchanges.add("diffie-hellman-group16-sha512", DiffieHellmanGroup16Sha512JCE.class);
        }
        if (this.testServerKeyExchangeAlgorithm("diffie-hellman-group17-sha512", DiffieHellmanGroup17Sha512JCE.class)) {
            verifiedKeyExchanges.add("diffie-hellman-group17-sha512", DiffieHellmanGroup17Sha512JCE.class);
        }
        if (this.testServerKeyExchangeAlgorithm("diffie-hellman-group18-sha512", DiffieHellmanGroup18Sha512JCE.class)) {
            verifiedKeyExchanges.add("diffie-hellman-group18-sha512", DiffieHellmanGroup18Sha512JCE.class);
        }
        if (this.testServerKeyExchangeAlgorithm("diffie-hellman-group14-sha1", DiffieHellmanGroup14Sha1JCE.class)) {
            verifiedKeyExchanges.add("diffie-hellman-group14-sha1", DiffieHellmanGroup14Sha1JCE.class);
        }
        if (this.testServerKeyExchangeAlgorithm("ecdh-sha2-nistp521", DiffieHellmanEcdhNistp521.class)) {
            verifiedKeyExchanges.add("ecdh-sha2-nistp521", DiffieHellmanEcdhNistp521.class);
        }
        if (this.testServerKeyExchangeAlgorithm("ecdh-sha2-nistp384", DiffieHellmanEcdhNistp384.class)) {
            verifiedKeyExchanges.add("ecdh-sha2-nistp384", DiffieHellmanEcdhNistp384.class);
        }
        if (this.testServerKeyExchangeAlgorithm("ecdh-sha2-nistp256", DiffieHellmanEcdhNistp256.class)) {
            verifiedKeyExchanges.add("ecdh-sha2-nistp256", DiffieHellmanEcdhNistp256.class);
        }
        if (this.testServerKeyExchangeAlgorithm("rsa2048-sha256", Rsa2048SHA2KeyExchange.class)) {
            verifiedKeyExchanges.add("rsa2048-sha256", Rsa2048SHA2KeyExchange.class);
        }
        this.keyExchanges = (ComponentFactory)verifiedKeyExchanges.clone();
    }

    private boolean testServerKeyExchangeAlgorithm(String name, Class<? extends SshKeyExchange<? extends SshContext>> cls) {
        SshKeyExchange<? extends SshContext> c = null;
        try {
            c = cls.newInstance();
            if (!JCEComponentManager.getDefaultInstance().supportedDigests().contains(c.getHashAlgorithm())) {
                throw new Exception("Hash algorithm " + c.getHashAlgorithm() + " is not supported");
            }
            c.test();
        }
        catch (Exception e) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("   " + name + " (server) will not be supported: " + e.getMessage()), (Object[])new Object[0]);
            }
            return false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("   " + name + " (server) will be supported using JCE Provider " + c.getProvider()), (Object[])new Object[0]);
        }
        return true;
    }

    public void setMaxDHGroupExchangeSize(int maxDHGroupSize) {
        this.maxDHGroupSize = maxDHGroupSize;
    }

    public int getMaxDHGroupExchangeKeySize() {
        return this.maxDHGroupSize;
    }

    public boolean isForceServerPreferences() {
        return this.forceServerPreferences;
    }

    public void setForceServerPreferences(boolean serverControlledKeyExchange) {
        this.forceServerPreferences = serverControlledKeyExchange;
    }
}

