/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server;

import com.sshtools.common.auth.AbstractAuthenticationProtocol;
import com.sshtools.common.auth.AuthenticationMechanism;
import com.sshtools.common.auth.AuthenticationMechanismFactory;
import com.sshtools.common.auth.KeyboardInteractiveAuthentication;
import com.sshtools.common.auth.RequiredAuthenticationStrategy;
import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.IPPolicy;
import com.sshtools.common.policy.AuthenticationPolicy;
import com.sshtools.common.ssh.ExecutorOperationSupport;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.UnsupportedChannelException;
import com.sshtools.common.sshd.AbstractServerTransport;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.Utils;
import com.sshtools.server.ConnectionProtocolServer;
import com.sshtools.server.ServerConnectionStateListener;
import com.sshtools.server.SshServerContext;
import com.sshtools.server.TransportProtocolServer;
import com.sshtools.synergy.ssh.Service;
import com.sshtools.synergy.ssh.SshContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AuthenticationProtocolServer
extends ExecutorOperationSupport<SshContext>
implements Service,
AbstractAuthenticationProtocol<SshServerContext> {
    TransportProtocolServer transport;
    boolean authInProgress = false;
    int failed = 0;
    AuthenticationMechanism currentAuthentication;
    String currentMethod;
    String username;
    String service;
    ArrayList<String> completedAuthentications = new ArrayList();
    Map<String, Object> authenticationParameters = new ConcurrentHashMap<String, Object>(8, 0.9f, 1);
    Date started = new Date();
    String[] requiredAuthentications = null;
    boolean authenticated = false;
    boolean firstAttempt = false;
    static final String SERVICE_NAME = "ssh-userauth";

    public AuthenticationProtocolServer(TransportProtocolServer transport) {
        super("authentication-protocol");
        this.transport = transport;
    }

    public SshServerContext getContext() {
        return this.transport.getContext();
    }

    public synchronized void stop() {
        if (this.transport != null) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Cleaning up authentication protocol references", (Object[])new Object[0]);
            }
            this.transport.getConnection().getAuthenticatedFuture().authenticated(this.authenticated);
        }
    }

    public void start() {
        if (Utils.isNotBlank((String)((AuthenticationPolicy)((SshServerContext)this.transport.getSshContext()).getPolicy(AuthenticationPolicy.class)).getBannerMessage())) {
            this.transport.postMessage(new SshMessage(){

                public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                    buf.put((byte)53);
                    byte[] tmp = ((AuthenticationPolicy)((SshServerContext)AuthenticationProtocolServer.this.transport.getSshContext()).getPolicy(AuthenticationPolicy.class)).getBannerMessage().getBytes();
                    buf.putInt(tmp.length);
                    buf.put(tmp);
                    buf.putInt(0);
                    return true;
                }

                public void messageSent(Long sequenceNo) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Sent SSH_MSG_USERAUTH_BANNER", (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    public boolean processMessage(byte[] msg) throws IOException {
        if (this.authInProgress) {
            return this.currentAuthentication.processMessage(msg);
        }
        switch (msg[0]) {
            case 50: {
                this.processRequest(msg);
                return true;
            }
        }
        return false;
    }

    public Object getParameter(String name) {
        return this.authenticationParameters.get(name);
    }

    public void setParameter(String name, Object value) {
        this.authenticationParameters.put(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void processRequest(byte[] msg) throws IOException {
        bar = new ByteArrayReader(msg);
        try {
            bar.skip(1L);
            this.username = bar.readString();
            this.service = bar.readString();
            canConnect = true;
            con = this.transport.getConnection();
            con.setUsername(this.username);
            if (!this.firstAttempt) {
                EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777197, true).addAttribute("CONNECTION", (Object)this.transport.getConnection()).addAttribute("USERNAME", (Object)this.username).addAttribute("AUTHENTICATION_METHOD", (Object)this.currentMethod).addAttribute("OP_STARTED", (Object)this.started).addAttribute("OP_FINISHED", (Object)new Date()));
                this.firstAttempt = true;
            }
            if (this.requiredAuthentications == null || ((AuthenticationPolicy)((SshServerContext)this.transport.getSshContext()).getPolicy(AuthenticationPolicy.class)).getRequiredAuthenticationStrategy() == RequiredAuthenticationStrategy.ONCE_PER_AUTHENTICATION_ATTEMPT) {
                this.requiredAuthentications = ((AuthenticationMechanismFactory)((SshServerContext)this.transport.getSshContext()).getPolicy(AuthenticationMechanismFactory.class)).getRequiredMechanisms((SshConnection)con);
            }
            this.currentMethod = bar.readString();
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Client is attempting " + this.currentMethod + " authentication"), (Object[])new Object[0]);
            }
            request = null;
            if (bar.available() > 0) {
                request = new byte[bar.available()];
                bar.read(request);
            }
            if (!canConnect || !((AuthenticationMechanismFactory)this.transport.getContext().getPolicy(AuthenticationMechanismFactory.class)).isSupportedMechanism(this.currentMethod) || !this.service.equals("ssh-connection")) ** GOTO lbl34
            try {
                this.currentAuthentication = ((AuthenticationMechanismFactory)this.transport.getContext().getPolicy(AuthenticationMechanismFactory.class)).createInstance(this.currentMethod, (AbstractServerTransport)this.transport, (AbstractAuthenticationProtocol)this, (SshConnection)con);
                this.authInProgress = true;
                this.currentAuthentication.startRequest(this.username, request);
                return;
            }
            catch (UnsupportedChannelException ex) {
                if (!this.currentMethod.equals("none") && Log.isErrorEnabled()) {
                    Log.error((String)("Failed to initialize " + this.currentMethod + " authentication mechanism"), (Throwable)ex, (Object[])new Object[0]);
                }
lbl34:
                // 4 sources

                this.failedAuthentication();
            }
        }
        finally {
            bar.close();
        }
    }

    public synchronized void completedAuthentication() {
        if (this.transport == null || !this.transport.isConnected()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Transport is no longer connected!", (Object[])new Object[0]);
            }
            return;
        }
        if (this.currentAuthentication instanceof KeyboardInteractiveAuthentication && ((KeyboardInteractiveAuthentication)this.currentAuthentication).getSelectedProvider().getName().equals("password")) {
            this.completedAuthentications.add("password");
        }
        this.completedAuthentications.add(this.currentAuthentication.getMethod());
        boolean completed = true;
        for (int i = 0; i < this.requiredAuthentications.length; ++i) {
            completed &= this.completedAuthentications.contains(this.requiredAuthentications[i]);
        }
        if (completed) {
            this.authenticated = true;
            this.authInProgress = false;
            this.transport.postMessage(new SshMessage(){

                public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                    buf.put((byte)52);
                    return true;
                }

                public void messageSent(Long sequenceNo) throws SshException {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Sent SSH_MSG_USERAUTH_SUCCESS method=" + AuthenticationProtocolServer.this.currentMethod + " completed=" + AuthenticationProtocolServer.this.createList(AuthenticationProtocolServer.this.completedAuthentications.toArray(new String[0])) + " required=" + AuthenticationProtocolServer.this.createList(AuthenticationProtocolServer.this.requiredAuthentications)), (Object[])new Object[0]);
                    }
                    EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777200, true).addAttribute("CONNECTION", (Object)AuthenticationProtocolServer.this.transport.getConnection()).addAttribute("USERNAME", (Object)AuthenticationProtocolServer.this.username).addAttribute("AUTHENTICATION_METHOD", (Object)AuthenticationProtocolServer.this.currentMethod).addAttribute("OP_STARTED", (Object)AuthenticationProtocolServer.this.started).addAttribute("OP_FINISHED", (Object)new Date()));
                    EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777198, true).addAttribute("CONNECTION", (Object)AuthenticationProtocolServer.this.transport.getConnection()).addAttribute("AUTHENTICATION_METHODS", AuthenticationProtocolServer.this.completedAuthentications));
                    for (ServerConnectionStateListener listener : AuthenticationProtocolServer.this.getContext().getStateListeners()) {
                        listener.authenticationComplete((SshConnection)AuthenticationProtocolServer.this.transport.getConnection());
                    }
                    AuthenticationProtocolServer.this.transport.startService((Service)new ConnectionProtocolServer(AuthenticationProtocolServer.this.transport, AuthenticationProtocolServer.this.username));
                }
            });
        } else {
            this.failedAuthentication(true, true);
        }
    }

    public void discardAuthentication() {
        this.authInProgress = false;
    }

    public synchronized void failedAuthentication() {
        this.failedAuthentication(false, false);
    }

    public synchronized void failedAuthentication(boolean partial, boolean ignoreFailed) {
        if (this.transport == null || !this.transport.isConnected()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Transport is no longer connected!", (Object[])new Object[0]);
            }
            return;
        }
        String[] supported = ((AuthenticationMechanismFactory)this.transport.getContext().getPolicy(AuthenticationMechanismFactory.class)).getSupportedMechanisms();
        if (Boolean.getBoolean("maverick.oldMethodsToContinue")) {
            this.failedAuthentication(partial, ignoreFailed, supported);
        } else {
            ArrayList<String> tmp = new ArrayList<String>();
            for (int i = 0; i < supported.length; ++i) {
                if (this.completedAuthentications.contains(supported[i])) continue;
                tmp.add(supported[i]);
            }
            this.failedAuthentication(partial, ignoreFailed, tmp.toArray(new String[0]));
        }
    }

    private synchronized void failedAuthentication(final boolean partial, boolean ignoreFailed, final String[] methodsToContinue) {
        final String[] methods = methodsToContinue == null || methodsToContinue.length == 0 ? ((AuthenticationMechanismFactory)this.transport.getContext().getPolicy(AuthenticationMechanismFactory.class)).getSupportedMechanisms() : methodsToContinue;
        this.fireFailureEvent(partial, ignoreFailed, methodsToContinue);
        if (!this.currentMethod.equals("none") && !partial) {
            if (!ignoreFailed) {
                ++this.failed;
                ((IPPolicy)this.getContext().getPolicy(IPPolicy.class)).flagAddress(this.transport.getConnection().getRemoteAddress());
            }
            if (this.failed >= ((AuthenticationPolicy)((SshServerContext)this.transport.getSshContext()).getPolicy(AuthenticationPolicy.class)).getMaxAuthentications()) {
                this.transport.disconnect(11, "Too many bad authentication attempts!");
                return;
            }
        }
        this.authInProgress = false;
        this.transport.postMessage(new SshMessage(){

            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                buf.put((byte)51);
                String list = AuthenticationProtocolServer.this.createList(methods);
                buf.putInt(list.length());
                buf.put(list.getBytes());
                buf.put((byte)(partial ? 1 : 0));
                return true;
            }

            public void messageSent(Long sequenceNo) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Sent SSH_MSG_USERAUTH_FAILURE method=" + AuthenticationProtocolServer.this.currentMethod + " availableMethods=" + AuthenticationProtocolServer.this.createList(methodsToContinue) + " partial=" + partial + " required=" + AuthenticationProtocolServer.this.createList(AuthenticationProtocolServer.this.requiredAuthentications)), (Object[])new Object[0]);
                }
            }
        });
    }

    private void fireFailureEvent(boolean partial, boolean ignoreFailed, String[] methodsToContinue) {
        if (!this.currentMethod.equals("none")) {
            if (!partial) {
                if (!ignoreFailed) {
                    EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777199, true).addAttribute("CONNECTION", (Object)this.transport.getConnection()).addAttribute("USERNAME", (Object)this.username).addAttribute("AUTHENTICATION_METHODS", (Object)this.createList(methodsToContinue)).addAttribute("AUTHENTICATION_METHOD", (Object)this.currentMethod));
                }
            } else {
                EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777200, true).addAttribute("CONNECTION", (Object)this.transport.getConnection()).addAttribute("USERNAME", (Object)this.username).addAttribute("AUTHENTICATION_METHODS", (Object)this.createList(methodsToContinue)).addAttribute("AUTHENTICATION_METHOD", (Object)this.currentMethod));
            }
        }
    }

    private String createList(String[] methods) {
        String list = "";
        for (int i = 0; i < methods.length; ++i) {
            list = list + (i > 0 ? "," : "") + methods[i];
        }
        return list;
    }

    public int getIdleTimeoutSeconds() {
        return this.transport.getContext().getIdleAuthenticationTimeoutSeconds();
    }

    public boolean idle() {
        this.transport.disconnect(11, "Idle unauthenticated connection");
        return true;
    }

    public String getName() {
        return SERVICE_NAME;
    }

    public boolean canContinue() {
        return this.failed <= ((AuthenticationPolicy)this.getContext().getPolicy(AuthenticationPolicy.class)).getMaxAuthentications();
    }

    public void markFailed() {
        ++this.failed;
    }
}

