/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.sftp.SftpClientTask;
import com.sshtools.client.sftp.TransferCancelledException;
import com.sshtools.client.tasks.Task;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.util.IOUtils;
import com.sshtools.synergy.ssh.ConnectionTaskWrapper;
import java.io.OutputStream;

public class DownloadOutputStreamTask
extends Task {
    String path;
    OutputStream localFile = null;

    public DownloadOutputStreamTask(SshConnection con, String path, OutputStream localFile) {
        super(con);
        this.path = path;
        this.localFile = localFile;
    }

    public DownloadOutputStreamTask(SshConnection con, String path) {
        this(con, path, null);
    }

    protected void doTask() {
        SftpClientTask task = new SftpClientTask(this.con){

            @Override
            protected void doSftp() {
                try {
                    this.get(DownloadOutputStreamTask.this.path, DownloadOutputStreamTask.this.localFile);
                }
                catch (TransferCancelledException | SftpStatusException | SshException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        };
        try {
            this.con.addTask((ConnectionAwareTask)new ConnectionTaskWrapper(this.con, (Runnable)task));
            task.waitForever();
        }
        catch (Throwable throwable) {
            IOUtils.closeStream((OutputStream)this.localFile);
            this.done(task.isDone() && task.isSuccess());
            throw throwable;
        }
        IOUtils.closeStream((OutputStream)this.localFile);
        this.done(task.isDone() && task.isSuccess());
    }
}

