/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.shell;

import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.SshClientContext;
import com.sshtools.client.shell.ShellController;
import com.sshtools.client.shell.ShellDefaultMatcher;
import com.sshtools.client.shell.ShellInputStream;
import com.sshtools.client.shell.ShellMatcher;
import com.sshtools.client.shell.ShellProcess;
import com.sshtools.client.shell.ShellProcessController;
import com.sshtools.client.shell.ShellReader;
import com.sshtools.client.shell.ShellStartupTrigger;
import com.sshtools.client.shell.ShellTimeoutException;
import com.sshtools.client.tasks.AbstractSessionTask;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.synergy.ssh.Connection;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ExpectShell {
    public static final int OS_WINDOWS = 1;
    public static final int OS_LINUX = 2;
    public static final int OS_SOLARIS = 3;
    public static final int OS_AIX = 4;
    public static final int OS_DARWIN = 5;
    public static final int OS_FREEBSD = 6;
    public static final int OS_OPENBSD = 7;
    public static final int OS_NETBSD = 8;
    public static final int OS_HPUX = 9;
    public static final int OS_UNIX = 20;
    public static final int OS_OPENVMS = 21;
    public static final int OS_UNKNOWN = 99;
    private int osType = 99;
    private String osDescription = "Unknown";
    private String passwordErrorText = "Sorry, try again.";
    private String passwordPrompt = "Password:";
    static final String BEGIN_COMMAND_MARKER = "---BEGIN---";
    static final String END_COMMAND_MARKER = "---END---";
    static final String PROCESS_MARKER = "PROCESS=";
    static final String EXIT_CODE_MARKER = "EXITCODE=";
    static final int WAITING_FOR_COMMAND = 1;
    static final int PROCESSING_COMMAND = 2;
    static final int CLOSED = 3;
    BufferedInputStream sessionIn;
    OutputStream sessionOut;
    int state = 1;
    boolean inStartup;
    private String PIPE_CMD = "";
    private String ECHO_COMMAND = "echo";
    private String EOL = "\r\n";
    private String EXIT_CODE_VARIABLE = "%errorlevel%";
    private static int SHELL_INIT_PERIOD = 2000;
    List<Runnable> closeHooks = new ArrayList<Runnable>();
    int numCommandsExecuted = 0;
    private static boolean verboseDebug = Boolean.getBoolean("maverick.shell.verbose");
    private StartupInputStream startupIn;
    private ShellController startupController;
    private boolean childShell = false;
    public static final int EXIT_CODE_PROCESS_ACTIVE = Integer.MIN_VALUE;
    public static final int EXIT_CODE_UNKNOWN = -2147483647;
    long startupTimeout;
    long startupStarted;
    AbstractSessionTask<SessionChannelNG> session;
    String characterEncoding = "UTF-8";

    public ExpectShell(AbstractSessionTask<SessionChannelNG> session) throws SshException, IOException, ShellTimeoutException {
        this(session, null, 30000L, "dumb", 1024, 80);
    }

    public ExpectShell(AbstractSessionTask<SessionChannelNG> session, ShellStartupTrigger trigger) throws SshException, IOException, ShellTimeoutException {
        this(session, trigger, 30000L, "dumb", 1024, 80);
    }

    public ExpectShell(AbstractSessionTask<SessionChannelNG> session, ShellStartupTrigger trigger, long startupTimeout) throws SshException, IOException, ShellTimeoutException {
        this(session, trigger, startupTimeout, "dumb", 1024, 80);
    }

    public ExpectShell(AbstractSessionTask<SessionChannelNG> session, ShellStartupTrigger trigger, long startupTimeout, String termtype) throws SshException, IOException, ShellTimeoutException {
        this(session, trigger, startupTimeout, termtype, 1024, 80);
    }

    public ExpectShell(AbstractSessionTask<SessionChannelNG> session, ShellStartupTrigger trigger, long startupTimeout, String termtype, int cols, int rows) throws SshException, IOException, ShellTimeoutException {
        this.startupTimeout = startupTimeout;
        this.startupStarted = System.currentTimeMillis();
        this.session = session;
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Creating session for interactive shell", (Object[])new Object[0]);
        }
        this.closeHooks.add(new Runnable(){

            @Override
            public void run() {
                ExpectShell.this.session.close();
            }
        });
        if (SHELL_INIT_PERIOD > 0) {
            try {
                Thread.sleep(SHELL_INIT_PERIOD);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.determineServerType((Connection<SshClientContext>)session.getSession().getConnection());
        this.init(session.getSession().getInputStream(), session.getSession().getOutputStream(), this.osType != 21, trigger);
    }

    ExpectShell(InputStream in, OutputStream out, String eol, String echoCmd, String exitCodeVar, int osType, String osDescription, ExpectShell parentShell) throws SshIOException, SshException, IOException, ShellTimeoutException {
        this.EOL = eol;
        this.ECHO_COMMAND = echoCmd;
        this.EXIT_CODE_VARIABLE = exitCodeVar;
        this.osType = osType;
        this.osDescription = osDescription;
        this.childShell = true;
        this.init(in, out, true, null);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public static void setShellInitTimeout(int timeout) {
        SHELL_INIT_PERIOD = timeout;
    }

    public InputStream getStartupInputStream() {
        return this.startupIn;
    }

    void determineServerType(Connection<SshClientContext> con) {
        String remoteID = con.getRemoteIdentification();
        if (remoteID.indexOf("OpenVMS") > 0) {
            this.osType = 21;
            this.PIPE_CMD = "PIPE ";
            this.ECHO_COMMAND = "WRITE SYS$OUTPUT";
            this.EXIT_CODE_VARIABLE = "$SEVERITY";
        }
    }

    void init(InputStream in, OutputStream out, boolean detectSettings, ShellStartupTrigger trigger) throws SshIOException, SshException, IOException, ShellTimeoutException {
        this.sessionIn = new BufferedInputStream(in);
        this.sessionOut = out;
        this.startupIn = new StartupInputStream(BEGIN_COMMAND_MARKER, detectSettings, trigger);
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Session creation complete", (Object[])new Object[0]);
        }
    }

    public boolean inStartup() {
        return this.inStartup;
    }

    public void setPasswordErrorText(String passwordErrorText) {
        this.passwordErrorText = passwordErrorText;
    }

    public void setPasswordPrompt(String passwordPrompt) {
        this.passwordPrompt = passwordPrompt;
    }

    public ShellReader getStartupReader() {
        return this.startupController;
    }

    public ExpectShell su(String cmd, String password) throws SshIOException, SshException, IOException, ShellTimeoutException {
        return this.su(cmd, password, this.passwordPrompt, new ShellDefaultMatcher());
    }

    public ExpectShell su(String cmd, String password, String promptExpression) throws SshException, SshIOException, IOException, ShellTimeoutException {
        return this.su(cmd, password, promptExpression, new ShellDefaultMatcher());
    }

    public ExpectShell su(String cmd) throws SshException, SshIOException, IOException, ShellTimeoutException {
        ShellProcess process = this.executeCommand(cmd, false, false);
        return new ExpectShell(process.getInputStream(), process.getOutputStream(), this.EOL, this.ECHO_COMMAND, this.EXIT_CODE_VARIABLE, this.osType, this.osDescription, this);
    }

    public ExpectShell su(String cmd, String password, String promptExpression, ShellMatcher matcher) throws SshException, SshIOException, IOException, ShellTimeoutException {
        ShellProcess process = this.executeCommand(cmd, false, false);
        ShellProcessController contr = new ShellProcessController(process, matcher);
        process.mark(1024);
        if (contr.expectNextLine(promptExpression)) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"su password expression matched", (Object[])new Object[0]);
            }
            contr.typeAndReturn(password);
            contr.readLine();
            process.mark(1024);
            if (contr.expectNextLine(this.passwordErrorText)) {
                throw new IOException("Incorrect password!");
            }
            process.reset();
        } else {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"su password expression not matched", (Object[])new Object[0]);
            }
            process.reset();
        }
        if (process.isActive()) {
            return new ExpectShell(process.getInputStream(), process.getOutputStream(), this.EOL, this.ECHO_COMMAND, this.EXIT_CODE_VARIABLE, this.osType, this.osDescription, this);
        }
        throw new SshException("The command failed: " + cmd, 15);
    }

    public ShellProcess sudo(String cmd, String password) throws SshException, ShellTimeoutException, IOException {
        return this.sudo(cmd, password, this.passwordPrompt, new ShellDefaultMatcher());
    }

    public ShellProcess sudo(String cmd, String password, String promptExpression) throws SshException, ShellTimeoutException, IOException {
        return this.sudo(cmd, password, promptExpression, new ShellDefaultMatcher());
    }

    public ShellProcess sudo(String cmd, String password, String promptExpression, ShellMatcher matcher) throws SshException, ShellTimeoutException, IOException {
        ShellProcess process = this.executeCommand(cmd, false, false);
        ShellProcessController contr = new ShellProcessController(process, matcher);
        process.mark(1024);
        if (contr.expectNextLine(promptExpression)) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"sudo password expression matched", (Object[])new Object[0]);
            }
            contr.typeAndReturn(password);
            process.mark(1024);
            if (contr.expectNextLine(this.passwordErrorText)) {
                throw new IOException("Incorrect password!");
            }
            process.reset();
        } else {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"sudo password expression not matched", (Object[])new Object[0]);
            }
            process.reset();
        }
        return process;
    }

    public boolean isClosed() {
        return this.state == 3;
    }

    private void updateDescription() {
        this.osDescription = this.osType == 3 ? "Solaris" : (this.osType == 4 ? "AIX" : (this.osType == 1 ? "Windows" : (this.osType == 5 ? "Darwin" : (this.osType == 6 ? "FreeBSD" : (this.osType == 7 ? "OpenBSD" : (this.osType == 8 ? "NetBSD" : (this.osType == 2 ? "Linux" : (this.osType == 9 ? "HP-UX" : (this.osType == 21 ? "OpenVMS" : "Unknown")))))))));
    }

    public void exit() throws IOException, SshException {
        this.sessionOut.write(("exit" + this.EOL).getBytes());
        if (this.childShell) {
            while (this.sessionIn.read() > -1) {
            }
        }
        this.close();
    }

    public void close() throws IOException, SshException {
        this.internalClose();
    }

    public String getNewline() {
        if (this.osType == 1) {
            return "\r\n";
        }
        return "\n";
    }

    public synchronized ShellProcess executeCommand(String origCmd) throws SshException {
        return this.executeCommand(origCmd, false, false, "UTF-8");
    }

    public synchronized ShellProcess executeCommand(String origCmd, boolean consume) throws SshException {
        return this.executeCommand(origCmd, false, consume, "UTF-8");
    }

    public synchronized ShellProcess executeCommand(String origCmd, String charset) throws SshException {
        return this.executeCommand(origCmd, false, false, charset);
    }

    public synchronized ShellProcess executeCommand(String origCmd, boolean consume, String charset) throws SshException {
        return this.executeCommand(origCmd, false, consume, charset);
    }

    public synchronized ShellProcess executeCommand(String origCmd, boolean matchPromptMarker, boolean consume) throws SshException {
        return this.executeCommand(origCmd, matchPromptMarker, consume, "UTF-8");
    }

    public synchronized ShellProcess executeCommand(String origCmd, boolean matchPromptMarker, boolean consume, String charset) throws SshException {
        try {
            String cmd = origCmd;
            if (this.state == 2) {
                throw new SshException("Command still active", 4);
            }
            if (this.state == 3) {
                throw new SshException("Shell is closed!", 4);
            }
            this.checkStartupFinished();
            this.state = 2;
            StringBuffer prompt = new StringBuffer();
            if (matchPromptMarker |= (origCmd.startsWith(".") || origCmd.startsWith("source")) && this.osType == 9) {
                int ch;
                this.sessionOut.write(this.EOL.getBytes());
                this.sessionOut.write(this.EOL.getBytes());
                while ((ch = this.sessionIn.read()) > -1 && ch != 10) {
                }
                while ((ch = this.sessionIn.read()) > -1 && ch != 10) {
                    prompt.append((char)ch);
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Prompt is " + prompt.toString().trim()), (Object[])new Object[0]);
                }
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Executing command: " + cmd), (Object[])new Object[0]);
            }
            String endCommand = this.nextEndMarker();
            String echoCmd = this.osType == 1 ? this.ECHO_COMMAND + " " + BEGIN_COMMAND_MARKER + " && " + cmd + " && " + this.ECHO_COMMAND + " " + endCommand + "0 || " + this.ECHO_COMMAND + " " + endCommand + "1" + this.EOL : (this.osType == 21 ? this.PIPE_CMD + this.ECHO_COMMAND + " \"" + BEGIN_COMMAND_MARKER + "\" && " + cmd + " && " + this.ECHO_COMMAND + " \"" + endCommand + "0\" || " + this.ECHO_COMMAND + "\"" + endCommand + "1\"" + this.EOL : "echo \"---BEGIN---\"; " + cmd + "; echo \"" + endCommand + this.EXIT_CODE_VARIABLE + "\"" + this.EOL);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Executing raw command: {}", (Object[])new Object[]{echoCmd});
            }
            this.sessionOut.write(echoCmd.getBytes(charset));
            ++this.numCommandsExecuted;
            ShellInputStream in = new ShellInputStream(this, BEGIN_COMMAND_MARKER, endCommand, origCmd, matchPromptMarker, prompt.toString().trim());
            ShellProcess process = new ShellProcess(this, in);
            if (consume) {
                while (process.getInputStream().read() > -1) {
                }
            }
            return process;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException("Failed to execute command: " + ex.getMessage(), 6);
        }
    }

    public int getNumCommandsExecuted() {
        return this.numCommandsExecuted;
    }

    private void checkStartupFinished() throws IOException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Checking state of startup controller", (Object[])new Object[0]);
        }
        if (!this.startupIn.isClosed()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Shell still in startup mode, draining startup output", (Object[])new Object[0]);
            }
            while (this.startupIn.read() > -1) {
            }
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Shell is ready for command", (Object[])new Object[0]);
        }
    }

    private synchronized String nextEndMarker() {
        return "---END---;PROCESS=" + System.currentTimeMillis() + ";" + EXIT_CODE_MARKER;
    }

    public int getOsType() {
        return this.osType;
    }

    public String getOsDescription() {
        return this.osDescription;
    }

    void type(String string) throws IOException {
        this.write(string.getBytes());
    }

    void write(byte[] bytes) throws IOException {
        this.sessionOut.write(bytes);
    }

    void type(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    void carriageReturn() throws IOException {
        this.write(this.EOL.getBytes());
    }

    void typeAndReturn(String string) throws IOException {
        this.write((string + this.EOL).getBytes());
    }

    void internalClose() {
        this.state = 3;
        for (Runnable r : this.closeHooks) {
            try {
                r.run();
            }
            catch (Throwable throwable) {}
        }
    }

    class StartupInputStream
    extends InputStream {
        char[] marker1;
        int markerPos;
        StringBuffer currentLine = new StringBuffer();
        boolean detectSettings;

        StartupInputStream(String marker1str, boolean detectSettings, ShellStartupTrigger trigger) throws SshException, IOException, ShellTimeoutException {
            this.detectSettings = detectSettings;
            this.marker1 = marker1str.toCharArray();
            ExpectShell.this.startupController = new ShellController(ExpectShell.this, new ShellDefaultMatcher(), this);
            if (trigger != null) {
                StringBuffer line = new StringBuffer();
                do {
                    int ch;
                    if ((ch = this.internalRead(ExpectShell.this.sessionIn)) != 10 && ch != 13 && ch != -1) {
                        line.append((char)ch);
                    }
                    if (ch == 10) {
                        line.setLength(0);
                    }
                    if (ch != -1) continue;
                    throw new SshException("Shell output ended before trigger could start shell", 20);
                } while (!trigger.canStartShell(line.toString(), ExpectShell.this.startupController));
            }
            if (detectSettings) {
                String cmd = ExpectShell.this.PIPE_CMD + ExpectShell.this.ECHO_COMMAND + " \"" + marker1str + "\" ; " + ExpectShell.this.ECHO_COMMAND + " $?\r\n";
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Performing marker test: " + cmd), (Object[])new Object[0]);
                }
                ExpectShell.this.sessionOut.write(cmd.getBytes());
            }
            ExpectShell.this.inStartup = detectSettings;
        }

        boolean isClosed() {
            return !ExpectShell.this.inStartup;
        }

        int internalRead(InputStream in) throws IOException {
            while (true) {
                try {
                    return in.read();
                }
                catch (SshIOException e) {
                    if (e.getRealException().getReason() == 21) {
                        if (System.currentTimeMillis() - ExpectShell.this.startupStarted <= ExpectShell.this.startupTimeout) continue;
                        throw new SshIOException(new SshException("", 20));
                    }
                    throw e;
                }
                break;
            }
        }

        String internalReadLine(InputStream in) throws IOException {
            int ch;
            StringBuffer tmp = new StringBuffer();
            do {
                if ((ch = this.internalRead(in)) <= -1) continue;
                tmp.append((char)ch);
            } while (ch != -1 && ch != 10);
            return tmp.toString().trim();
        }

        @Override
        public int read() throws IOException {
            if (ExpectShell.this.inStartup) {
                int ch;
                ExpectShell.this.sessionIn.mark(this.marker1.length + 1);
                StringBuffer tmp = new StringBuffer();
                while (true) {
                    try {
                        do {
                            ch = this.internalRead(ExpectShell.this.sessionIn);
                            tmp.append((char)ch);
                        } while (this.markerPos < this.marker1.length - 1 && this.marker1[this.markerPos++] == ch);
                    }
                    catch (SshIOException e) {
                        if (e.getRealException().getReason() == 21) {
                            if (System.currentTimeMillis() - ExpectShell.this.startupStarted <= ExpectShell.this.startupTimeout) continue;
                            throw new SshIOException(new SshException("", 20));
                        }
                        throw e;
                    }
                    break;
                }
                if (this.markerPos == this.marker1.length - 1) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Potentially found test marker [" + this.currentLine.toString() + tmp.toString() + "]"), (Object[])new Object[0]);
                    }
                    if ((ch = this.internalRead(ExpectShell.this.sessionIn)) == 13) {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Looking good, found CR", (Object[])new Object[0]);
                        }
                        ch = this.internalRead(ExpectShell.this.sessionIn);
                    }
                    if (ch == 10) {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Found test marker", (Object[])new Object[0]);
                        }
                        try {
                            this.detect();
                        }
                        catch (SshException e) {
                            throw new SshIOException(e);
                        }
                        return -1;
                    }
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Detected echo of test marker command since we did not find LF at end of marker ch=" + Integer.valueOf(ch) + " currentLine=" + this.currentLine.toString() + tmp.toString()), (Object[])new Object[0]);
                    }
                }
                ExpectShell.this.sessionIn.reset();
                ch = this.internalRead(ExpectShell.this.sessionIn);
                this.markerPos = 0;
                this.currentLine.append((char)ch);
                if (ch == 10) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Shell startup (read): " + this.currentLine.toString()), (Object[])new Object[0]);
                    }
                    this.currentLine = new StringBuffer();
                }
                if (verboseDebug && Log.isDebugEnabled()) {
                    Log.debug((String)("Shell startup (read): " + this.currentLine.toString()), (Object[])new Object[0]);
                }
                ExpectShell.this.sessionIn.mark(-1);
                return ch;
            }
            return -1;
        }

        void detect() throws IOException, SshException {
            ExpectShell.this.inStartup = false;
            if (!this.detectSettings) {
                return;
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Detecting shell settings", (Object[])new Object[0]);
            }
            String line = this.internalReadLine(ExpectShell.this.sessionIn);
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Shell startup (detect): " + line), (Object[])new Object[0]);
            }
            if (line.equals("0") && ExpectShell.this.osType == 99) {
                String tmp;
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"This looks like a *nix type machine, setting EOL to CR only and exit code variable to $?", (Object[])new Object[0]);
                }
                ExpectShell.this.EOL = "\r";
                ExpectShell.this.EXIT_CODE_VARIABLE = "$?";
                ShellProcess proc = ExpectShell.this.executeCommand("uname");
                BufferedReader r2 = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                line = "";
                while ((tmp = r2.readLine()) != null) {
                    line = line + tmp;
                }
                switch (proc.getExitCode()) {
                    case 0: {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)("Remote side reported it is " + line.trim()), (Object[])new Object[0]);
                        }
                        if ((line = line.toLowerCase()).startsWith("Sun")) {
                            ExpectShell.this.osType = 3;
                            break;
                        }
                        if (line.startsWith("aix")) {
                            ExpectShell.this.osType = 4;
                            break;
                        }
                        if (line.startsWith("darwin")) {
                            ExpectShell.this.osType = 5;
                            break;
                        }
                        if (line.startsWith("freebsd")) {
                            ExpectShell.this.osType = 6;
                            break;
                        }
                        if (line.startsWith("openbsd")) {
                            ExpectShell.this.osType = 7;
                            break;
                        }
                        if (line.startsWith("netbsd")) {
                            ExpectShell.this.osType = 8;
                            break;
                        }
                        if (line.startsWith("linux")) {
                            ExpectShell.this.osType = 2;
                            break;
                        }
                        if (line.startsWith("hp-ux")) {
                            ExpectShell.this.osType = 9;
                            break;
                        }
                        ExpectShell.this.osType = 99;
                        break;
                    }
                    case 127: {
                        Log.debug((String)"Remote side does not support uname", (Object[])new Object[0]);
                        break;
                    }
                    default: {
                        Log.debug((String)("uname returned error code " + proc.getExitCode()), (Object[])new Object[0]);
                        break;
                    }
                }
            } else if (ExpectShell.this.osType == 99) {
                String cmd = "echo ---BEGIN--- && echo %errorlevel%\r\n";
                ExpectShell.this.sessionOut.write(cmd.getBytes());
                while ((line = this.internalReadLine(ExpectShell.this.sessionIn)) != null && !line.endsWith(ExpectShell.BEGIN_COMMAND_MARKER)) {
                    if (line.trim().equals("") || !Log.isDebugEnabled()) continue;
                    Log.debug((String)("Shell startup: " + line), (Object[])new Object[0]);
                }
                line = this.internalReadLine(ExpectShell.this.sessionIn);
                if (line.equals("0")) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"This looks like a Windows machine, setting EOL to CRLF and exit code variable to %errorlevel%", (Object[])new Object[0]);
                    }
                    ExpectShell.this.EOL = "\r\n";
                    ExpectShell.this.EXIT_CODE_VARIABLE = "%errorlevel%";
                    ExpectShell.this.osType = 1;
                }
            }
            ExpectShell.this.updateDescription();
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Setting default sudo prompt", (Object[])new Object[0]);
            }
            ExpectShell.this.executeCommand("export SUDO_PROMPT=Password:", true);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Shell initialized", (Object[])new Object[0]);
            }
        }
    }
}

