/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.callback.commands;

import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.tasks.ShellTask;
import com.sshtools.client.tasks.Task;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.IOUtils;
import com.sshtools.server.callback.Callback;
import com.sshtools.server.callback.commands.CallbackCommand;
import com.sshtools.server.vsession.UsageException;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.server.vsession.VirtualShellNG;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class CallbackShell
extends CallbackCommand {
    public CallbackShell() {
        super("shell", "Callback", "shell <uuid>", "Open a shell to the callback client identified by uuid");
    }

    public void run(String[] args, VirtualConsole console) throws IOException, PermissionDeniedException, UsageException {
        if (args.length != 2) {
            throw new UsageException("Invalid number of arguments");
        }
        String clientName = args[1];
        Callback con = this.service.getCallbackByUUID(clientName);
        if (Objects.isNull(con)) {
            console.println(String.format("%s is not currently connected", clientName));
            return;
        }
        console.println(String.format("---- Opening shell on %s", clientName));
        console.println();
        WindowSizeChange listener = new WindowSizeChange();
        con.addTask((Task)((ShellTask.ShellTaskBuilder)ShellTask.ShellTaskBuilder.create().withConnection(con.getConnection())).withTermType(console.getTerminal().getType()).withColumns(console.getTerminal().getWidth()).withRows(console.getTerminal().getHeight()).onBeforeTask((task, session) -> {
            console.getSessionChannel().pauseDataCaching();
            listener.session = session;
            ((VirtualShellNG)console.getSessionChannel()).addWindowSizeChangeListener((VirtualShellNG.WindowSizeChangeListener)listener);
            con.addTask(Task.ofRunnable((SshConnection)con.getConnection(), c -> IOUtils.copy((InputStream)console.getSessionChannel().getInputStream(), (OutputStream)session.getOutputStream())));
            IOUtils.copy((InputStream)session.getInputStream(), (OutputStream)console.getSessionChannel().getOutputStream());
        }).onClose((task, session) -> ((VirtualShellNG)console.getSessionChannel()).removeWindowSizeChangeListener((VirtualShellNG.WindowSizeChangeListener)listener)).build()).waitForever();
        console.getSessionChannel().resumeDataCaching();
        console.println();
        console.println(String.format("---- Exited shell on %s", clientName));
    }

    class WindowSizeChange
    implements VirtualShellNG.WindowSizeChangeListener {
        SessionChannelNG session;

        WindowSizeChange() {
        }

        public void newSize(int rows, int cols) {
            if (this.session != null) {
                this.session.changeTerminalDimensions(cols, rows, 0, 0);
            }
        }
    }
}

