/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.callback;

import com.sshtools.common.forwarding.ForwardingPolicy;
import com.sshtools.common.logger.Log;
import com.sshtools.common.nio.WriteOperationRequest;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.Context;
import com.sshtools.common.ssh.ExecutorOperationQueues;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.synergy.ssh.ChannelNG;
import com.sshtools.synergy.ssh.ForwardingChannel;
import com.sshtools.synergy.ssh.SshContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class CallbackForwardingChannel<T extends SshContext>
extends ForwardingChannel<T> {
    static final String DIRECT_STREAM_LOCAL_CHANNEL = "direct-streamlocal@openssh.com";
    CallbackForwardingChannel<?> channel;
    SshConnection callbackClient;
    static final Integer CHANNEL_QUEUE = ExecutorOperationQueues.generateUniqueQueue((String)"callbackDataQueue");

    public CallbackForwardingChannel(Context ctx, SshConnection callbackClient) {
        this("direct-tcpip", ctx, callbackClient);
        this.callbackClient = callbackClient;
    }

    public CallbackForwardingChannel(String channel, Context ctx, SshConnection callbackClient) {
        super(channel, ((ForwardingPolicy)ctx.getPolicy(ForwardingPolicy.class)).getForwardingMaxPacketSize(), ((ForwardingPolicy)ctx.getPolicy(ForwardingPolicy.class)).getForwardingMaxWindowSize(), ((ForwardingPolicy)ctx.getPolicy(ForwardingPolicy.class)).getForwardingMaxWindowSize(), ((ForwardingPolicy)ctx.getPolicy(ForwardingPolicy.class)).getForwardingMinWindowSize(), true);
        this.callbackClient = callbackClient;
    }

    public CallbackForwardingChannel(Context ctx, SshConnection callbackClient, String hostToConnect, int portToConnect) {
        super("direct-tcpip", ((ForwardingPolicy)ctx.getPolicy(ForwardingPolicy.class)).getForwardingMaxPacketSize(), ((ForwardingPolicy)ctx.getPolicy(ForwardingPolicy.class)).getForwardingMaxWindowSize(), ((ForwardingPolicy)ctx.getPolicy(ForwardingPolicy.class)).getForwardingMaxWindowSize(), ((ForwardingPolicy)ctx.getPolicy(ForwardingPolicy.class)).getForwardingMinWindowSize(), true);
        this.callbackClient = callbackClient;
        this.hostToConnect = hostToConnect;
        this.portToConnect = portToConnect;
    }

    public void setBoundChannel(CallbackForwardingChannel<?> channel) {
        this.channel = channel;
    }

    public CallbackForwardingChannel(String channelType, SshConnection con, String hostToConnect, int portToConnect) {
        super(channelType, ((ForwardingPolicy)con.getContext().getPolicy(ForwardingPolicy.class)).getForwardingMaxPacketSize(), ((ForwardingPolicy)con.getContext().getPolicy(ForwardingPolicy.class)).getForwardingMaxWindowSize(), ((ForwardingPolicy)con.getContext().getPolicy(ForwardingPolicy.class)).getForwardingMaxWindowSize(), ((ForwardingPolicy)con.getContext().getPolicy(ForwardingPolicy.class)).getForwardingMinWindowSize(), true);
        this.hostToConnect = hostToConnect;
        this.portToConnect = portToConnect;
    }

    public CallbackForwardingChannel(String channelType, Context ctx, SshConnection con, String hostToConnect, int portToConnect) {
        super(channelType, ((ForwardingPolicy)con.getContext().getPolicy(ForwardingPolicy.class)).getForwardingMaxPacketSize(), ((ForwardingPolicy)ctx.getPolicy(ForwardingPolicy.class)).getForwardingMaxWindowSize(), ((ForwardingPolicy)ctx.getPolicy(ForwardingPolicy.class)).getForwardingMaxWindowSize(), ((ForwardingPolicy)ctx.getPolicy(ForwardingPolicy.class)).getForwardingMinWindowSize(), true);
        this.hostToConnect = hostToConnect;
        this.portToConnect = portToConnect;
    }

    protected byte[] createChannel() throws IOException {
        if (this.getChannelType().equals(DIRECT_STREAM_LOCAL_CHANNEL)) {
            try (ByteArrayWriter baw = new ByteArrayWriter();){
                baw.writeString(this.hostToConnect);
                baw.writeString("");
                baw.writeInt(0);
                byte[] byArray = baw.toByteArray();
                return byArray;
            }
        }
        try (ByteArrayWriter baw = new ByteArrayWriter();){
            baw.writeString(this.hostToConnect);
            baw.writeInt(this.portToConnect);
            this.originatingHost = this.con.getRemoteIPAddress();
            baw.writeString(this.originatingHost);
            this.originatingPort = this.con.getRemotePort();
            baw.writeInt(this.originatingPort);
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
    }

    protected byte[] openChannel(byte[] requestdata) throws WriteOperationRequest, ChannelOpenException {
        try (ByteArrayReader bar = new ByteArrayReader(requestdata);){
            if (this.getChannelType().equals(DIRECT_STREAM_LOCAL_CHANNEL)) {
                this.hostToConnect = bar.readString();
                bar.readString();
                bar.readInt();
            } else {
                this.hostToConnect = bar.readString();
                this.portToConnect = (int)bar.readInt();
                this.originatingHost = bar.readString();
                this.originatingPort = (int)bar.readInt();
            }
            boolean success = this.checkPermissions();
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Forwarding policy has " + (success ? "authorized" : "denied") + " " + this.connection.getUsername() + (success ? " to open" : " from opening") + " a " + this.getChannelType() + " callback forwarding channel to " + this.hostToConnect + ":" + this.portToConnect), (Object[])new Object[0]);
            }
            if (!success) {
                throw new ChannelOpenException("User does not have permission", 1);
            }
            if (Objects.isNull(this.callbackClient)) {
                throw new ChannelOpenException(String.format("Callback client %s is not connected", this.hostToConnect), 2);
            }
            this.con.addTask(new ConnectionAwareTask(this.con){

                protected void doTask() throws Throwable {
                    CallbackForwardingChannel.this.channel = new CallbackForwardingChannel(CallbackForwardingChannel.this.getChannelType(), (Context)CallbackForwardingChannel.this.connection.getContext(), CallbackForwardingChannel.this.callbackClient, CallbackForwardingChannel.this.hostToConnect, CallbackForwardingChannel.this.portToConnect);
                    CallbackForwardingChannel.this.channel.setBoundChannel(CallbackForwardingChannel.this);
                    CallbackForwardingChannel.this.callbackClient.openChannel(CallbackForwardingChannel.this.channel);
                    CallbackForwardingChannel.this.channel.getOpenFuture().waitFor(30000L);
                    if (CallbackForwardingChannel.this.channel.getOpenFuture().isSuccess()) {
                        CallbackForwardingChannel.this.connection.sendChannelOpenConfirmation((ChannelNG)CallbackForwardingChannel.this, null);
                    } else {
                        CallbackForwardingChannel.this.connection.sendChannelOpenFailure((ChannelNG)CallbackForwardingChannel.this, 2, "Callback client failed to complete channel open within timeout period");
                    }
                }
            });
        }
        throw new WriteOperationRequest();
    }

    protected boolean checkPermissions() {
        return this.getContext().getForwardingPolicy().checkHostPermitted((SshConnection)this.getConnectionProtocol().getTransport().getConnection(), this.hostToConnect, this.portToConnect);
    }

    protected synchronized void onRegistrationComplete() {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Registration Complete", (Object[])new Object[0]);
        }
    }

    protected synchronized void onChannelOpenConfirmation() {
    }

    protected void onChannelData(final ByteBuffer data) {
        this.con.addTask(CHANNEL_QUEUE, new ConnectionAwareTask(this.con){

            protected void doTask() throws Throwable {
                CallbackForwardingChannel.this.channel.sendChannelDataAndBlock(data);
            }
        });
    }

    protected void onChannelOpenFailure() {
    }

    protected void onChannelFree() {
    }

    protected void onChannelClosed() {
        this.con.addTask(CHANNEL_QUEUE, new ConnectionAwareTask(this.con){

            protected void doTask() throws Throwable {
                CallbackForwardingChannel.this.channel.close();
            }
        });
    }

    protected void onChannelOpen() {
    }

    protected void onChannelClosing() {
    }

    protected void onChannelRequest(String type, boolean wantreply, byte[] requestdata) {
    }

    protected void onRemoteEOF() {
        this.channel.sendEOF();
    }

    protected void onLocalEOF() {
    }
}

