/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.callback;

import com.sshtools.client.ClientAuthenticator;
import com.sshtools.client.ClientStateListener;
import com.sshtools.client.SshClientContext;
import com.sshtools.common.auth.MutualKeyAuthenticatonStore;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.GlobalRequest;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.server.AbstractSshServer;
import com.sshtools.server.SshServerContext;
import com.sshtools.server.callback.Callback;
import com.sshtools.server.callback.CallbackRegistrationService;
import com.sshtools.server.callback.MutualCallbackAuthenticator;
import com.sshtools.server.callback.SwitchingSshContext;
import com.sshtools.synergy.nio.ProtocolContextFactory;
import com.sshtools.synergy.nio.SshEngineContext;
import com.sshtools.synergy.ssh.ConnectionProtocol;
import com.sshtools.synergy.ssh.GlobalRequestHandler;
import java.io.IOException;
import java.nio.channels.SocketChannel;

public class CallbackContextFactory
implements ProtocolContextFactory<SshClientContext> {
    public static final String CALLBACK_IDENTIFIER = "CallbackClient";
    public static final String CALLBACK_MEMO = "MEMO";
    String callbackIdentifier = "CallbackClient";
    MutualKeyAuthenticatonStore store;
    CallbackRegistrationService callbacks;
    AbstractSshServer server;

    public CallbackContextFactory(MutualKeyAuthenticatonStore store, CallbackRegistrationService callbacks, AbstractSshServer server) {
        this.store = store;
        this.callbacks = callbacks;
        this.server = server;
    }

    protected SshServerContext createServerContext(SshEngineContext daemonContext) throws IOException, SshException {
        return new SshServerContext(daemonContext.getEngine());
    }

    public SshClientContext createContext(SshEngineContext daemonContext, SocketChannel sc) throws IOException, SshException {
        SwitchingSshContext clientContext = new SwitchingSshContext(daemonContext.getEngine(), this.callbackIdentifier, new ProtocolContextFactory<SshServerContext>(){

            public SshServerContext createContext(SshEngineContext daemonContext, SocketChannel sc) throws IOException, SshException {
                SshServerContext serverContext = CallbackContextFactory.this.createServerContext(daemonContext);
                CallbackContextFactory.this.configureServerContext(serverContext, sc);
                return serverContext;
            }
        });
        clientContext.addAuthenticator((ClientAuthenticator)new MutualCallbackAuthenticator(this.store));
        clientContext.addStateListener(new ClientStateListener(){

            public void disconnected(SshConnection con) {
                if (con.getRemoteIdentification().substring(8).startsWith(CallbackContextFactory.this.callbackIdentifier)) {
                    Log.info((String)"Callback client {} disconnected", (Object[])new Object[]{con.getUsername()});
                    CallbackContextFactory.this.callbacks.unregisterCallbackClient(con.getUUID());
                }
            }
        });
        clientContext.addGlobalRequestHandler((GlobalRequestHandler)new GlobalRequestHandler<SshClientContext>(){

            public String[] supportedRequests() {
                return new String[]{"memo@jadaptive.com"};
            }

            public boolean processGlobalRequest(GlobalRequest request, ConnectionProtocol<SshClientContext> connection, boolean wantreply, ByteArrayWriter out) throws GlobalRequestHandler.GlobalRequestHandlerException {
                if ("memo@jadaptive.com".equals(request.getName())) {
                    try {
                        String memo = ByteArrayReader.decodeString((byte[])request.getData());
                        if (Log.isInfoEnabled()) {
                            Log.info((String)"Callback client {} registered with memo {}", (Object[])new Object[]{connection.getUUID(), memo});
                        }
                        CallbackContextFactory.this.callbacks.registerCallbackClient((SshConnection)connection.getConnection(), memo);
                        Callback c = CallbackContextFactory.this.callbacks.getCallbackByUUID(connection.getUUID());
                        connection.getConnection().setProperty(CallbackContextFactory.CALLBACK_MEMO, (Object)memo);
                        c.setMemo(memo);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return false;
                }
                return false;
            }
        });
        this.configureCallbackContext(clientContext);
        return clientContext;
    }

    protected void configureCallbackContext(SshClientContext clientContext) {
    }

    public void setCallbackIdentifier(String callbackIdentifier) {
        this.callbackIdentifier = callbackIdentifier;
    }

    public void setMutualAuthenticationStore(MutualKeyAuthenticatonStore store) {
        this.store = store;
    }

    protected void configureServerContext(SshServerContext serverContext, SocketChannel sc) throws IOException, SshException {
        this.server.configure(serverContext, sc);
    }
}

