/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.callback;

import com.sshtools.client.SshClient;
import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventListener;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.server.callback.Callback;
import com.sshtools.server.callback.CallbackRegistrationService;
import com.sshtools.server.callback.DefaultCallback;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.vsession.commands.ssh.AbstractSshOptionsEvaluator;
import com.sshtools.vsession.commands.ssh.SshClientArguments;
import com.sshtools.vsession.commands.ssh.SshOptionsResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class InMemoryCallbackRegistrationService
implements CallbackRegistrationService {
    public static final String PROXIED_CLIENT_CONNECTION = "proxyConnection";
    Map<String, Callback> callbacks = new HashMap<String, Callback>();

    public InMemoryCallbackRegistrationService() {
        AbstractSshOptionsEvaluator.addResolver((SshOptionsResolver)this);
    }

    public boolean resolveOptions(String destination, SshClientArguments arguments, final VirtualConsole console) throws IOException {
        Callback c;
        if (Log.isInfoEnabled()) {
            Log.info((String)"Looking for callback with destination {}", (Object[])new Object[]{destination});
        }
        if (Objects.nonNull(c = this.getCallbackByUUID(destination))) {
            if (Log.isInfoEnabled()) {
                Log.info((String)"Found callback with uuid {}", (Object[])new Object[]{destination});
            }
            arguments.setConnection(c.getConnection());
            if (Log.isInfoEnabled()) {
                Log.info((String)"Attaching callback connection {} as current proxied connection", (Object[])new Object[]{c.getConnection().getUUID()});
            }
            console.getConnection().setProperty(PROXIED_CLIENT_CONNECTION, (Object)SshClient.SshClientBuilder.create((SshConnection)c.getConnection()).withoutCloseOnDisconnect().build());
            c.getConnection().addEventListener(new EventListener(){

                public void processEvent(Event evt) {
                    if (evt.getId() == -16776961) {
                        SshConnection con = (SshConnection)evt.getAttribute("CONNECTION");
                        if (Log.isInfoEnabled()) {
                            Log.info((String)"Detaching callback connection {} from current proxied connection", (Object[])new Object[]{con.getUUID()});
                        }
                        console.getConnection().setProperty(InMemoryCallbackRegistrationService.PROXIED_CLIENT_CONNECTION, null);
                    }
                }
            });
            return true;
        }
        return false;
    }

    public Collection<String> matchDestinations(String destination) {
        ArrayList<String> results = new ArrayList<String>();
        for (String uuid : this.callbacks.keySet()) {
            if (!uuid.startsWith(destination)) continue;
            results.add(uuid);
        }
        return results;
    }

    @Override
    public Collection<? extends Callback> getCallbacks() {
        return new ArrayList<Callback>(this.callbacks.values());
    }

    @Override
    public Callback getCallbackByUUID(String uuid) {
        return this.callbacks.get(uuid);
    }

    @Override
    public void registerCallbackClient(SshConnection con) {
        this.callbacks.put(con.getUUID(), new DefaultCallback(con));
    }

    @Override
    public void unregisterCallbackClient(String uuid) {
        this.callbacks.remove(uuid);
    }

    @Override
    public boolean isRegistered(String uuid) {
        return this.callbacks.containsKey(uuid);
    }
}

