/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.callback;

import com.sshtools.client.AuthenticationProtocolClient;
import com.sshtools.client.ClientAuthenticator;
import com.sshtools.client.ClientStateListener;
import com.sshtools.client.SshClientContext;
import com.sshtools.common.auth.MutualKeyAuthenticatonStore;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.GlobalRequest;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.server.SshServerContext;
import com.sshtools.server.callback.MutualCallbackAuthenticator;
import com.sshtools.server.callback.SwitchingSshContext;
import com.sshtools.synergy.nio.ProtocolContextFactory;
import com.sshtools.synergy.nio.SshEngineContext;
import com.sshtools.synergy.ssh.ConnectionProtocol;
import com.sshtools.synergy.ssh.GlobalRequestHandler;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CallbackContextFactory
implements ProtocolContextFactory<SshClientContext> {
    public static final String CALLBACK_IDENTIFIER = "CallbackClient";
    public static final String CALLBACK_MEMO = "MEMO";
    String callbackIdentifier = "CallbackClient";
    Map<String, SshConnection> callbackClients = new HashMap<String, SshConnection>();
    MutualKeyAuthenticatonStore store;

    public CallbackContextFactory(MutualKeyAuthenticatonStore store) {
        this.store = store;
    }

    public Collection<SshConnection> getCallbackClients() {
        return Collections.unmodifiableCollection(this.callbackClients.values());
    }

    public SshConnection getCallbackClient(String username) {
        return this.callbackClients.get(username);
    }

    protected SshServerContext createServerContext(SshEngineContext daemonContext) throws IOException, SshException {
        return new SshServerContext(daemonContext.getEngine());
    }

    public SshClientContext createContext(SshEngineContext daemonContext, SocketChannel sc) throws IOException, SshException {
        SwitchingSshContext clientContext = new SwitchingSshContext(daemonContext.getEngine(), this.callbackIdentifier, new ProtocolContextFactory<SshServerContext>(){

            public SshServerContext createContext(SshEngineContext daemonContext, SocketChannel sc) throws IOException, SshException {
                SshServerContext serverContext = CallbackContextFactory.this.createServerContext(daemonContext);
                CallbackContextFactory.this.configureServerContext(serverContext);
                return serverContext;
            }
        });
        clientContext.addAuthenticator((ClientAuthenticator)new MutualCallbackAuthenticator(this.store));
        clientContext.addStateListener(new ClientStateListener(){

            public void authenticationStarted(AuthenticationProtocolClient authClient, SshConnection con) {
                if (CallbackContextFactory.this.callbackClients.containsKey(con.getUsername())) {
                    con.disconnect(String.format("Only one connection allowed by %s at anyone time", con.getUsername()));
                }
            }

            public void connected(SshConnection con) {
                Log.info((String)"Callback client {} connected", (Object[])new Object[]{con.getUsername()});
                CallbackContextFactory.this.callbackClients.put(con.getUsername(), con);
            }

            public void disconnected(SshConnection con) {
                SshConnection connected = CallbackContextFactory.this.callbackClients.get(con.getUsername());
                if (Objects.nonNull(connected) && connected.equals(con)) {
                    Log.info((String)"Callback client {} disconnected", (Object[])new Object[]{con.getUsername()});
                    CallbackContextFactory.this.callbackClients.remove(con.getUsername());
                }
            }
        });
        clientContext.addGlobalRequestHandler((GlobalRequestHandler)new GlobalRequestHandler<SshClientContext>(){

            public String[] supportedRequests() {
                return new String[]{"memo@jadaptive.com"};
            }

            public boolean processGlobalRequest(GlobalRequest request, ConnectionProtocol<SshClientContext> connection) {
                if ("memo@jadaptive.com".equals(request.getName())) {
                    try {
                        String memo = ByteArrayReader.decodeString((byte[])request.getData());
                        if (Log.isInfoEnabled()) {
                            Log.info((String)"Callback {} registered with memo {}", (Object[])new Object[]{connection.getUUID(), memo});
                        }
                        connection.getConnection().setProperty(CallbackContextFactory.CALLBACK_MEMO, (Object)memo);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return true;
                }
                return false;
            }
        });
        this.configureCallbackContext(clientContext);
        return clientContext;
    }

    protected void configureCallbackContext(SshClientContext clientContext) {
    }

    public void setCallbackIdentifier(String callbackIdentifier) {
        this.callbackIdentifier = callbackIdentifier;
    }

    public void setMutualAuthenticationStore(MutualKeyAuthenticatonStore store) {
        this.store = store;
    }

    protected void configureServerContext(SshServerContext serverContext) throws IOException, SshException {
    }
}

