/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.callback;

import com.sshtools.client.AuthenticationProtocolClient;
import com.sshtools.client.ClientAuthenticator;
import com.sshtools.client.ClientStateListener;
import com.sshtools.client.SshClientContext;
import com.sshtools.common.auth.InMemoryMutualKeyAuthenticationStore;
import com.sshtools.common.auth.MutualKeyAuthenticatonStore;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.server.AbstractSshServer;
import com.sshtools.server.SshServerContext;
import com.sshtools.server.callback.MutualCallbackAuthenticator;
import com.sshtools.server.callback.SwitchingSshContext;
import com.sshtools.synergy.nio.ProtocolContextFactory;
import com.sshtools.synergy.nio.SshEngineContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CallbackServer
extends AbstractSshServer {
    public static final String CALLBACK_IDENTIFIER = "CallbackClient-";
    String callbackIdentifier = "CallbackClient-";
    MutualKeyAuthenticatonStore authenticationStore = new InMemoryMutualKeyAuthenticationStore();
    ClientContextFactory defaultContextFactory = new ClientContextFactory();
    Map<String, SshConnection> callbackClients = new HashMap<String, SshConnection>();

    public CallbackServer() {
    }

    public CallbackServer(InetAddress addressToBind, int port) {
        super(addressToBind, port);
    }

    public CallbackServer(int port) throws UnknownHostException {
        super(port);
    }

    public CallbackServer(String addressToBind, int port) throws UnknownHostException {
        super(addressToBind, port);
    }

    public void setCallbackIdentifier(String callbackIdentifier) {
        this.callbackIdentifier = callbackIdentifier;
    }

    public void setMutualKeyAuthenticationStore(MutualKeyAuthenticatonStore authenticationStore) {
        this.authenticationStore = authenticationStore;
    }

    public Collection<SshConnection> getCallbackClients() {
        return Collections.unmodifiableCollection(this.callbackClients.values());
    }

    public SshConnection getCallbackClient(String username) {
        return this.callbackClients.get(username);
    }

    protected void configureClientContext(SshClientContext clientContext) {
    }

    protected ProtocolContextFactory<?> getDefaultContextFactory() {
        return this.defaultContextFactory;
    }

    class ServerContextFactory
    implements ProtocolContextFactory<SshServerContext> {
        ServerContextFactory() {
        }

        public SshServerContext createContext(SshEngineContext daemonContext, SocketChannel sc) throws IOException, SshException {
            SshServerContext serverContext = CallbackServer.this.createServerContext(daemonContext, sc);
            return serverContext;
        }
    }

    protected class ClientContextFactory
    implements ProtocolContextFactory<SshClientContext> {
        public SshClientContext createContext(SshEngineContext daemonContext, SocketChannel sc) throws IOException, SshException {
            SwitchingSshContext clientContext = new SwitchingSshContext(CallbackServer.this.getEngine(), CallbackServer.this.callbackIdentifier, new ServerContextFactory());
            CallbackServer.this.configureClientContext(clientContext);
            clientContext.addAuthenticator((ClientAuthenticator)new MutualCallbackAuthenticator(CallbackServer.this.authenticationStore));
            clientContext.addStateListener(new ClientStateListener(){

                public void authenticationStarted(AuthenticationProtocolClient authClient, SshConnection con) {
                    if (CallbackServer.this.callbackClients.containsKey(con.getUsername())) {
                        con.disconnect(String.format("Only one connection allowed by %s at anyone time", con.getUsername()));
                    }
                }

                public void connected(SshConnection con) {
                    Log.info((String)"Callback client {} connected", (Object[])new Object[]{con.getUsername()});
                    CallbackServer.this.callbackClients.put(con.getUsername(), con);
                }

                public void disconnected(SshConnection con) {
                    SshConnection connected = CallbackServer.this.callbackClients.get(con.getUsername());
                    if (Objects.nonNull(connected) && connected.equals(con)) {
                        Log.info((String)"Callback client {} disconnected", (Object[])new Object[]{con.getUsername()});
                        CallbackServer.this.callbackClients.remove(con.getUsername());
                    }
                }
            });
            return clientContext;
        }
    }
}

