/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.callback.client;

import com.sshtools.callback.client.CallbackAuthenticationMechanismFactory;
import com.sshtools.callback.client.CallbackConfiguration;
import com.sshtools.callback.client.CallbackSession;
import com.sshtools.callback.client.MutualCallbackAuthenticationProvider;
import com.sshtools.common.auth.InMemoryMutualKeyAuthenticationStore;
import com.sshtools.common.auth.MutualKeyAuthenticatonStore;
import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventListener;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.logger.Log;
import com.sshtools.common.policy.AuthenticationPolicy;
import com.sshtools.common.policy.FileFactory;
import com.sshtools.common.policy.FileSystemPolicy;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.server.DefaultServerChannelFactory;
import com.sshtools.server.SshServerContext;
import com.sshtools.synergy.nio.DisconnectRequestFuture;
import com.sshtools.synergy.nio.SshEngine;
import com.sshtools.synergy.nio.SshEngineContext;
import com.sshtools.synergy.ssh.ChannelFactory;
import com.sshtools.synergy.ssh.ChannelFactoryListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CallbackClient
implements ChannelFactoryListener<SshServerContext> {
    SshEngine ssh = new SshEngine();
    Set<CallbackSession> clients = new HashSet<CallbackSession>();
    ExecutorService executor;
    List<SshKeyPair> hostKeys = new ArrayList<SshKeyPair>();
    ChannelFactory<SshServerContext> channelFactory;
    List<Object> defaultPolicies = new ArrayList<Object>();
    FileFactory fileFactory;

    public CallbackClient() {
        this.executor = this.getExecutorService();
        EventServiceImplementation.getInstance().addListener((EventListener)new DisconnectionListener());
        this.channelFactory = new DefaultServerChannelFactory();
    }

    public SshEngine getSshEngine() {
        return this.ssh;
    }

    protected ExecutorService getExecutorService() {
        return Executors.newCachedThreadPool();
    }

    public void setDefaultPolicies(Object ... policies) {
        this.defaultPolicies.addAll(Arrays.asList(policies));
    }

    public void start(Collection<CallbackConfiguration> configs) {
        for (CallbackConfiguration config : configs) {
            try {
                this.start(config, config.getServerHost(), config.getServerPort());
            }
            catch (Throwable e) {
                Log.error((String)"Could not load configuration {}", (Throwable)e, (Object[])new Object[]{config.getAgentName()});
            }
        }
    }

    public synchronized void start(CallbackConfiguration config) throws IOException {
        this.start(config, config.getServerHost(), config.getServerPort());
    }

    public synchronized void start(CallbackConfiguration config, String hostname, int port) throws IOException {
        CallbackSession session = new CallbackSession(config, this, hostname, port);
        this.onClientStarting(session);
        this.start(session);
    }

    public synchronized void start(CallbackSession client) {
        if (Log.isInfoEnabled()) {
            Log.info((String)("Starting client " + client.getConfig().getAgentName()), (Object[])new Object[0]);
        }
        this.executor.execute(client);
    }

    void onClientConnected(CallbackSession client, SshConnection con) {
        this.clients.add(client);
        this.onClientStart(client, con);
    }

    public boolean isConnected() {
        return this.ssh.isStarted() && !this.clients.isEmpty();
    }

    public Collection<CallbackSession> getClients() {
        return this.clients;
    }

    protected void onClientStarting(CallbackSession client) {
    }

    protected void onClientStopping(CallbackSession client) {
    }

    protected void onClientStart(CallbackSession client, SshConnection connection) {
    }

    protected void onClientStop(CallbackSession client) {
    }

    public synchronized void stop(CallbackSession client) {
        this.onClientStopping(client);
        if (Log.isInfoEnabled()) {
            Log.info((String)"Stopping callback client", (Object[])new Object[0]);
        }
        DisconnectRequestFuture future = client.stop();
        if (Log.isInfoEnabled()) {
            Log.info((String)"Callback client has disconnected [{}]", (Object[])new Object[]{String.valueOf(future.isDone())});
        }
    }

    public void stop() {
        for (CallbackSession client : new ArrayList<CallbackSession>(this.clients)) {
            this.stop(client);
        }
        this.ssh.shutdownAndExit();
        this.executor.shutdownNow();
    }

    public SshServerContext createContext(SshEngineContext daemonContext, CallbackConfiguration config) throws IOException, SshException {
        SshServerContext sshContext = new SshServerContext(this.getSshEngine(), JCEComponentManager.getDefaultInstance());
        sshContext.setIdleConnectionTimeoutSeconds(0);
        for (SshKeyPair key : this.hostKeys) {
            sshContext.addHostKey(key);
        }
        for (Object policy : this.defaultPolicies) {
            sshContext.setPolicy(policy.getClass(), policy);
        }
        sshContext.setSoftwareVersionComments(String.format("%s_%s", config.getCallbackIdentifier(), config.getAgentName()));
        InMemoryMutualKeyAuthenticationStore authenticationStore = new InMemoryMutualKeyAuthenticationStore();
        authenticationStore.addKey(config.getAgentName(), config.getPrivateKey(), config.getPublicKey());
        MutualCallbackAuthenticationProvider provider = new MutualCallbackAuthenticationProvider((MutualKeyAuthenticatonStore)authenticationStore);
        sshContext.setAuthenicationMechanismFactory(new CallbackAuthenticationMechanismFactory(provider));
        ((AuthenticationPolicy)sshContext.getPolicy(AuthenticationPolicy.class)).addRequiredMechanism("mutual-key-auth@sshtools.com");
        sshContext.setSendIgnorePacketOnIdle(true);
        this.configureForwarding(sshContext, config);
        this.configureChannels(sshContext, config);
        this.configureFilesystem(sshContext, config);
        this.configureContext(sshContext, config);
        return sshContext;
    }

    protected void configureContext(SshServerContext sshContext, CallbackConfiguration config) {
    }

    protected void configureFilesystem(SshServerContext sshContext, CallbackConfiguration config) {
        ((FileSystemPolicy)sshContext.getPolicy(FileSystemPolicy.class)).setFileFactory(this.fileFactory);
    }

    protected void configureChannels(SshServerContext sshContext, CallbackConfiguration config) {
        sshContext.setChannelFactory(this.channelFactory);
    }

    protected void configureForwarding(SshServerContext sshContext, CallbackConfiguration config) {
        sshContext.getForwardingPolicy().allowForwarding();
    }

    public void addHostKey(SshKeyPair pair) {
        this.hostKeys.add(pair);
    }

    public void setChannelFactory(ChannelFactory<SshServerContext> channelFactory) {
        this.channelFactory = channelFactory;
    }

    public void setFileFactory(FileFactory fileFactory) {
        this.fileFactory = fileFactory;
    }

    class DisconnectionListener
    implements EventListener {
        DisconnectionListener() {
        }

        public void processEvent(Event evt) {
            switch (evt.getId()) {
                case -16776961: {
                    final SshConnection con = (SshConnection)evt.getAttribute("CONNECTION");
                    if (CallbackClient.this.executor.isShutdown()) break;
                    CallbackClient.this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (con.containsProperty("callbackClient")) {
                                CallbackSession client = (CallbackSession)con.getProperty("callbackClient");
                                CallbackClient.this.onClientStop(client);
                                con.removeProperty("callbackClient");
                                CallbackClient.this.clients.remove(client);
                                if (!client.isStopped() && client.getConfig().isReconnect()) {
                                    while (CallbackClient.this.getSshEngine().isStarted()) {
                                        try {
                                            try {
                                                Thread.sleep(client.getConfig().getReconnectIntervalMs());
                                            }
                                            catch (InterruptedException interruptedException) {
                                                // empty catch block
                                            }
                                            client.connect();
                                            break;
                                        }
                                        catch (IOException iOException) {
                                        }
                                    }
                                } else {
                                    CallbackClient.this.stop();
                                }
                            }
                        }
                    });
                    break;
                }
            }
        }
    }
}

