/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.callback.client;

import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import java.util.HashMap;
import java.util.Map;

public class CallbackConfiguration {
    String agentName;
    String serverHost;
    int serverPort = 22;
    String remoteUUID;
    String localUUID;
    Long reconnectIntervalMs;
    SshKeyPair privateKey;
    SshPublicKey publicKey;
    Map<String, Object> properties = new HashMap<String, Object>();

    public CallbackConfiguration(String agentName, String serverHost, int serverPort, Long reconnectIntervalMs, SshKeyPair privateKey, SshPublicKey publicKey) {
        this.agentName = agentName;
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    protected CallbackConfiguration() {
    }

    public CallbackConfiguration setProperty(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public Long getReconnectIntervalMs() {
        return this.reconnectIntervalMs == null ? 5000L : this.reconnectIntervalMs;
    }

    public void setReconnectIntervalMs(Long reconnectIntervalMs) {
        this.reconnectIntervalMs = reconnectIntervalMs;
    }

    public SshKeyPair getPrivateKey() {
        return this.privateKey;
    }

    public SshPublicKey getPublicKey() {
        return this.publicKey;
    }
}

