/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.openssh;

import com.sshtools.agent.AgentMessage;
import com.sshtools.agent.exceptions.InvalidMessageException;
import com.sshtools.common.publickey.SshPublicKeyFileFactory;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;

public class SshAgentDeleteKey
extends AgentMessage {
    SshPublicKey pubkey;
    String description;

    public SshAgentDeleteKey() {
        super(18);
    }

    public SshAgentDeleteKey(SshPublicKey pubkey, String description) {
        super(18);
        this.pubkey = pubkey;
        this.description = description;
    }

    public SshPublicKey getPublicKey() {
        return this.pubkey;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getMessageName() {
        return "SSH_AGENTC_REMOVE_IDENTITY";
    }

    @Override
    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        try {
            baw.writeBinaryString(this.pubkey.getEncoded());
            baw.writeString(this.description);
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage(), 13);
        }
        catch (SshException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        try {
            this.pubkey = SshPublicKeyFileFactory.decodeSSH2PublicKey((byte[])bar.readBinaryString());
            this.description = bar.readString();
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage(), 13);
        }
    }
}

