/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.openssh;

import com.sshtools.agent.AgentMessage;
import com.sshtools.agent.KeyStore;
import com.sshtools.agent.exceptions.InvalidMessageException;
import com.sshtools.agent.exceptions.KeyTimeoutException;
import com.sshtools.agent.openssh.SshAgentAddKey;
import com.sshtools.agent.openssh.SshAgentDeleteKey;
import com.sshtools.agent.openssh.SshAgentFailure;
import com.sshtools.agent.openssh.SshAgentKeyList;
import com.sshtools.agent.openssh.SshAgentLock;
import com.sshtools.agent.openssh.SshAgentOperationComplete;
import com.sshtools.agent.openssh.SshAgentPrivateKeyOp;
import com.sshtools.agent.openssh.SshAgentUnlock;
import com.sshtools.agent.server.SshAgentConnection;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class OpenSSHAgentConnection
implements Runnable,
SshAgentConnection {
    private static final int SSH_AGENT_RSA_SHA2_256 = 2;
    private static final int SSH_AGENT_RSA_SHA2_512 = 4;
    InputStream in;
    OutputStream out;
    KeyStore keystore;
    Closeable closeable;
    boolean isRFCAgent = true;

    public OpenSSHAgentConnection(KeyStore keystore, InputStream in, OutputStream out, Closeable closeable) {
        this.keystore = keystore;
        this.in = in;
        this.out = out;
        this.closeable = closeable;
    }

    protected void sendAgentSuccess() throws IOException {
        AgentMessage msg = new AgentMessage(6);
        this.sendMessage(msg);
    }

    protected void sendAgentFailure() throws IOException {
        SshAgentFailure msg = new SshAgentFailure();
        this.sendMessage(msg);
    }

    protected void sendAgentKeyList() throws IOException {
        SshAgentKeyList msg = null;
        msg = new SshAgentKeyList(this.keystore.getPublicKeys());
        this.sendMessage(msg);
    }

    protected void sendOperationComplete(byte[] data) throws IOException {
        SshAgentOperationComplete msg = new SshAgentOperationComplete(data);
        this.sendMessage(msg);
    }

    protected void sendMessage(AgentMessage msg) throws IOException {
        Log.info((String)("Sending message " + msg.getMessageName()), (Object[])new Object[0]);
        try {
            byte[] msgdata = msg.toByteArray();
            this.out.write(ByteArrayWriter.encodeInt((int)msgdata.length));
            this.out.write(msgdata);
            this.out.flush();
        }
        catch (InvalidMessageException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected void onAddKey(SshAgentAddKey msg) throws IOException {
        if (!this.keystore.isLocked()) {
            if (this.keystore.addKey(msg.getPrivateKey(), msg.getPublicKey(), msg.getDescription(), msg.getKeyConstraints())) {
                this.sendAgentSuccess();
            } else {
                this.sendAgentFailure();
            }
        } else {
            this.sendAgentFailure();
        }
    }

    protected void onDeleteAllKeys(AgentMessage msg) throws IOException {
        if (!this.keystore.isLocked() && this.keystore.deleteAllKeys()) {
            this.sendAgentSuccess();
        }
        this.sendAgentFailure();
    }

    protected void onListKeys(AgentMessage msg) throws IOException {
        if (!this.keystore.isLocked()) {
            this.sendAgentKeyList();
        } else {
            this.sendAgentFailure();
        }
    }

    protected void onPrivateKeyOp(SshAgentPrivateKeyOp msg) throws IOException {
        try {
            SshPublicKey key = msg.getPublicKey();
            byte[] sig = this.keystore.performHashAndSign(key, null, msg.getOperationData(), msg.getFlags().intValue());
            this.sendOperationComplete(this.encodeSignature(key, msg.getFlags().intValue(), sig));
        }
        catch (KeyTimeoutException ex) {
            this.sendAgentFailure();
        }
        catch (InvalidMessageException ex) {
            this.sendAgentFailure();
        }
        catch (SshException e) {
            this.sendAgentFailure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] encodeSignature(SshPublicKey key, int flags, byte[] signature) throws IOException {
        try (ByteArrayWriter sig = new ByteArrayWriter();){
            switch (flags) {
                case 2: {
                    sig.writeString("rsa-sha2-256");
                    break;
                }
                case 4: {
                    sig.writeString("rsa-sha2-512");
                    break;
                }
                default: {
                    sig.writeString(key.getSigningAlgorithm());
                }
            }
            sig.writeBinaryString(signature);
            byte[] byArray = sig.toByteArray();
            return byArray;
        }
    }

    protected void onDeleteKey(SshAgentDeleteKey msg) throws IOException {
        if (this.keystore.deleteKey(msg.getPublicKey())) {
            this.sendAgentSuccess();
        } else {
            this.sendAgentFailure();
        }
    }

    protected void onLock(SshAgentLock msg) throws IOException {
        if (this.keystore.lock(msg.getPassword())) {
            this.sendAgentSuccess();
        } else {
            this.sendAgentFailure();
        }
    }

    protected void onUnlock(SshAgentUnlock msg) throws IOException {
        if (this.keystore.unlock(msg.getPassword())) {
            this.sendAgentSuccess();
        } else {
            this.sendAgentFailure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Log.info((String)"Starting agent connection thread", (Object[])new Object[0]);
            byte[] lendata = new byte[4];
            boolean alive = true;
            while (alive) {
                int len = 0;
                while (len < lendata.length) {
                    try {
                        int read = 0;
                        read = this.in.read(lendata, len, lendata.length - len);
                        if (read >= 0) {
                            len += read;
                            continue;
                        }
                        alive = false;
                        break;
                    }
                    catch (InterruptedIOException ex) {
                        if (ex.bytesTransferred <= 0) continue;
                        len += ex.bytesTransferred;
                    }
                }
                if (!alive) continue;
                len = (int)ByteArrayReader.readInt((byte[])lendata, (int)0);
                byte[] msgdata = new byte[len];
                len = 0;
                while (len < msgdata.length) {
                    try {
                        len += this.in.read(msgdata, len, msgdata.length - len);
                    }
                    catch (InterruptedIOException ex1) {
                        len += ex1.bytesTransferred;
                    }
                }
                this.onMessageReceived(msgdata);
            }
        }
        catch (IOException ex) {
            Log.info((String)"The agent connection terminated", (Throwable)ex, (Object[])new Object[0]);
        }
        finally {
            try {
                if (this.closeable != null) {
                    this.closeable.close();
                }
            }
            catch (Exception exception) {}
        }
        Log.info((String)"Exiting agent connection thread", (Object[])new Object[0]);
    }

    protected void onMessageReceived(byte[] msgdata) throws IOException {
        try {
            switch (msgdata[0] & 0xFF) {
                case 17: {
                    Log.info((String)"Adding key to agent", (Object[])new Object[0]);
                    SshAgentAddKey msg = new SshAgentAddKey();
                    msg.fromByteArray(msgdata);
                    this.onAddKey(msg);
                    break;
                }
                case 25: {
                    break;
                }
                case 11: {
                    Log.info((String)"Listing agent keys", (Object[])new Object[0]);
                    AgentMessage msg = new AgentMessage(11);
                    msg.fromByteArray(msgdata);
                    this.onListKeys(msg);
                    break;
                }
                case 18: {
                    Log.info((String)"Deleting key from agent", (Object[])new Object[0]);
                    SshAgentDeleteKey msg = new SshAgentDeleteKey();
                    msg.fromByteArray(msgdata);
                    this.onDeleteKey(msg);
                    break;
                }
                case 19: {
                    Log.info((String)"Deleting all keys from agent", (Object[])new Object[0]);
                    AgentMessage msg = new AgentMessage(19);
                    msg.fromByteArray(msgdata);
                    this.onDeleteAllKeys(msg);
                    break;
                }
                case 13: {
                    Log.info((String)"Performing agent private key operation", (Object[])new Object[0]);
                    SshAgentPrivateKeyOp msg = new SshAgentPrivateKeyOp();
                    msg.fromByteArray(msgdata);
                    this.onPrivateKeyOp(msg);
                    break;
                }
                case 22: {
                    Log.info((String)"Locking agent", (Object[])new Object[0]);
                    SshAgentLock msg = new SshAgentLock(this.isRFCAgent);
                    msg.fromByteArray(msgdata);
                    this.onLock(msg);
                    break;
                }
                case 23: {
                    Log.info((String)"Unlocking agent", (Object[])new Object[0]);
                    SshAgentUnlock msg = new SshAgentUnlock(this.isRFCAgent);
                    msg.fromByteArray(msgdata);
                    this.onUnlock(msg);
                    break;
                }
                default: {
                    Log.info((String)("Unrecognized message type " + String.valueOf(msgdata[0]) + " received"), (Object[])new Object[0]);
                    this.sendAgentFailure();
                    break;
                }
            }
        }
        catch (InvalidMessageException e) {
            e.printStackTrace();
        }
    }
}

