/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.rfc;

import com.sshtools.agent.AgentMessage;
import com.sshtools.agent.exceptions.InvalidMessageException;
import com.sshtools.common.publickey.SshPublicKeyFileFactory;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SshAgentKeyList
extends AgentMessage {
    private Map<SshPublicKey, String> keys;

    public SshAgentKeyList(Map<SshPublicKey, String> keys) {
        super(104);
        this.keys = keys;
    }

    public SshAgentKeyList() {
        super(104);
        this.keys = new HashMap<SshPublicKey, String>();
    }

    public Map<SshPublicKey, String> getKeys() {
        return this.keys;
    }

    @Override
    public String getMessageName() {
        return "SSH_AGENT_KEY_LIST";
    }

    @Override
    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        try {
            baw.writeInt(this.keys.size());
            for (Map.Entry<SshPublicKey, String> entry : this.keys.entrySet()) {
                SshPublicKey key = entry.getKey();
                String description = entry.getValue();
                try {
                    baw.writeBinaryString(key.getEncoded());
                }
                catch (SshException e) {
                    throw new SshIOException(e);
                }
                baw.writeString(description);
            }
        }
        catch (IOException ex) {
            throw new InvalidMessageException("Failed to write message data", 13);
        }
    }

    @Override
    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        try {
            int num = (int)bar.readInt();
            for (int i = 0; i < num; ++i) {
                byte[] buf = bar.readBinaryString();
                SshPublicKey key = SshPublicKeyFileFactory.decodeSSH2PublicKey((byte[])buf);
                String description = bar.readString();
                this.keys.put(key, description);
            }
        }
        catch (IOException ex) {
            throw new InvalidMessageException("Failed to read message data", 13);
        }
    }
}

