/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.provider.namedpipes;

import com.sshtools.common.logger.Log;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractNamedPipe
implements Closeable {
    protected final int MAX_BUFFER_SIZE = 1024;
    protected String pipeName;
    public static final String NAMED_PIPE_PREFIX = "\\\\.\\pipe\\";

    AbstractNamedPipe(String pipeName) {
        this.pipeName = pipeName;
        if (!((String)pipeName).startsWith(NAMED_PIPE_PREFIX)) {
            pipeName = NAMED_PIPE_PREFIX + (String)pipeName;
        }
        this.pipeName = pipeName;
        if (Log.isInfoEnabled()) {
            Log.info((String)"Creating pipe {}", (Object[])new Object[]{this.pipeName});
        }
    }

    public String getPath() {
        return this.pipeName;
    }

    public static final void assertCallSucceeded(String message, boolean result) throws IOException {
        if (result) {
            return;
        }
        int hr = Kernel32.INSTANCE.GetLastError();
        if (hr == 234) {
            return;
        }
        if (hr == 0) {
            throw new IOException(message + " failed with unknown reason code");
        }
        throw new IOException(message + " failed: hr=" + hr + " - 0x" + Integer.toHexString(hr));
    }

    public static final WinNT.HANDLE assertValidHandle(String message, WinNT.HANDLE handle) throws IOException {
        if (handle == null || WinBase.INVALID_HANDLE_VALUE.equals((Object)handle)) {
            int hr = Kernel32.INSTANCE.GetLastError();
            if (hr == 0) {
                throw new IOException(message + " failed with unknown reason code");
            }
            throw new IOException(message + " failed: hr=" + hr + " - 0x" + Integer.toHexString(hr));
        }
        return handle;
    }

    protected void assertEquals(String message, int len, int value) throws IOException {
        if (len != value) {
            throw new IOException(message);
        }
    }

    public AbstractNamedPipe() {
    }

    class NamedPipeOutputStream
    extends OutputStream {
        NamedPipeSession session;

        NamedPipeOutputStream(NamedPipeSession session) {
            this.session = session;
        }

        @Override
        public void write(int b) throws IOException {
            byte[] buf = new byte[]{(byte)b};
            this.write(buf);
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            if (Log.isInfoEnabled()) {
                Log.info((String)"Writing {} bytes to pipe {} handle={}", (Object[])new Object[]{len, AbstractNamedPipe.this.pipeName, this.session.hNamedPipe.toString()});
            }
            byte[] tmp = new byte[len];
            System.arraycopy(buf, off, tmp, 0, len);
            IntByReference lpNumberOfBytesWritten = new IntByReference(0);
            AbstractNamedPipe.assertCallSucceeded("WriteFile", Kernel32.INSTANCE.WriteFile(this.session.hNamedPipe, tmp, len, lpNumberOfBytesWritten, null));
            AbstractNamedPipe.this.assertEquals("Mismatched write buffer size", len, lpNumberOfBytesWritten.getValue());
            if (Log.isInfoEnabled()) {
                Log.info((String)"Written {} bytes to pipe {} handle={}", (Object[])new Object[]{lpNumberOfBytesWritten.getValue(), AbstractNamedPipe.this.pipeName, this.session.hNamedPipe.toString()});
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
            this.session.close();
        }
    }

    class NamedPipeInputStream
    extends InputStream {
        NamedPipeSession session;

        NamedPipeInputStream(NamedPipeSession session) {
            this.session = session;
        }

        @Override
        public int read() throws IOException {
            byte[] tmp = new byte[1];
            int r = this.read(tmp);
            if (r == 1) {
                return tmp[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            try {
                byte[] tmp = new byte[len];
                if (Log.isInfoEnabled()) {
                    Log.info((String)"Reading {} maximum bytes from pipe {} handle={}", (Object[])new Object[]{len, AbstractNamedPipe.this.pipeName, this.session.hNamedPipe.toString()});
                }
                IntByReference lpNumberOfBytesRead = new IntByReference(0);
                AbstractNamedPipe.assertCallSucceeded("ReadFile", Kernel32.INSTANCE.ReadFile(this.session.hNamedPipe, tmp, tmp.length, lpNumberOfBytesRead, null));
                int readSize = lpNumberOfBytesRead.getValue();
                if (readSize > 0) {
                    System.arraycopy(tmp, 0, buf, off, readSize);
                }
                if (Log.isInfoEnabled()) {
                    Log.info((String)"Read {} bytes from pipe {} handle={}", (Object[])new Object[]{readSize, AbstractNamedPipe.this.pipeName, this.session.hNamedPipe.toString()});
                }
                return readSize;
            }
            catch (Throwable t) {
                if (Log.isErrorEnabled()) {
                    Log.error((String)"Error reading bytes from pipe {} handle={}", (Throwable)t, (Object[])new Object[]{AbstractNamedPipe.this.pipeName, this.session.hNamedPipe.toString()});
                }
                this.close();
                return -1;
            }
        }

        @Override
        public void close() throws IOException {
            this.session.close();
        }
    }

    public class NamedPipeSession {
        WinNT.HANDLE hNamedPipe;
        InputStream in;
        OutputStream out;

        NamedPipeSession(WinNT.HANDLE hNamedPipe) {
            this.hNamedPipe = hNamedPipe;
            this.in = new NamedPipeInputStream(this);
            this.out = new NamedPipeOutputStream(this);
        }

        public InputStream getInputStream() {
            return this.in;
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        public void close() throws IOException {
            if (Log.isInfoEnabled()) {
                Log.info((String)"Closing pipe {} handle={}", (Object[])new Object[]{AbstractNamedPipe.this.pipeName, this.hNamedPipe.toString()});
            }
            AbstractNamedPipe.assertCallSucceeded("DisconnectNamedPipe", Kernel32.INSTANCE.DisconnectNamedPipe(this.hNamedPipe));
            AbstractNamedPipe.assertCallSucceeded("Named pipe handle close", Kernel32.INSTANCE.CloseHandle(this.hNamedPipe));
        }
    }
}

