/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp;

import com.sshtools.common.util.UnsignedInteger32;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public final class PosixPermissions {
    public static final PosixPermissions EMPTY = PosixPermissionsBuilder.create().build();
    private final Set<PosixFilePermission> perms;
    private final int mode;

    public static int toMask(PosixFilePermission permission) {
        switch (permission) {
            case OWNER_WRITE: {
                return 128;
            }
            case OWNER_EXECUTE: {
                return 64;
            }
            case GROUP_READ: {
                return 32;
            }
            case GROUP_WRITE: {
                return 16;
            }
            case GROUP_EXECUTE: {
                return 8;
            }
            case OTHERS_READ: {
                return 4;
            }
            case OTHERS_WRITE: {
                return 2;
            }
            case OTHERS_EXECUTE: {
                return 1;
            }
        }
        return 256;
    }

    private static int octal(int v, int r) {
        return (((v >>>= r) & 4) != 0 ? 4 : 0) + ((v & 2) != 0 ? 2 : 0) + ((v & 1) != 0 ? 1 : 0);
    }

    private PosixPermissions(PosixPermissionsBuilder builder) {
        this.perms = Collections.unmodifiableSet(builder.perms);
        int m = 0;
        for (PosixFilePermission perm : this.perms) {
            m |= PosixPermissions.toMask(perm);
        }
        this.mode = m;
    }

    public String asFileModesString() {
        return PosixFilePermissions.toString(this.perms);
    }

    public int asInt() {
        return this.mode;
    }

    public long asLong() {
        return Integer.toUnsignedLong(this.mode);
    }

    public String asMaskString() {
        int mode = this.asInt();
        StringBuilder buf = new StringBuilder();
        buf.append('0');
        buf.append(PosixPermissions.octal(mode, 6));
        buf.append(PosixPermissions.octal(mode, 3));
        buf.append(PosixPermissions.octal(mode, 0));
        return buf.toString();
    }

    public Set<PosixFilePermission> asPermissions() {
        return this.perms;
    }

    public UnsignedInteger32 asUInt32() {
        return new UnsignedInteger32(this.asLong());
    }

    public boolean has(PosixFilePermission ... permissions) {
        if (permissions.length == 0) {
            throw new IllegalArgumentException("Must provide at least one permission.");
        }
        for (PosixFilePermission perm : permissions) {
            if (this.perms.contains((Object)perm)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.perms.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.mode);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PosixPermissions other = (PosixPermissions)obj;
        return this.mode == other.mode;
    }

    public String toString() {
        return "PosixPermissions [asFileModesString()=" + this.asFileModesString() + ", asMaskString()=" + this.asMaskString() + "]";
    }

    public static final class PosixPermissionsBuilder {
        private Set<PosixFilePermission> perms = new LinkedHashSet<PosixFilePermission>();

        public static PosixPermissionsBuilder create() {
            return new PosixPermissionsBuilder();
        }

        private PosixPermissionsBuilder() {
        }

        public PosixPermissions build() {
            return new PosixPermissions(this);
        }

        public PosixPermissionsBuilder fromAllPermissions() {
            return this.fromPermissions(PosixFilePermission.values());
        }

        public PosixPermissionsBuilder fromBitmask(long mode) {
            this.perms.clear();
            for (PosixFilePermission perm : PosixFilePermission.values()) {
                if ((mode & (long)PosixPermissions.toMask(perm)) == 0L) continue;
                this.perms.add(perm);
            }
            return this;
        }

        public PosixPermissionsBuilder fromBitmask(UnsignedInteger32 mode) {
            return this.fromBitmask(mode.longValue());
        }

        public PosixPermissionsBuilder fromFileModeString(String fileModes) {
            this.perms.clear();
            this.perms.addAll(PosixFilePermissions.fromString(fileModes));
            return this;
        }

        public PosixPermissionsBuilder fromLaxFileModeString(String fileModes) {
            while (((String)fileModes).length() < 9) {
                fileModes = (String)fileModes + "-";
            }
            return this.fromFileModeString((String)fileModes);
        }

        public PosixPermissionsBuilder fromMaskString(String maskString) {
            if (maskString.length() != 4) {
                throw new IllegalArgumentException("Mask length must be 4");
            }
            try {
                return this.fromBitmask(new UnsignedInteger32(String.valueOf(Integer.parseInt(maskString, 8))));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Mask must be 4 digit octal number.");
            }
        }

        public PosixPermissionsBuilder fromNoPermissions() {
            this.perms.clear();
            return this;
        }

        public PosixPermissionsBuilder fromPermissions(PosixFilePermission ... permissions) {
            return this.fromPermissions(Arrays.asList(permissions));
        }

        public PosixPermissionsBuilder fromPermissions(Collection<PosixFilePermission> permissions) {
            this.perms.clear();
            this.perms.addAll(permissions);
            return this;
        }

        public PosixPermissionsBuilder fromPosixPermissions(PosixPermissions permissions) {
            this.perms.clear();
            this.perms.addAll(permissions.perms);
            return this;
        }

        public PosixPermissionsBuilder fromUmaskString(String umask) {
            if (umask.length() != 4) {
                throw new IllegalArgumentException("Mask length must be 4");
            }
            try {
                return this.fromBitmask(new UnsignedInteger32(String.valueOf(Integer.parseInt(umask, 8) ^ 0x1FF)));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Mask must be 4 digit octal number.");
            }
        }

        public PosixPermissionsBuilder withAllExecute() {
            return this.withPermissions(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE);
        }

        public PosixPermissionsBuilder withAllRead() {
            return this.withPermissions(PosixFilePermission.OWNER_READ, PosixFilePermission.GROUP_READ, PosixFilePermission.OTHERS_READ);
        }

        public PosixPermissionsBuilder withAllWrite() {
            return this.withPermissions(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE);
        }

        public PosixPermissionsBuilder withBitmaskFlags(long flags) {
            for (PosixFilePermission perm : PosixFilePermission.values()) {
                if ((flags & (long)PosixPermissions.toMask(perm)) == 0L) continue;
                this.perms.add(perm);
            }
            return this;
        }

        public PosixPermissionsBuilder withChmodArgumentString(String chmodArgument) {
            if (chmodArgument.matches("\\d+")) {
                return this.fromMaskString(chmodArgument);
            }
            for (String el : chmodArgument.split(",")) {
                if (el.startsWith("u=") || el.startsWith("u+") || el.startsWith("u-")) {
                    if (el.startsWith("u=")) {
                        this.perms.removeAll(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));
                    }
                    block16: for (char ch : el.substring(2).toCharArray()) {
                        switch (ch) {
                            case 'r': {
                                if (el.startsWith("u-")) {
                                    this.perms.remove((Object)PosixFilePermission.OWNER_READ);
                                    continue block16;
                                }
                                this.perms.add(PosixFilePermission.OWNER_READ);
                                continue block16;
                            }
                            case 'w': {
                                if (el.startsWith("u-")) {
                                    this.perms.remove((Object)PosixFilePermission.OWNER_WRITE);
                                    continue block16;
                                }
                                this.perms.add(PosixFilePermission.OWNER_WRITE);
                                continue block16;
                            }
                            case 'x': {
                                if (el.startsWith("u-")) {
                                    this.perms.remove((Object)PosixFilePermission.OWNER_EXECUTE);
                                    continue block16;
                                }
                                this.perms.add(PosixFilePermission.OWNER_EXECUTE);
                                continue block16;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown user mode '" + ch + "'");
                            }
                        }
                    }
                    continue;
                }
                if (el.startsWith("g=") || el.startsWith("g+") || el.startsWith("g-")) {
                    if (el.startsWith("g=")) {
                        this.perms.removeAll(Arrays.asList(PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE));
                    }
                    block17: for (char ch : el.substring(2).toCharArray()) {
                        switch (ch) {
                            case 'r': {
                                if (el.startsWith("g-")) {
                                    this.perms.remove((Object)PosixFilePermission.GROUP_READ);
                                    continue block17;
                                }
                                this.perms.add(PosixFilePermission.GROUP_READ);
                                continue block17;
                            }
                            case 'w': {
                                if (el.startsWith("g-")) {
                                    this.perms.remove((Object)PosixFilePermission.GROUP_WRITE);
                                    continue block17;
                                }
                                this.perms.add(PosixFilePermission.GROUP_WRITE);
                                continue block17;
                            }
                            case 'x': {
                                if (el.startsWith("g-")) {
                                    this.perms.remove((Object)PosixFilePermission.GROUP_EXECUTE);
                                    continue block17;
                                }
                                this.perms.add(PosixFilePermission.GROUP_EXECUTE);
                                continue block17;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown group mode '" + ch + "'");
                            }
                        }
                    }
                    continue;
                }
                if (el.startsWith("o=") || el.startsWith("o+") || el.startsWith("o-")) {
                    if (el.startsWith("o=")) {
                        this.perms.removeAll(Arrays.asList(PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE));
                    }
                    block18: for (char ch : el.substring(2).toCharArray()) {
                        switch (ch) {
                            case 'r': {
                                if (el.startsWith("o-")) {
                                    this.perms.remove((Object)PosixFilePermission.OTHERS_READ);
                                    continue block18;
                                }
                                this.perms.add(PosixFilePermission.OTHERS_READ);
                                continue block18;
                            }
                            case 'w': {
                                if (el.startsWith("o-")) {
                                    this.perms.remove((Object)PosixFilePermission.OTHERS_WRITE);
                                    continue block18;
                                }
                                this.perms.add(PosixFilePermission.OTHERS_WRITE);
                                continue block18;
                            }
                            case 'x': {
                                if (el.startsWith("o-")) {
                                    this.perms.remove((Object)PosixFilePermission.OTHERS_EXECUTE);
                                    continue block18;
                                }
                                this.perms.add(PosixFilePermission.OTHERS_EXECUTE);
                                continue block18;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown others mode '" + ch + "'");
                            }
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException("Unknown scope '" + el + "'");
            }
            return this;
        }

        public PosixPermissionsBuilder withoutBitmaskFlags(long flags) {
            for (PosixFilePermission perm : PosixFilePermission.values()) {
                if ((flags & (long)PosixPermissions.toMask(perm)) == 0L) continue;
                this.perms.remove((Object)perm);
            }
            return this;
        }

        public PosixPermissionsBuilder withoutExecutePermissions() {
            this.perms.removeAll(Arrays.asList(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE));
            return this;
        }

        public PosixPermissionsBuilder withoutGroupOtherPermissions() {
            this.perms.removeAll(Arrays.asList(PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE));
            return this;
        }

        public PosixPermissionsBuilder withoutOtherPermissions() {
            this.perms.removeAll(Arrays.asList(PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE));
            return this;
        }

        public PosixPermissionsBuilder withoutPermissions(Collection<PosixFilePermission> permissions) {
            return this.withoutPermissions(permissions.toArray(new PosixFilePermission[0]));
        }

        public PosixPermissionsBuilder withoutPermissions(PosixFilePermission ... permissions) {
            this.perms.removeAll(Arrays.asList(permissions));
            return this;
        }

        public PosixPermissionsBuilder withoutWritePermissions() {
            this.perms.removeAll(Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE));
            return this;
        }

        public PosixPermissionsBuilder withPermissions(Collection<PosixFilePermission> permissions) {
            return this.withPermissions(permissions.toArray(new PosixFilePermission[0]));
        }

        public PosixPermissionsBuilder withPermissions(PosixFilePermission ... permissions) {
            this.perms.addAll(Arrays.asList(permissions));
            return this;
        }
    }
}

