/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.direct;

import com.sshtools.common.files.direct.FileOwnership;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.attribute.UserPrincipalNotFoundException;

final class FileOwnershipUtil {
    private FileOwnershipUtil() {
    }

    public static FileOwnership lookupOwnership(String ownerUsername, String groupName) throws IOException {
        UserPrincipal owner;
        UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
        String os = System.getProperty("os.name").toLowerCase();
        try {
            owner = lookupService.lookupPrincipalByName(ownerUsername);
        }
        catch (UserPrincipalNotFoundException e) {
            System.err.println("User '" + ownerUsername + "' not found.");
            throw e;
        }
        GroupPrincipal group = null;
        if (os.contains("nix") || os.contains("nux") || os.contains("mac")) {
            try {
                group = lookupService.lookupPrincipalByGroupName(groupName);
            }
            catch (UserPrincipalNotFoundException e) {
                System.err.println("Group '" + groupName + "' not found on POSIX system.");
                throw e;
            }
        }
        return new FileOwnership(owner, group);
    }
}

