/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.compression;

import com.sshtools.common.ssh.compression.SshCompression;
import com.sshtools.common.ssh.compression.SshCompressionFactory;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class NoneCompression
implements SshCompression {
    private static final String NONE = "none";

    @Override
    public void init(int type, int level) {
    }

    @Override
    public byte[] compress(byte[] data, int start, int len) throws IOException {
        return this.uncompress(data, start, len);
    }

    @Override
    public byte[] uncompress(byte[] data, int start, int len) throws IOException {
        if (len != data.length || start != 0) {
            byte[] arr = new byte[len];
            System.arraycopy(data, start, arr, 0, len);
            return arr;
        }
        return data;
    }

    @Override
    public String getAlgorithm() {
        return NONE;
    }

    public static class NoneCompressionFactory
    implements SshCompressionFactory<NoneCompression> {
        @Override
        public NoneCompression create() throws NoSuchAlgorithmException, IOException {
            return new NoneCompression();
        }

        @Override
        public String[] getKeys() {
            return new String[]{NoneCompression.NONE};
        }
    }
}

