/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components.jce;

import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshHmacFactory;
import com.sshtools.common.ssh.components.jce.AbstractHmac;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HmacSha512
extends AbstractHmac {
    public HmacSha512() {
        super("HmacSha512", 64, SecurityLevel.PARANOID, 3000);
    }

    protected HmacSha512(int size) {
        super("HmacSha512", 64, size, SecurityLevel.PARANOID, 3000);
    }

    @Override
    public String getAlgorithm() {
        return "hmac-sha2-512";
    }

    @Override
    public void init(byte[] keydata) throws SshException {
        try {
            this.mac = JCEProvider.getProviderForAlgorithm(this.jceAlgorithm) == null ? Mac.getInstance(this.jceAlgorithm) : Mac.getInstance(this.jceAlgorithm, JCEProvider.getProviderForAlgorithm(this.jceAlgorithm));
            byte[] key = new byte[64];
            System.arraycopy(keydata, 0, key, 0, key.length);
            SecretKeySpec keyspec = new SecretKeySpec(key, this.jceAlgorithm);
            this.mac.init(keyspec);
        }
        catch (Throwable t) {
            throw new SshException(t);
        }
    }

    public static class HmacSha512Factory
    implements SshHmacFactory<HmacSha512> {
        @Override
        public HmacSha512 create() throws NoSuchAlgorithmException, IOException {
            return new HmacSha512();
        }

        @Override
        public String[] getKeys() {
            return new String[]{"hmac-sha2-512"};
        }
    }
}

