/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.policy;

import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.permissions.Permissions;
import com.sshtools.common.policy.FileFactory;
import com.sshtools.common.sftp.SftpExtension;
import com.sshtools.common.sftp.SftpExtensionFactory;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.IOUtils;
import com.sshtools.common.util.UnsignedInteger32;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class FileSystemPolicy
extends Permissions {
    long connectionUploadQuota = -1L;
    FileFactory fileFactory;
    String sftpCharsetEncoding = "UTF-8";
    boolean allowZeroLengthFileUpload = true;
    boolean sftpVersion4Enabled = true;
    int sftpVersion = 4;
    boolean sftpReadWriteEvents = false;
    boolean scpReadWriteEvents = false;
    int maxConcurrentTransfers = 50;
    int maximumSftpRequests = 10;
    String sftpLongnameDateFormat = "MMM dd  yyyy";
    String sftpLongnameDateFormatWithTime = "MMM dd HH:mm";
    List<SftpExtensionFactory> sftpExtensionFactories = new ArrayList<SftpExtensionFactory>();
    Set<String> disabledExtensions = new HashSet<String>();
    boolean closeFileBeforeFailedTransferEvents = false;
    boolean mkdirParentMustExist = true;
    private int sftpMaxPacketSize = 65536;
    private UnsignedInteger32 sftpMaxWindowSize = new UnsignedInteger32(IOUtils.fromByteSize((String)"16MB").longValue());
    private UnsignedInteger32 sftpMinWindowSize = new UnsignedInteger32(131072L);

    public long getConnectionUploadQuota() {
        return this.connectionUploadQuota;
    }

    public void setConnectionUploadQuota(long connectionUploadQuota) {
        this.connectionUploadQuota = connectionUploadQuota;
    }

    public boolean hasUploadQuota() {
        return this.connectionUploadQuota > -1L;
    }

    public String getSFTPCharsetEncoding() {
        return this.sftpCharsetEncoding;
    }

    public void setSFTPCharsetEncoding(String sftpCharsetEncoding) {
        this.sftpCharsetEncoding = sftpCharsetEncoding;
    }

    public void setFileFactory(FileFactory fileFactory) {
        this.fileFactory = new CachingFileFactory(fileFactory);
    }

    public FileFactory getFileFactory() {
        return this.fileFactory;
    }

    public boolean isAllowZeroLengthFileUpload() {
        return this.allowZeroLengthFileUpload;
    }

    public void setAllowZeroLengthFileUpload(boolean allowZeroLengthFileUpload) {
        this.allowZeroLengthFileUpload = allowZeroLengthFileUpload;
    }

    public void setMaxConcurrentTransfers(int maxConcurrentTransfers) {
        this.maxConcurrentTransfers = maxConcurrentTransfers;
    }

    public int getMaxConcurrentTransfers() {
        return this.maxConcurrentTransfers;
    }

    public void setSupportedSFTPVersion(int sftpVersion) {
        if (sftpVersion < 1 || sftpVersion > 4) {
            throw new IllegalArgumentException("SFTP version must be between 1 and 4");
        }
        this.sftpVersion = sftpVersion;
    }

    public int getSFTPVersion() {
        return this.sftpVersion;
    }

    public void setSFTPReadWriteEvents(boolean sftpReadWriteEvents) {
        this.sftpReadWriteEvents = sftpReadWriteEvents;
    }

    public boolean isSFTPReadWriteEvents() {
        return this.sftpReadWriteEvents;
    }

    public void setSCPReadWriteEvents(boolean scpReadWriteEvents) {
        this.scpReadWriteEvents = scpReadWriteEvents;
    }

    public boolean isSCPReadWriteEvents() {
        return this.scpReadWriteEvents;
    }

    public int getMaximumNumberOfAsyncSFTPRequests() {
        return this.maximumSftpRequests;
    }

    public void setMaximumNumberofAsyncSFTPRequests(int maximumSftpRequests) {
        this.maximumSftpRequests = maximumSftpRequests;
    }

    public String getSFTPLongnameDateFormat() {
        return this.sftpLongnameDateFormat;
    }

    public String getSFTPLongnameDateFormatWithTime() {
        return this.sftpLongnameDateFormatWithTime;
    }

    public void disableSFTPExtension(String requestName) {
        this.disabledExtensions.add(requestName);
    }

    public void enableSFTPExtension(String requestName) {
        this.disabledExtensions.remove(requestName);
    }

    public SftpExtension getSFTPExtension(String requestName) {
        if (this.disabledExtensions.contains(requestName)) {
            return null;
        }
        for (SftpExtensionFactory factory : this.sftpExtensionFactories) {
            if (!factory.getSupportedExtensions().contains(requestName)) continue;
            return factory.getExtension(requestName);
        }
        return null;
    }

    public Collection<SftpExtensionFactory> getSFTPExtensionFactories() {
        return this.sftpExtensionFactories;
    }

    public boolean isSFTPCloseFileBeforeFailedTransferEvents() {
        return this.closeFileBeforeFailedTransferEvents;
    }

    public void setSFTPCloseFileBeforeFailedTransferEvents(boolean closeFileBeforeFailedTransferEvents) {
        this.closeFileBeforeFailedTransferEvents = closeFileBeforeFailedTransferEvents;
    }

    public int getSftpMaxPacketSize() {
        return this.sftpMaxPacketSize;
    }

    public void setSftpMaxPacketSize(int sftpMaxPacketSize) {
        this.sftpMaxPacketSize = sftpMaxPacketSize;
    }

    public UnsignedInteger32 getSftpMaxWindowSize() {
        return this.sftpMaxWindowSize;
    }

    @Deprecated(forRemoval=true, since="3.1.0")
    public void setSftpMaxWindowSize(int sftpMaxWindowSize) {
        this.setSftpMaxWindowSize(new UnsignedInteger32(Integer.toUnsignedLong(sftpMaxWindowSize)));
    }

    public void setSftpMaxWindowSize(UnsignedInteger32 sftpMaxWindowSize) {
        this.sftpMaxWindowSize = sftpMaxWindowSize;
    }

    public UnsignedInteger32 getSftpMinWindowSize() {
        return this.sftpMinWindowSize;
    }

    public void setSftpMinWindowSize(UnsignedInteger32 sftpMinWindowSize) {
        this.sftpMinWindowSize = sftpMinWindowSize;
    }

    @Deprecated(forRemoval=true, since="3.1.0")
    public void setSftpMinWindowSize(int sftpMinWindowSize) {
        this.setSftpMinWindowSize(new UnsignedInteger32(Integer.toUnsignedLong(sftpMinWindowSize)));
    }

    public void setMkdirParentMustExist(boolean mkdirParentMustExist) {
        this.mkdirParentMustExist = mkdirParentMustExist;
    }

    public boolean isMkdirParentMustExist() {
        return this.mkdirParentMustExist;
    }

    class CachingFileFactory
    implements FileFactory {
        private static final String CACHED_FILE_FACTORY = "cachedFileFactory";
        FileFactory fileFactory;

        CachingFileFactory(FileFactory fileFactory) {
            this.fileFactory = fileFactory;
        }

        @Override
        public AbstractFileFactory<?> getFileFactory(SshConnection con) throws IOException, PermissionDeniedException {
            AbstractFileFactory<?> ff = (AbstractFileFactory<?>)con.getProperty(CACHED_FILE_FACTORY);
            if (Objects.isNull(ff)) {
                if (Objects.isNull(this.fileFactory)) {
                    throw new PermissionDeniedException("Invalid file system configuration");
                }
                ff = this.fileFactory.getFileFactory(con);
                con.setProperty(CACHED_FILE_FACTORY, ff);
            }
            return ff;
        }
    }
}

