/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components.jce;

import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.components.SshCipherFactory;
import com.sshtools.common.ssh.components.jce.AbstractJCECipher;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AES128Gcm
extends AbstractJCECipher {
    private static final String CIPHER = "aes128-gcm@openssh.com";
    byte[] key;
    byte[] nonce;
    int mode;

    public AES128Gcm() throws IOException {
        super("AES/GCM/NoPadding", "AES", 16, CIPHER, SecurityLevel.PARANOID, 5000);
    }

    @Override
    public void init(int mode, byte[] iv, byte[] keydata) throws IOException {
        this.mode = mode;
        try {
            this.key = new byte[this.keylength];
            System.arraycopy(keydata, 0, this.key, 0, this.key.length);
            SecretKeySpec kspec = new SecretKeySpec(this.key, this.keyspec);
            this.nonce = new byte[12];
            System.arraycopy(iv, 0, this.nonce, 0, this.nonce.length);
            GCMParameterSpec spec = new GCMParameterSpec(128, this.nonce);
            this.cipher.init(mode == 0 ? 1 : 2, (Key)kspec, spec);
        }
        catch (InvalidKeyException ike) {
            throw new IOException("Invalid encryption key");
        }
        catch (InvalidAlgorithmParameterException ape) {
            throw new IOException("Invalid algorithm parameter");
        }
    }

    @Override
    public void transform(byte[] buf, int start, byte[] output, int off, int len) throws IOException {
        if (len > 0) {
            if (buf.length - start < len) {
                throw new IllegalStateException("Input buffer of " + buf.length + " bytes is too small for requested transform length " + len);
            }
            if (output.length - off < len) {
                throw new IllegalStateException("Output buffer of " + output.length + " bytes is too small for requested transform length " + len);
            }
            try {
                this.cipher = this.createCipher("AES/GCM/NoPadding");
                SecretKeySpec kspec = new SecretKeySpec(this.key, this.keyspec);
                GCMParameterSpec spec = new GCMParameterSpec(128, this.nonce);
                this.cipher.init(this.mode == 0 ? 1 : 2, (Key)kspec, spec);
                this.cipher.updateAAD(buf, start, 4);
                System.arraycopy(buf, start, output, off, 4);
                byte[] tmp = this.cipher.doFinal(buf, start + 4, len - 4);
                System.arraycopy(tmp, 0, output, off + 4, tmp.length);
                this.incrementIv();
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    private void incrementIv() {
        for (int i = 11; i >= 4; --i) {
            int n = i;
            this.nonce[n] = (byte)(this.nonce[n] + 1);
            if (this.nonce[i] != 0) break;
        }
    }

    @Override
    public boolean isMAC() {
        return true;
    }

    @Override
    public int getMacLength() {
        return 16;
    }

    public static class AES128GcmFactory
    implements SshCipherFactory<AES128Gcm> {
        @Override
        public AES128Gcm create() throws NoSuchAlgorithmException, IOException {
            return new AES128Gcm();
        }

        @Override
        public String[] getKeys() {
            return new String[]{AES128Gcm.CIPHER};
        }
    }
}

