/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.shell;

import com.sshtools.common.permissions.Permissions;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.UnsignedInteger32;

public class ShellPolicy
extends Permissions {
    public static final int SHELL = 4096;
    public static final int EXEC = 8192;
    public static final int SUBSYSTEM = 16384;
    int sessionTimeoutSeconds = 0;
    protected int sessionMaxPacketSize = 65536;
    protected UnsignedInteger32 sessionMaxWindowSize = new UnsignedInteger32(1024000L);
    protected UnsignedInteger32 sessionMinWindowSize = new UnsignedInteger32(131072L);

    public ShellPolicy() {
        this.permissions = 28672L;
    }

    protected boolean assertPermission(SshConnection con, int perm, String ... args) {
        return this.check(perm);
    }

    public final boolean checkPermission(SshConnection con, int perm, String ... args) {
        return this.assertPermission(con, perm, args);
    }

    public int getSessionTimeout() {
        return this.sessionTimeoutSeconds;
    }

    public void setSessionTimeout(int sessionTimeoutSeconds) {
        this.sessionTimeoutSeconds = sessionTimeoutSeconds;
    }

    public int getSessionTimeoutSeconds() {
        return this.sessionTimeoutSeconds;
    }

    public void setSessionTimeoutSeconds(int sessionTimeoutSeconds) {
        this.sessionTimeoutSeconds = sessionTimeoutSeconds;
    }

    public int getSessionMaxPacketSize() {
        return this.sessionMaxPacketSize;
    }

    public void setSessionMaxPacketSize(int sessionMaxPacketSize) {
        this.sessionMaxPacketSize = sessionMaxPacketSize;
    }

    public UnsignedInteger32 getSessionMaxWindowSize() {
        return this.sessionMaxWindowSize;
    }

    public void setSessionMaxWindowSize(UnsignedInteger32 sessionMaxWindowSize) {
        this.sessionMaxWindowSize = sessionMaxWindowSize;
    }

    @Deprecated(forRemoval=true, since="3.1.0")
    public void setSessionMaxWindowSize(int sessionMaxWindowSize) {
        this.setSessionMaxWindowSize(new UnsignedInteger32(Integer.toUnsignedLong(sessionMaxWindowSize)));
    }

    public UnsignedInteger32 getSessionMinWindowSize() {
        return this.sessionMinWindowSize;
    }

    public void setSessionMinWindowSize(UnsignedInteger32 sessionMinWindowSize) {
        this.sessionMinWindowSize = sessionMinWindowSize;
    }

    @Deprecated(forRemoval=true, since="3.1.0")
    public void setSessionMinWindowSize(int sessionMinWindowSize) {
        this.setSessionMinWindowSize(new UnsignedInteger32(Integer.toUnsignedLong(sessionMinWindowSize)));
    }
}

