/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.direct;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.direct.DirectFile;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DirectFileJava7
extends DirectFile {
    public DirectFileJava7(String path, AbstractFileFactory<DirectFile> fileFactory, File homeDir) throws IOException {
        super(path, fileFactory, homeDir);
    }

    @Override
    public void setAttributes(SftpFileAttributes attrs) throws IOException {
        String str;
        Path file = FileSystems.getDefault().getPath(this.f.getAbsolutePath(), new String[0]);
        if (attrs.hasModifiedTime()) {
            Files.setLastModifiedTime(file, FileTime.fromMillis(attrs.getModifiedTime().longValue() * 1000L));
        }
        if ((str = attrs.getPermissionsString()) != null && str.length() == 10) {
            String wanted;
            String current = null;
            try {
                current = PosixFilePermissions.toString(Files.getPosixFilePermissions(file, new LinkOption[0]));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (current != null && !Objects.equals(current, wanted = str.substring(1))) {
                Files.setPosixFilePermissions(file, PosixFilePermissions.fromString(wanted));
            }
        }
        if (attrs.hasUID()) {
            // empty if block
        }
    }

    @Override
    public SftpFileAttributes getAttributes() throws IOException {
        if (!this.f.exists()) {
            throw new FileNotFoundException();
        }
        Path file = FileSystems.getDefault().getPath(this.f.getAbsolutePath(), new String[0]);
        BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        SftpFileAttributes attrs = new SftpFileAttributes(this.getFileType(attr), "UTF-8");
        try {
            attrs.setTimes(new UnsignedInteger64(attr.lastAccessTime().toMillis() / 1000L), new UnsignedInteger64(attr.lastModifiedTime().toMillis() / 1000L));
            attrs.setSize(new UnsignedInteger64(attr.size()));
            try {
                PosixFileAttributes posix = Files.readAttributes(file, PosixFileAttributes.class, new LinkOption[0]);
                attrs.setGroup(posix.group().getName());
                attrs.setUsername(posix.owner().getName());
                attrs.setPermissions(PosixFilePermissions.toString(posix.permissions()));
                this.hidden = this.f.getName().startsWith(".");
                return attrs;
            }
            catch (IOException | UnsupportedOperationException posix) {
                try {
                    DosFileAttributes dos = Files.readAttributes(file, DosFileAttributes.class, new LinkOption[0]);
                    this.hidden = dos.isHidden();
                    String read = "r";
                    String write = dos.isReadOnly() ? "-" : "w";
                    String exe = this.f.getName().endsWith(".exe") || this.f.getName().endsWith(".com") || this.f.getName().endsWith(".cmd") ? "x" : "-";
                    attrs.setPermissions(read + write + exe + read + write + exe + read + write + exe);
                }
                catch (IOException | UnsupportedOperationException exception) {}
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return attrs;
    }

    private int getFileType(BasicFileAttributes attr) {
        if (attr.isDirectory()) {
            return 2;
        }
        if (attr.isRegularFile()) {
            return 1;
        }
        if (attr.isSymbolicLink()) {
            return 3;
        }
        if (attr.isOther()) {
            return 4;
        }
        return 5;
    }

    @Override
    public List<AbstractFile> getChildren() throws IOException {
        File[] files = this.f.listFiles();
        if (files == null) {
            throw new IOException(String.format("%s is unreadable.", this.f));
        }
        ArrayList<AbstractFile> files2 = new ArrayList<AbstractFile>();
        for (File f : files) {
            files2.add(new DirectFileJava7(f.getAbsolutePath(), this.fileFactory, this.homeDir));
        }
        return files2;
    }

    @Override
    public AbstractFile resolveFile(String child) throws IOException, PermissionDeniedException {
        File file = new File(child);
        if (!file.isAbsolute()) {
            file = new File(this.f, child);
        }
        return new DirectFileJava7(file.getAbsolutePath(), this.fileFactory, this.homeDir);
    }

    @Override
    public void linkTo(String target) throws IOException, PermissionDeniedException {
        Files.createLink(this.f.toPath(), target.startsWith("/") ? ((DirectFile)this.fileFactory.getFile((String)target)).f.toPath() : this.homeDir.toPath().resolve(target));
    }

    @Override
    public void symlinkTo(String target) throws IOException, PermissionDeniedException {
        Files.createSymbolicLink(this.f.toPath(), target.startsWith("/") ? ((DirectFile)this.fileFactory.getFile((String)target)).f.toPath() : this.homeDir.toPath().resolve(target), new FileAttribute[0]);
    }

    @Override
    public String readSymbolicLink() throws IOException, PermissionDeniedException {
        return Files.readSymbolicLink(this.f.toPath()).toString();
    }
}

