/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components.jce;

import com.sshtools.common.ssh.components.jce.SshEd25519PrivateKey;
import com.sshtools.common.util.IOUtils;
import com.sshtools.common.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.util.Arrays;

public class SshEd25519PrivateKeyJCE
implements SshEd25519PrivateKey {
    PrivateKey key;

    public SshEd25519PrivateKeyJCE(byte[] sk, byte[] pk) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException, NoSuchProviderException {
        this.loadPrivateKey(sk, pk);
    }

    private void loadPrivateKey(byte[] sk, byte[] pk) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyFactory keyFactory = KeyFactory.getInstance("Ed25519", "BC");
        PrivateKeyInfo privKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), (ASN1Encodable)new DEROctetString(Arrays.copyOf((byte[])sk, (int)32)), null, pk);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privKeyInfo.getEncoded());
        this.key = keyFactory.generatePrivate(pkcs8KeySpec);
    }

    public SshEd25519PrivateKeyJCE(PrivateKey prv) {
        this.key = prv;
    }

    @Override
    public byte[] sign(byte[] data) throws IOException {
        return this.sign(data, this.getAlgorithm());
    }

    @Override
    public byte[] sign(byte[] data, String signingAlgorithm) throws IOException {
        try {
            Signature sgr = Signature.getInstance("Ed25519", "BC");
            sgr.initSign(this.key);
            sgr.update(data);
            return sgr.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public String getAlgorithm() {
        return "ssh-ed25519";
    }

    @Override
    public PrivateKey getJCEPrivateKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSeed() {
        ASN1InputStream asn = new ASN1InputStream(this.key.getEncoded());
        try {
            byte[] byArray;
            DLSequence id = (DLSequence)asn.readObject();
            DEROctetString encoded = (DEROctetString)id.getObjectAt(2).toASN1Primitive();
            ASN1InputStream in = new ASN1InputStream((InputStream)new ByteArrayInputStream(encoded.getOctets()));
            try {
                DEROctetString obj = (DEROctetString)in.readObject();
                byArray = obj.getOctets();
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeStream((InputStream)in);
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to parse ASN output of JCE key", e);
                }
            }
            IOUtils.closeStream((InputStream)in);
            return byArray;
        }
        finally {
            IOUtils.closeStream((InputStream)asn);
        }
    }

    public int hashCode() {
        return new String(Utils.bytesToHex((byte[])this.getSeed())).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SshEd25519PrivateKeyJCE)) {
            return false;
        }
        return this.getJCEPrivateKey().equals(((SshEd25519PrivateKeyJCE)obj).getJCEPrivateKey());
    }
}

