/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentFactory;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.NoneCipher;
import com.sshtools.common.ssh.components.NoneHmac;
import com.sshtools.common.ssh.components.SshCipher;
import com.sshtools.common.ssh.components.SshDsaPrivateKey;
import com.sshtools.common.ssh.components.SshDsaPublicKey;
import com.sshtools.common.ssh.components.SshHmac;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.SshRsaPrivateCrtKey;
import com.sshtools.common.ssh.components.SshRsaPrivateKey;
import com.sshtools.common.ssh.components.SshRsaPublicKey;
import com.sshtools.common.ssh.components.SshSecureRandomGenerator;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public abstract class ComponentManager {
    private static boolean enableNoneCipher = false;
    private static boolean enableNoneMac = false;
    protected static boolean enableCbc = false;
    Set<String> disabledAlgorithms = new HashSet<String>();
    Map<String, Map<String, Class<?>>> cachedExternalComponents = new HashMap();
    protected static ComponentManager instance;
    ComponentFactory<SshCipher> ssh1ciphersSC;
    ComponentFactory<SshCipher> ssh2ciphersSC;
    ComponentFactory<SshCipher> ssh1ciphersCS;
    ComponentFactory<SshCipher> ssh2ciphersCS;
    ComponentFactory<SshHmac> hmacsCS;
    ComponentFactory<SshHmac> hmacsSC;
    ComponentFactory<SshPublicKey> publickeys;
    ComponentFactory<Digest> digests;
    static Object lock;

    protected ComponentManager() {
        this.disabledAlgorithms.add("ssh-dss");
    }

    public void disableAlgorithm(String algorithm) {
        this.disabledAlgorithms.add(algorithm);
    }

    public boolean isDisabled(String algorithm) {
        return this.disabledAlgorithms.contains(algorithm);
    }

    public void enableAlgorithm(String algorithm) {
        this.disabledAlgorithms.remove(algorithm);
    }

    public static boolean isEnableNoneCipher() {
        return enableNoneCipher;
    }

    public static void setEnableNoneCipher(boolean enableNoneCipher) {
        ComponentManager.enableNoneCipher = enableNoneCipher;
    }

    public static boolean isEnableNoneMac() {
        return enableNoneMac;
    }

    public static void setEnableNoneMac(boolean enableNoneCipher) {
        enableNoneMac = enableNoneCipher;
    }

    public static void enableCBCCiphers() {
        enableCbc = true;
    }

    public static void disableCBCCiphers() {
        enableCbc = false;
    }

    public static ComponentManager getInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance != null) {
                return instance;
            }
            try {
                instance = new JCEComponentManager();
                instance.init();
                return instance;
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to locate a cryptographic provider", e);
            }
        }
    }

    public static ComponentManager getDefaultInstance() {
        return ComponentManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = lock;
        synchronized (object) {
            instance = null;
            ComponentManager.getInstance();
        }
    }

    protected void init() throws SshException {
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing SSH2 server->client ciphers", (Object[])new Object[0]);
        }
        this.ssh2ciphersSC = new ComponentFactory(this);
        this.initializeSsh2CipherFactory(this.ssh2ciphersSC);
        if (enableNoneCipher) {
            this.ssh2ciphersSC.add("none", NoneCipher.class);
            if (Log.isInfoEnabled()) {
                Log.info((String)"   none will be a supported cipher", (Object[])new Object[0]);
            }
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing SSH2 client->server ciphers", (Object[])new Object[0]);
        }
        this.ssh2ciphersCS = new ComponentFactory(this);
        this.initializeSsh2CipherFactory(this.ssh2ciphersCS);
        if (enableNoneCipher) {
            this.ssh2ciphersCS.add("none", NoneCipher.class);
            if (Log.isInfoEnabled()) {
                Log.info((String)"   none will be a supported cipher", (Object[])new Object[0]);
            }
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing SSH2 server->client HMACs", (Object[])new Object[0]);
        }
        this.hmacsSC = new ComponentFactory(this);
        this.initializeHmacFactory(this.hmacsSC);
        if (enableNoneMac) {
            this.hmacsSC.add("none", NoneHmac.class);
            if (Log.isInfoEnabled()) {
                Log.info((String)"   none will be a supported hmac", (Object[])new Object[0]);
            }
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing SSH2 client->server HMACs", (Object[])new Object[0]);
        }
        this.hmacsCS = new ComponentFactory(this);
        this.initializeHmacFactory(this.hmacsCS);
        if (enableNoneMac) {
            this.hmacsCS.add("none", NoneHmac.class);
            if (Log.isInfoEnabled()) {
                Log.info((String)"   none will be a supported hmac", (Object[])new Object[0]);
            }
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing public keys", (Object[])new Object[0]);
        }
        this.publickeys = new ComponentFactory(this);
        this.initializePublicKeyFactory(this.publickeys);
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing digests", (Object[])new Object[0]);
        }
        this.digests = new ComponentFactory(this);
        this.initializeDigestFactory(this.digests);
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing Secure Random Number Generator", (Object[])new Object[0]);
        }
        this.getRND().nextInt();
    }

    protected abstract void initializeSsh2CipherFactory(ComponentFactory<SshCipher> var1);

    protected abstract void initializeHmacFactory(ComponentFactory<SshHmac> var1);

    protected abstract void initializePublicKeyFactory(ComponentFactory<SshPublicKey> var1);

    protected abstract void initializeDigestFactory(ComponentFactory<Digest> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(ComponentManager instance) {
        Object object = lock;
        synchronized (object) {
            ComponentManager.instance = instance;
        }
    }

    public ComponentFactory<SshCipher> supportedSsh1CiphersSC() {
        return (ComponentFactory)this.ssh1ciphersSC.clone();
    }

    public ComponentFactory<SshCipher> supportedSsh1CiphersCS() {
        return (ComponentFactory)this.ssh1ciphersCS.clone();
    }

    public ComponentFactory<SshCipher> supportedSsh2CiphersSC() {
        return (ComponentFactory)this.ssh2ciphersSC.clone();
    }

    public ComponentFactory<SshCipher> supportedSsh2CiphersCS() {
        return (ComponentFactory)this.ssh2ciphersCS.clone();
    }

    public ComponentFactory<SshHmac> supportedHMacsSC() {
        return (ComponentFactory)this.hmacsSC.clone();
    }

    public ComponentFactory<SshHmac> supportedHMacsCS() {
        return (ComponentFactory)this.hmacsCS.clone();
    }

    public ComponentFactory<SshPublicKey> supportedPublicKeys() {
        return (ComponentFactory)this.publickeys.clone();
    }

    public ComponentFactory<Digest> supportedDigests() {
        return (ComponentFactory)this.digests.clone();
    }

    public abstract SshKeyPair generateRsaKeyPair(int var1, int var2) throws SshException;

    public abstract SshKeyPair generateEcdsaKeyPair(int var1) throws SshException;

    public abstract SshKeyPair generateEd25519KeyPair() throws SshException;

    public abstract SshRsaPublicKey createRsaPublicKey(BigInteger var1, BigInteger var2) throws SshException;

    public abstract SshRsaPublicKey createSsh2RsaPublicKey() throws SshException;

    public abstract SshRsaPrivateKey createRsaPrivateKey(BigInteger var1, BigInteger var2) throws SshException;

    public abstract SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger var1, BigInteger var2, BigInteger var3, BigInteger var4, BigInteger var5, BigInteger var6) throws SshException;

    public abstract SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger var1, BigInteger var2, BigInteger var3, BigInteger var4, BigInteger var5, BigInteger var6, BigInteger var7, BigInteger var8) throws SshException;

    public abstract SshKeyPair generateDsaKeyPair(int var1) throws SshException;

    public abstract SshDsaPublicKey createDsaPublicKey(BigInteger var1, BigInteger var2, BigInteger var3, BigInteger var4) throws SshException;

    public abstract SshDsaPublicKey createDsaPublicKey();

    public abstract SshDsaPrivateKey createDsaPrivateKey(BigInteger var1, BigInteger var2, BigInteger var3, BigInteger var4, BigInteger var5) throws SshException;

    public abstract SshSecureRandomGenerator getRND() throws SshException;

    public Digest getDigest(String name) throws SshException {
        return this.digests.getInstance(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> void loadExternalComponents(String componentFile, ComponentFactory<T> componentFactory) {
        block13: {
            cachedComponents = this.cachedExternalComponents.get(componentFile);
            if (!Objects.isNull(cachedComponents)) break block13;
            cachedComponents = new HashMap<String, Class<?>>();
            try {
                e = this.getClass().getClassLoader().getResources(componentFile);
                while (e.hasMoreElements()) {
                    in = null;
                    try {
                        in = e.nextElement().openStream();
                        if (!Objects.isNull(in)) ** GOTO lbl-1000
                        Log.info((String)"No further components to add", (Object[])new Object[0]);
                        ** GOTO lbl21
                    }
                    catch (IOException ex) {
                        try {
                            Log.error((String)"Error processing {}", (Throwable)ex, (Object[])new Object[]{componentFile});
                        }
                        catch (Throwable var11_14) {
                            IOUtils.closeStream(in);
                            throw var11_14;
                        }
lbl21:
                        // 1 sources

                        IOUtils.closeStream((InputStream)in);
                        return;
lbl-1000:
                        // 1 sources

                        {
                            properties = new Properties();
                            properties.load(in);
                            for (Object alg : properties.keySet()) {
                                clz = properties.getProperty(alg.toString());
                                try {
                                    componenetClz = Class.forName(clz);
                                    cachedComponents.put(alg.toString(), componenetClz);
                                }
                                catch (ClassNotFoundException ex) {
                                    Log.error((String)"Cannot find class {} for algorithm {}", (Object[])new Object[]{clz, alg});
                                }
                            }
                            this.cachedExternalComponents.put(componentFile, cachedComponents);
                        }
                        IOUtils.closeStream((InputStream)in);
                        continue;
                        IOUtils.closeStream((InputStream)in);
                    }
                }
            }
            catch (Throwable ex) {
                Log.error((String)"Error processing {}", (Throwable)ex, (Object[])new Object[]{componentFile});
            }
        }
        var4_4 = cachedComponents.entrySet().iterator();
        while (true) {
            if (!var4_4.hasNext()) {
                return;
            }
            e = var4_4.next();
            componentFactory.add(e.getKey(), e.getValue());
        }
    }

    public void setMinimumSecurityLevel(SecurityLevel securityLevel) throws SshException {
        if (Log.isInfoEnabled()) {
            Log.info((String)"Configuring {} Security", (Object[])new Object[]{securityLevel.name()});
        }
        this.setMinimumSecurityLevel(securityLevel, this.ssh2ciphersCS, "Client->Server Ciphers");
        this.setMinimumSecurityLevel(securityLevel, this.ssh2ciphersSC, "Server->Client Ciphers");
        this.setMinimumSecurityLevel(securityLevel, this.hmacsCS, "Client->Server Macs");
        this.setMinimumSecurityLevel(securityLevel, this.hmacsSC, "Server->Client Macs");
        this.setMinimumSecurityLevel(securityLevel, this.publickeys, "Public Keys");
    }

    private void setMinimumSecurityLevel(SecurityLevel securityLevel, ComponentFactory<?> componentFactory, String name) throws SshException {
        if (Log.isInfoEnabled()) {
            Log.info((String)"Configuring {}", (Object[])new Object[]{name});
        }
        componentFactory.configureSecurityLevel(securityLevel);
        if (Log.isInfoEnabled()) {
            Log.info((String)componentFactory.list(""), (Object[])new Object[0]);
        }
    }

    static {
        lock = new Object();
    }
}

