/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.direct;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.AbstractFileImpl;
import com.sshtools.common.files.AbstractFileRandomAccess;
import com.sshtools.common.files.RandomAccessImpl;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpFileAttributes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractDirectFile<T extends AbstractDirectFile<T>>
extends AbstractFileImpl<T> {
    protected File f;
    protected File homeDir;
    protected boolean hidden = false;

    public AbstractDirectFile(String path, AbstractFileFactory<T> fileFactory, File homeDir) throws IOException {
        super(fileFactory);
        this.homeDir = homeDir;
        this.f = new File(path);
        if (!this.f.isAbsolute()) {
            this.f = new File(homeDir, path);
        }
        if (this.f.exists()) {
            this.getAttributes();
        }
        this.hidden = this.f.getName().startsWith(".");
    }

    @Override
    public boolean exists() {
        return this.f.exists();
    }

    @Override
    public boolean createFolder() throws PermissionDeniedException {
        return this.f.mkdirs();
    }

    @Override
    public long lastModified() {
        return this.f.lastModified();
    }

    @Override
    public String getName() {
        return this.f.getName();
    }

    @Override
    public long length() {
        return this.f.length();
    }

    @Override
    public abstract SftpFileAttributes getAttributes() throws IOException;

    @Override
    public boolean isDirectory() {
        return this.f.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.f.isFile();
    }

    @Override
    public String getAbsolutePath() throws IOException {
        return this.f.getAbsolutePath();
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean createNewFile() throws PermissionDeniedException, IOException {
        return this.f.createNewFile();
    }

    @Override
    public void truncate() throws PermissionDeniedException, IOException {
        this.f.delete();
        this.f.createNewFile();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.f);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.f);
    }

    @Override
    public boolean delete(boolean recurse) {
        return this.f.delete();
    }

    @Override
    public void moveTo(AbstractFile f2) throws IOException, PermissionDeniedException {
        this.f.renameTo(new File(f2.getAbsolutePath()));
    }

    @Override
    public void setAttributes(SftpFileAttributes attrs) throws IOException {
        if (attrs.hasModifiedTime()) {
            this.f.setLastModified(attrs.getModifiedTime().longValue() * 1000L);
        }
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.f.getCanonicalPath();
    }

    @Override
    public boolean supportsRandomAccess() {
        return true;
    }

    @Override
    public AbstractFileRandomAccess openFile(boolean writeAccess) throws IOException {
        return new RandomAccessImpl(this.f, writeAccess);
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void refresh() {
    }

    @Override
    protected int doHashCode() {
        return this.f.hashCode();
    }

    @Override
    protected boolean doEquals(Object obj) {
        if (obj instanceof AbstractDirectFile) {
            AbstractDirectFile f2 = (AbstractDirectFile)obj;
            return this.f.equals(f2.f);
        }
        return false;
    }
}

