/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.AbstractRequestFuture;
import com.sshtools.common.ssh.SshConnection;
import java.util.Objects;

public abstract class ConnectionAwareTask
extends AbstractRequestFuture
implements Runnable {
    protected final SshConnection con;
    protected Throwable lastError;

    public ConnectionAwareTask(SshConnection con) {
        if (Objects.isNull(con)) {
            throw new IllegalArgumentException();
        }
        this.con = con;
    }

    protected abstract void doTask() throws Throwable;

    @Override
    public final void run() {
        this.con.getConnectionManager().setupConnection(this.con);
        try {
            this.doTask();
            this.done(true);
        }
        catch (Throwable t) {
            this.lastError = t;
            Log.error((String)"Connection task failed with an error", (Throwable)t, (Object[])new Object[0]);
            this.done(false);
        }
        finally {
            this.con.getConnectionManager().clearConnection();
        }
    }

    public Throwable getLastError() {
        return this.lastError;
    }
}

