/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.direct;

import com.sshtools.common.events.Event;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.direct.AbstractDirectFileFactory;
import com.sshtools.common.files.direct.DirectFile;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class DirectFileFactory
extends AbstractDirectFileFactory<DirectFile> {
    File defaultPath = new File(".");
    static Class<DirectFile> clz = null;
    static Constructor<DirectFile> constructor = null;

    public DirectFileFactory(File homeDirectory) {
        super(homeDirectory);
    }

    @Override
    public DirectFile getFile(String path) throws PermissionDeniedException, IOException {
        if (constructor != null) {
            try {
                return constructor.newInstance(path, this, this.homeDirectory);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return new DirectFile(path, this, this.homeDirectory);
    }

    @Override
    public Event populateEvent(Event evt) {
        return evt;
    }

    static {
        try {
            clz = Class.forName("com.sshtools.common.files.direct.DirectFileJava7");
            constructor = clz.getConstructor(String.class, AbstractFileFactory.class, String.class);
        }
        catch (Throwable e) {
            Log.warn((String)"Falling back to simple DirectFile implementation as current version of Java does not appear to support Path and FileAttributes APIs", (Object[])new Object[0]);
        }
    }
}

