/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.direct;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.direct.DirectFile;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.List;

public class DirectFileJava7
extends DirectFile {
    public DirectFileJava7(String path, AbstractFileFactory<DirectFile> fileFactory, File homeDir) throws IOException {
        super(path, fileFactory, homeDir);
    }

    @Override
    public SftpFileAttributes getAttributes() throws IOException {
        if (!this.f.exists()) {
            throw new FileNotFoundException();
        }
        Path file = FileSystems.getDefault().getPath(this.f.getAbsolutePath(), new String[0]);
        BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        SftpFileAttributes attrs = new SftpFileAttributes(this.getFileType(attr), "UTF-8");
        try {
            attrs.setTimes(new UnsignedInteger64(attr.lastAccessTime().toMillis() / 1000L), new UnsignedInteger64(attr.lastModifiedTime().toMillis() / 1000L));
            attrs.setSize(new UnsignedInteger64(attr.size()));
            try {
                PosixFileAttributes posix = Files.readAttributes(file, PosixFileAttributes.class, new LinkOption[0]);
                attrs.setGID(posix.group().getName());
                attrs.setUID(posix.owner().getName());
                attrs.setPermissions(PosixFilePermissions.toString(posix.permissions()));
                this.hidden = this.f.getName().startsWith(".");
                return attrs;
            }
            catch (IOException | UnsupportedOperationException posix) {
                try {
                    DosFileAttributes dos = Files.readAttributes(file, DosFileAttributes.class, new LinkOption[0]);
                    this.hidden = dos.isHidden();
                    String read = "r";
                    String write = dos.isReadOnly() ? "-" : "w";
                    String exe = this.f.getName().endsWith(".exe") || this.f.getName().endsWith(".com") || this.f.getName().endsWith(".cmd") ? "x" : "-";
                    attrs.setPermissions(read + write + exe + read + write + exe + read + write + exe);
                }
                catch (IOException | UnsupportedOperationException exception) {}
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return attrs;
    }

    private int getFileType(BasicFileAttributes attr) {
        if (attr.isDirectory()) {
            return 2;
        }
        if (attr.isRegularFile()) {
            return 1;
        }
        if (attr.isSymbolicLink()) {
            return 3;
        }
        if (attr.isOther()) {
            return 4;
        }
        return 5;
    }

    @Override
    public List<AbstractFile> getChildren() throws IOException {
        File[] files = this.f.listFiles();
        ArrayList<AbstractFile> files2 = new ArrayList<AbstractFile>();
        for (File f : files) {
            files2.add(new DirectFileJava7(f.getAbsolutePath(), this.fileFactory, this.homeDir));
        }
        return files2;
    }

    @Override
    public AbstractFile resolveFile(String child) throws IOException, PermissionDeniedException {
        return new DirectFileJava7(new File(this.f, child).getAbsolutePath(), this.fileFactory, this.homeDir);
    }
}

